/*
 * Decompiled with CFR 0.152.
 */
package org.iso_relax.verifier.impl;

import jp.gr.xml.relax.dom.DOMVisitorException;
import jp.gr.xml.relax.dom.IDOMVisitor;
import jp.gr.xml.relax.dom.UDOM;
import jp.gr.xml.relax.dom.UDOMVisitor;
import jp.gr.xml.relax.sax.DeclHandlerBase;
import jp.gr.xml.relax.sax.LexicalHandlerBase;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class SAXEventGenerator
implements IDOMVisitor {
    private Node root_;
    private boolean needDocumentEmulation_ = true;
    private String systemID_;
    private String publicID_;
    private DTDHandler dtd_;
    private ContentHandler content_;
    private DeclHandler decl_;
    private LexicalHandler lexical_;
    private ErrorHandler error_;
    private final NamespaceSupport namespace_ = new NamespaceSupport();

    public SAXEventGenerator(Node node) {
        this.root_ = node;
        DefaultHandler defaultHandler = new DefaultHandler();
        this.dtd_ = defaultHandler;
        this.content_ = defaultHandler;
        this.error_ = defaultHandler;
        this.lexical_ = new LexicalHandlerBase();
        this.decl_ = new DeclHandlerBase();
    }

    public void setDocumentEmulation(boolean bl) {
        this.needDocumentEmulation_ = bl;
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtd_ = dTDHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.content_ = contentHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexical_ = lexicalHandler;
    }

    public void setDeclHandler(DeclHandler declHandler) {
        this.decl_ = declHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.error_ = errorHandler;
    }

    public void makeEvent() throws SAXException {
        try {
            if (!(this.root_ instanceof Document) && this.needDocumentEmulation_) {
                this.emulateStartDocument();
                UDOMVisitor.traverse(this.root_, this);
                this.emulateEndDocument();
            } else {
                UDOMVisitor.traverse(this.root_, this);
            }
        }
        catch (DOMVisitorException dOMVisitorException) {
            Exception exception = dOMVisitorException.getCauseException();
            if (exception == null) {
                throw new SAXException(dOMVisitorException.getMessage());
            }
            if (exception instanceof SAXException) {
                throw (SAXException)exception;
            }
            throw new SAXException(dOMVisitorException.getMessage());
        }
    }

    public void makeEvent(ContentHandler contentHandler) throws SAXException {
        this.setContentHandler(contentHandler);
        this.makeEvent();
    }

    public void emulateStartDocument() {
        try {
            this._handleLocator();
            this.content_.startDocument();
        }
        catch (SAXException sAXException) {
            this._errorReport(sAXException);
        }
    }

    public void emulateEndDocument() {
        try {
            this.content_.endDocument();
        }
        catch (SAXException sAXException) {
            this._errorReport(sAXException);
        }
    }

    public boolean enter(Element element) {
        try {
            this.namespace_.pushContext();
            String string2 = element.getNamespaceURI();
            if (string2 == null) {
                string2 = "";
            }
            String string3 = element.getLocalName();
            String string4 = element.getTagName();
            if (string3 == null) {
                string3 = string4;
            }
            NamedNodeMap namedNodeMap = element.getAttributes();
            AttributesImpl attributesImpl = new AttributesImpl();
            int n = namedNodeMap.getLength();
            int n2 = 0;
            while (n2 < n) {
                Attr attr = (Attr)namedNodeMap.item(n2);
                String string5 = attr.getNamespaceURI();
                if (string5 == null) {
                    string5 = "";
                }
                String string6 = attr.getLocalName();
                String string7 = attr.getName();
                if (string6 == null) {
                    string6 = string7;
                }
                String string8 = attr.getValue();
                if (string7.startsWith("xmlns:")) {
                    int n3 = string7.indexOf(58);
                    String string9 = n3 == -1 ? "" : string7.substring(n3 + 1);
                    if (!this.namespace_.declarePrefix(string9, string8)) {
                        this._errorReport("bad prefix = " + string9);
                    } else {
                        this.content_.startPrefixMapping(string9, string8);
                    }
                } else {
                    attributesImpl.addAttribute(string5, string6, string7, "CDATA", string8);
                }
                ++n2;
            }
            this.content_.startElement(string2, string3, string4, attributesImpl);
        }
        catch (SAXException sAXException) {
            this._errorReport(sAXException);
        }
        return true;
    }

    public boolean enter(Attr attr) {
        return false;
    }

    public boolean enter(Text text) {
        try {
            String string2 = text.getData();
            this.content_.characters(string2.toCharArray(), 0, string2.length());
        }
        catch (SAXException sAXException) {
            this._errorReport(sAXException);
        }
        return false;
    }

    public boolean enter(CDATASection cDATASection) {
        try {
            this.lexical_.startCDATA();
            String string2 = cDATASection.getData();
            this.content_.characters(string2.toCharArray(), 0, string2.length());
            this.lexical_.endCDATA();
        }
        catch (SAXException sAXException) {
            this._errorReport(sAXException);
        }
        return false;
    }

    public boolean enter(EntityReference entityReference) {
        try {
            this.lexical_.startEntity(entityReference.getNodeName());
        }
        catch (SAXException sAXException) {
            this._errorReport(sAXException);
        }
        return true;
    }

    public boolean enter(Entity entity) {
        return false;
    }

    public boolean enter(ProcessingInstruction processingInstruction) {
        try {
            this.content_.processingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
        }
        catch (SAXException sAXException) {
            this._errorReport(sAXException);
        }
        return false;
    }

    public boolean enter(Comment comment) {
        try {
            String string2 = comment.getData();
            this.lexical_.comment(string2.toCharArray(), 0, string2.length());
        }
        catch (SAXException sAXException) {
            this._errorReport(sAXException);
        }
        return false;
    }

    public boolean enter(Document document) {
        try {
            this._handleLocator();
            this.content_.startDocument();
            this._handleDoctype(document.getDoctype());
        }
        catch (SAXException sAXException) {
            this._errorReport(sAXException);
        }
        return true;
    }

    private void _handleLocator() {
        if (this.systemID_ == null && this.publicID_ == null) {
            return;
        }
        this._locatorEvent(this.systemID_, this.publicID_);
    }

    private void _locatorEvent(String string2, String string3) {
        LocatorImpl locatorImpl = new LocatorImpl();
        locatorImpl.setSystemId(this.systemID_);
        locatorImpl.setPublicId(this.publicID_);
        locatorImpl.setLineNumber(-1);
        locatorImpl.setColumnNumber(-1);
        this.content_.setDocumentLocator(locatorImpl);
    }

    private void _handleDoctype(DocumentType documentType) {
        try {
            if (documentType == null) {
                return;
            }
            String string2 = documentType.getSystemId();
            String string3 = documentType.getPublicId();
            String string4 = documentType.getInternalSubset();
            if (string2 != null) {
                this.lexical_.startDTD(documentType.getName(), string3, string2);
                if (string4 == null) {
                    this.lexical_.endDTD();
                    this._handleEntities(documentType);
                } else {
                    this._handleEntities(documentType);
                    this.lexical_.endDTD();
                }
            } else {
                this._handleEntities(documentType);
            }
        }
        catch (SAXException sAXException) {
            this._errorReport(sAXException);
        }
    }

    private void _handleEntities(DocumentType documentType) {
        try {
            Object object;
            Object object2;
            NamedNodeMap namedNodeMap = documentType.getEntities();
            int n = namedNodeMap.getLength();
            int n2 = 0;
            while (n2 < n) {
                object2 = (Entity)namedNodeMap.item(n2);
                String string2 = object2.getPublicId();
                String string3 = object2.getSystemId();
                object = object2.getNotationName();
                if (string2 != null || string3 != null) {
                    this._handleExternalEntity(object2.getNodeName(), string2, string3, (String)object);
                } else {
                    this._handleInternalEntity((Entity)object2);
                }
                ++n2;
            }
            object2 = documentType.getNotations();
            int n3 = object2.getLength();
            int n4 = 0;
            while (n4 < n3) {
                object = (Notation)object2.item(n4);
                String string4 = object.getPublicId();
                String string5 = object.getSystemId();
                this.dtd_.notationDecl(object.getNodeName(), string4, string5);
                ++n4;
            }
        }
        catch (SAXException sAXException) {
            this._errorReport(sAXException);
        }
    }

    private void _handleExternalEntity(String string2, String string3, String string4, String string5) {
        try {
            if (string5 == null) {
                this.decl_.externalEntityDecl(string2, string3, string4);
            } else {
                this.dtd_.unparsedEntityDecl(string2, string3, string4, string5);
            }
        }
        catch (SAXException sAXException) {
            this._errorReport(sAXException);
        }
    }

    private void _handleInternalEntity(Entity entity) {
        try {
            this.decl_.internalEntityDecl(entity.getNodeName(), UDOM.getXMLText(entity));
        }
        catch (SAXException sAXException) {
            this._errorReport(sAXException);
        }
    }

    public boolean enter(DocumentType documentType) {
        return false;
    }

    public boolean enter(DocumentFragment documentFragment) {
        return true;
    }

    public boolean enter(Notation notation) {
        return false;
    }

    public boolean enter(Node node) {
        return false;
    }

    public void leave(Element element) {
        try {
            String string2 = element.getNamespaceURI();
            if (string2 == null) {
                string2 = "";
            }
            String string3 = element.getLocalName();
            String string4 = element.getTagName();
            if (string3 == null) {
                string3 = string4;
            }
            this.content_.endElement(string2, string3, string4);
            this.namespace_.popContext();
        }
        catch (SAXException sAXException) {
            this._errorReport(sAXException);
        }
    }

    public void leave(Attr attr) {
    }

    public void leave(Text text) {
    }

    public void leave(CDATASection cDATASection) {
    }

    public void leave(EntityReference entityReference) {
        try {
            this.lexical_.endEntity(entityReference.getNodeName());
        }
        catch (SAXException sAXException) {
            this._errorReport(sAXException);
        }
    }

    public void leave(Entity entity) {
    }

    public void leave(ProcessingInstruction processingInstruction) {
    }

    public void leave(Comment comment) {
    }

    public void leave(Document document) {
        try {
            this.content_.endDocument();
        }
        catch (SAXException sAXException) {
            this._errorReport(sAXException);
        }
    }

    public void leave(DocumentType documentType) {
    }

    public void leave(DocumentFragment documentFragment) {
    }

    public void leave(Notation notation) {
    }

    public void leave(Node node) {
    }

    private void _errorReport(String string2) throws DOMVisitorException {
        this._errorReport(new SAXParseException(string2, this.publicID_, this.systemID_, -1, -1));
    }

    private void _errorReport(SAXException sAXException) throws DOMVisitorException {
        try {
            SAXParseException sAXParseException = sAXException instanceof SAXParseException ? (SAXParseException)sAXException : new SAXParseException(sAXException.getMessage(), this.publicID_, this.systemID_, -1, -1, sAXException);
            this.error_.fatalError(sAXParseException);
            throw new DOMVisitorException(sAXException);
        }
        catch (SAXException sAXException2) {
            throw new DOMVisitorException(sAXException2);
        }
    }
}

