/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl;

import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.AlgorithmSuite;
import com.sun.xml.wss.impl.SecurableSoapMessage;
import com.sun.xml.wss.impl.WSSAssertion;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.StaticPolicyContext;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;

public class ProcessingContextImpl
extends ProcessingContext {
    protected WSSAssertion wssAssertion = null;
    protected Hashtable issuedTokenContextMap = null;
    private static final String TRUST_CLIENT_CREDENTIALS = "TrustClientCredentialHolder";
    private static final String ISSUED_SAML_TOKEN = "IssuedSAMLToken";
    private static final String SAMLID_VS_KEY_CACHE = "SAMLID_VS_KEY_CACHE";
    private static final String INCOMING_ASSERTION_ID = "Incoming_Saml_Assertion_Id";
    protected AlgorithmSuite algoSuite = null;
    protected boolean policyHasIssuedToken = false;
    protected IssuedTokenContext secureConversationContext = null;
    protected IssuedTokenContext trustContext = null;
    protected MessagePolicy inferredSecurityPolicy = new MessagePolicy();
    protected List signConfirmIds = new ArrayList();
    private boolean isTrustMsg = false;
    private long timestampTimeout = 0L;

    public ProcessingContextImpl() {
    }

    public ProcessingContextImpl(Map invocationProps) {
        this.properties = invocationProps;
    }

    public ProcessingContextImpl(StaticPolicyContext context, SecurityPolicy securityPolicy, SOAPMessage message) throws XWSSecurityException {
        super(context, securityPolicy, message);
    }

    public void copy(ProcessingContext ctxx1, ProcessingContext ctxx2) throws XWSSecurityException {
        if (ctxx2 instanceof ProcessingContextImpl) {
            ProcessingContextImpl ctx1 = (ProcessingContextImpl)ctxx1;
            ProcessingContextImpl ctx2 = (ProcessingContextImpl)ctxx2;
            super.copy(ctx1, ctx2);
            ctx1.setIssuedTokenContextMap(ctx2.getIssuedTokenContextMap());
            ctx1.setAlgorithmSuite(ctx2.getAlgorithmSuite());
            ctx1.setSecureConversationContext(ctx2.getSecureConversationContext());
            ctx1.setWSSAssertion(ctx2.getWSSAssertion());
            ctx1.inferredSecurityPolicy = ctx2.getInferredSecurityPolicy();
            ctx1.isTrustMessage(ctx2.isTrustMessage());
            ctx1.hasIssuedToken(ctx2.hasIssuedToken());
            ctx1.setTimestampTimeout(ctx2.getTimestampTimeout());
        } else {
            super.copy(ctxx1, ctxx2);
        }
    }

    public void setIssuedTokenContextMap(Hashtable issuedTokenContextMap) {
        this.issuedTokenContextMap = issuedTokenContextMap;
    }

    public Hashtable getIssuedTokenContextMap() {
        return this.issuedTokenContextMap;
    }

    public SecurableSoapMessage getSecurableSoapMessage() {
        return this.secureMessage;
    }

    public IssuedTokenContext getIssuedTokenContext(String policyID) {
        if (this.issuedTokenContextMap == null) {
            return null;
        }
        return (IssuedTokenContext)this.issuedTokenContextMap.get(policyID);
    }

    public void setIssuedTokenContext(IssuedTokenContext issuedTokenContext, String policyID) {
        if (this.issuedTokenContextMap == null) {
            this.issuedTokenContextMap = new Hashtable();
        }
        this.issuedTokenContextMap.put(policyID, issuedTokenContext);
    }

    public void setTrustCredentialHolder(IssuedTokenContext ctx) {
        this.getExtraneousProperties().put(TRUST_CLIENT_CREDENTIALS, ctx);
    }

    public IssuedTokenContext getTrustCredentialHolder() {
        return (IssuedTokenContext)this.getExtraneousProperties().get(TRUST_CLIENT_CREDENTIALS);
    }

    public Element getIssuedSAMLToken() {
        return (Element)this.getExtraneousProperties().get(ISSUED_SAML_TOKEN);
    }

    public void setIssuedSAMLToken(Element elem) {
        this.getExtraneousProperties().put(ISSUED_SAML_TOKEN, elem);
    }

    public void setIncomingAssertionId(String assid) {
        this.getExtraneousProperties().put(INCOMING_ASSERTION_ID, assid);
    }

    public String getIncomingAssertionId() {
        return (String)this.getExtraneousProperties().get(INCOMING_ASSERTION_ID);
    }

    public void setSecureConversationContext(IssuedTokenContext ctx) {
        this.secureConversationContext = ctx;
    }

    public IssuedTokenContext getSecureConversationContext() {
        return this.secureConversationContext;
    }

    public void setTrustContext(IssuedTokenContext ctx) {
        this.trustContext = ctx;
    }

    public IssuedTokenContext getTrustContext() {
        return this.trustContext;
    }

    public AlgorithmSuite getAlgorithmSuite() {
        return this.algoSuite;
    }

    public void setAlgorithmSuite(AlgorithmSuite suite) {
        this.algoSuite = suite;
    }

    public void setWSSAssertion(WSSAssertion wssAssertion) {
        this.wssAssertion = wssAssertion;
    }

    public WSSAssertion getWSSAssertion() {
        return this.wssAssertion;
    }

    public MessagePolicy getInferredSecurityPolicy() {
        return this.inferredSecurityPolicy;
    }

    public HashMap getSamlIdVSKeyCache() {
        if (this.getExtraneousProperties().get(SAMLID_VS_KEY_CACHE) == null) {
            this.getExtraneousProperties().put(SAMLID_VS_KEY_CACHE, new HashMap());
        }
        return (HashMap)this.getExtraneousProperties().get(SAMLID_VS_KEY_CACHE);
    }

    public void isTrustMessage(boolean isTrust) {
        this.isTrustMsg = isTrust;
    }

    public boolean isTrustMessage() {
        return this.isTrustMsg;
    }

    public List getSignatureConfirmationIds() {
        return this.signConfirmIds;
    }

    public boolean hasIssuedToken() {
        return this.policyHasIssuedToken;
    }

    public void hasIssuedToken(boolean flag) {
        this.policyHasIssuedToken = flag;
    }

    public long getTimestampTimeout() {
        return this.timestampTimeout;
    }

    public void setTimestampTimeout(long timeout) {
        this.timestampTimeout = timeout;
    }
}

