/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.keyinfo;

import com.sun.xml.ws.security.opt.api.SecurityHeaderElement;
import com.sun.xml.ws.security.opt.api.keyinfo.BuilderResult;
import com.sun.xml.ws.security.opt.impl.JAXBFilterProcessingContext;
import com.sun.xml.ws.security.opt.impl.enc.JAXBEncryptedKey;
import com.sun.xml.ws.security.opt.impl.incoming.SAMLAssertion;
import com.sun.xml.ws.security.opt.impl.keyinfo.SecurityTokenReference;
import com.sun.xml.ws.security.opt.impl.keyinfo.TokenBuilder;
import com.sun.xml.ws.security.opt.impl.message.GSHeaderElement;
import com.sun.xml.ws.security.opt.impl.reference.DirectReference;
import com.sun.xml.ws.security.opt.impl.reference.KeyIdentifier;
import com.sun.xml.ws.security.opt.impl.util.NamespaceContextEx;
import com.sun.xml.ws.security.secext10.SecurityTokenReferenceType;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.PrivateKeyBinding;
import com.sun.xml.wss.logging.impl.opt.token.LogStringsMessages;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.logging.Level;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class SamlTokenBuilder
extends TokenBuilder {
    private AuthenticationTokenPolicy.SAMLAssertionBinding keyBinding = null;
    private boolean forSign = false;

    public SamlTokenBuilder(JAXBFilterProcessingContext context, AuthenticationTokenPolicy.SAMLAssertionBinding samlBinding, boolean forSign) {
        super(context);
        this.forSign = forSign;
        this.keyBinding = samlBinding;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public BuilderResult process() throws XWSSecurityException {
        void var10_13;
        BuilderResult result = new BuilderResult();
        String assertionId = null;
        SecurityHeaderElement she = null;
        Element samlAssertion = this.keyBinding.getAssertion();
        if (samlAssertion != null) {
            she = new GSHeaderElement(samlAssertion);
        }
        JAXBEncryptedKey ek = null;
        String asID = "";
        String id = "";
        String keyEncAlgo = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
        X509Certificate x509Cert = null;
        if (samlAssertion != null) {
            asID = samlAssertion.getAttributeNS(null, "AssertionID");
            if (asID == null || asID.length() == 0) {
                id = samlAssertion.getAttributeNS(null, "ID");
                she.setId(id);
            } else {
                she.setId(asID);
            }
        } else {
            she = (SecurityHeaderElement)this.context.getExtraneousProperty("incoming_saml_assertion");
            asID = she.getId();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "SAML Assertion id:" + asID);
        }
        Object var10_10 = null;
        if (this.forSign) {
            PrivateKeyBinding privKBinding = (PrivateKeyBinding)this.keyBinding.getKeyBinding();
            PrivateKey privateKey = privKBinding.getPrivateKey();
            if (privateKey == null) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1810_NULL_PRIVATEKEY_SAML());
                throw new XWSSecurityException("PrivateKey null inside PrivateKeyBinding set for SAML Policy ");
            }
            if (she == null) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1811_NULL_SAML_ASSERTION());
                throw new XWSSecurityException("SAML Assertion is NULL");
            }
            if (this.context.getSecurityHeader().getChildElement(she.getId()) == null) {
                this.context.getSecurityHeader().add(she);
            }
        } else {
            Key key = null;
            SecurityHeaderElement assertion = (SecurityHeaderElement)this.context.getExtraneousProperty("incoming_saml_assertion");
            key = ((SAMLAssertion)assertion).getKey();
            x509Cert = this.context.getSecurityEnvironment().getCertificate(this.context.getExtraneousProperties(), (PublicKey)key, false);
            if (x509Cert == null) {
                logger.log(Level.SEVERE, LogStringsMessages.WSS_1812_MISSING_CERT_SAMLASSERTION());
                throw new XWSSecurityException("Could not locate Certificate corresponding to Key in SubjectConfirmation of SAML Assertion");
            }
            if (!"".equals(this.keyBinding.getKeyAlgorithm())) {
                keyEncAlgo = this.keyBinding.getKeyAlgorithm();
            }
            String dataEncAlgo = SecurityUtil.getDataEncryptionAlgo(this.context);
            SecretKey secretKey = SecurityUtil.generateSymmetricKey(dataEncAlgo);
        }
        Element authorityBinding = this.keyBinding.getAuthorityBinding();
        String referenceType = this.keyBinding.getReferenceType();
        if (referenceType.equals("Embedded")) {
            logger.log(Level.SEVERE, LogStringsMessages.WSS_1813_UNSUPPORTED_EMBEDDEDREFERENCETYPE_SAML());
            throw new XWSSecurityException("Embedded Reference Type for SAML Assertions not supported yet");
        }
        assertionId = she.getId();
        String strId = this.keyBinding.getSTRID();
        if (strId == null) {
            strId = this.context.generateID();
        }
        SecurityTokenReferenceType samlSTR = null;
        if (authorityBinding == null) {
            KeyIdentifier keyIdentifier = new KeyIdentifier(this.context.getSOAPVersion());
            keyIdentifier.setValue(assertionId);
            keyIdentifier.setValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
            samlSTR = elementFactory.createSecurityTokenReference(keyIdentifier);
            if (id != null) {
                ((SecurityTokenReference)samlSTR).setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
            } else {
                ((SecurityTokenReference)samlSTR).setTokenType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
            }
        }
        samlSTR.getAny().add(authorityBinding);
        ((NamespaceContextEx)this.context.getNamespaceContext()).addWSS11NS();
        this.buildKeyInfo((SecurityTokenReference)samlSTR);
        if (!this.forSign) {
            HashMap ekCache = this.context.getEncryptedKeyCache();
            ek = (JAXBEncryptedKey)elementFactory.createEncryptedKey(this.context.generateID(), keyEncAlgo, this.keyInfo, x509Cert.getPublicKey(), (Key)var10_13);
            this.context.getSecurityHeader().add(ek);
            String ekId = ek.getId();
            DirectReference dr = this.buildDirectReference(ekId, "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
            result.setKeyInfo(this.buildKeyInfo(dr, ""));
        } else {
            result.setKeyInfo(this.keyInfo);
        }
        HashMap<String, void> sentSamlKeys = (HashMap<String, void>)this.context.getExtraneousProperty("stored_saml_keys");
        if (sentSamlKeys == null) {
            sentSamlKeys = new HashMap<String, void>();
        }
        sentSamlKeys.put(assertionId, var10_13);
        this.context.setExtraneousProperty("stored_saml_keys", sentSamlKeys);
        result.setDataProtectionKey((Key)var10_13);
        return result;
    }
}

