/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy.sourcemodel;

import com.sun.xml.ws.policy.PolicyConstants;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.privateutil.LocalizationMessages;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.policy.sourcemodel.ModelNode;
import com.sun.xml.ws.policy.sourcemodel.PolicyModelUnmarshaller;
import com.sun.xml.ws.policy.sourcemodel.PolicyReferenceData;
import com.sun.xml.ws.policy.sourcemodel.PolicySourceModel;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

final class XmlPolicyModelUnmarshaller
extends PolicyModelUnmarshaller {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(XmlPolicyModelUnmarshaller.class);

    XmlPolicyModelUnmarshaller() {
    }

    public PolicySourceModel unmarshalModel(Object storage) throws PolicyException {
        XMLEventReader reader = this.createXMLEventReader(storage);
        PolicySourceModel model = null;
        block7: while (reader.hasNext()) {
            try {
                XMLEvent event = reader.peek();
                switch (event.getEventType()) {
                    case 5: 
                    case 7: {
                        reader.nextEvent();
                        break;
                    }
                    case 4: {
                        this.processCharacters(ModelNode.Type.POLICY, event.asCharacters(), null);
                        reader.nextEvent();
                        break;
                    }
                    case 1: {
                        if (ModelNode.Type.POLICY.asQName().equals(event.asStartElement().getName())) {
                            StartElement element = reader.nextEvent().asStartElement();
                            Attribute policyId = this.getAttributeByName(element, PolicyConstants.WSU_ID);
                            Attribute xmlId = this.getAttributeByName(element, PolicyConstants.XML_ID);
                            if (policyId == null) {
                                policyId = xmlId;
                            } else if (xmlId != null) {
                                throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0058_MULTIPLE_POLICY_IDS_NOT_ALLOWED()));
                            }
                            Attribute policyName = this.getAttributeByName(element, PolicyConstants.POLICY_NAME);
                            model = PolicySourceModel.createPolicySourceModel(policyId == null ? null : policyId.getValue(), policyName == null ? null : policyName.getValue());
                            this.unmarshalNodeContent(model.getRootNode(), event.asStartElement(), reader);
                            break block7;
                        }
                    }
                    default: {
                        throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0048_POLICY_ELEMENT_EXPECTED_FIRST()));
                    }
                }
            }
            catch (XMLStreamException e) {
                throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0068_FAILED_TO_UNMARSHALL_POLICY_EXPRESSION(), e));
            }
        }
        return model;
    }

    private void unmarshalNodeContent(ModelNode lastNode, StartElement lastStartElement, XMLEventReader reader) throws PolicyException {
        QName lastElementName = lastStartElement.getName();
        StringBuffer valueBuffer = null;
        block10: while (reader.hasNext()) {
            try {
                XMLEvent xmlParserEvent = reader.nextEvent();
                switch (xmlParserEvent.getEventType()) {
                    case 5: {
                        break;
                    }
                    case 4: {
                        valueBuffer = this.processCharacters(lastNode.getType(), xmlParserEvent.asCharacters(), valueBuffer);
                        break;
                    }
                    case 2: {
                        this.checkEndTagName(lastElementName, xmlParserEvent.asEndElement());
                        break block10;
                    }
                    case 1: {
                        ModelNode childNode;
                        StartElement childElement = xmlParserEvent.asStartElement();
                        QName childElementName = childElement.getName();
                        if (lastNode.getType() == ModelNode.Type.ASSERTION_PARAMETER_NODE) {
                            childNode = lastNode.createChildAssertionParameterNode();
                        } else if (ModelNode.Type.POLICY.asQName().equals(childElementName)) {
                            childNode = lastNode.createChildPolicyNode();
                        } else if (ModelNode.Type.ALL.asQName().equals(childElementName)) {
                            childNode = lastNode.createChildAllNode();
                        } else if (ModelNode.Type.EXACTLY_ONE.asQName().equals(childElementName)) {
                            childNode = lastNode.createChildExactlyOneNode();
                        } else if (ModelNode.Type.POLICY_REFERENCE.asQName().equals(childElementName)) {
                            Attribute uri = this.getAttributeByName(childElement, PolicyReferenceData.ATTRIBUTE_URI);
                            if (uri == null) {
                                throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0040_POLICY_REFERENCE_URI_ATTR_NOT_FOUND()));
                            }
                            try {
                                PolicyReferenceData refData;
                                URI reference = new URI(uri.getValue());
                                Attribute digest = this.getAttributeByName(childElement, PolicyReferenceData.ATTRIBUTE_DIGEST);
                                if (digest == null) {
                                    refData = new PolicyReferenceData(reference);
                                } else {
                                    Attribute digestAlgorithm = this.getAttributeByName(childElement, PolicyReferenceData.ATTRIBUTE_DIGEST_ALGORITHM);
                                    URI algorithmRef = null;
                                    if (digestAlgorithm != null) {
                                        algorithmRef = new URI(digestAlgorithm.getValue());
                                    }
                                    refData = new PolicyReferenceData(reference, digest.getValue(), algorithmRef);
                                }
                                childNode = lastNode.createChildPolicyReferenceNode(refData);
                            }
                            catch (URISyntaxException e) {
                                throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0012_UNABLE_TO_UNMARSHALL_POLICY_MALFORMED_URI(), e));
                            }
                        } else {
                            childNode = lastNode.isAssertionRelatedNode() ? lastNode.createChildAssertionParameterNode() : lastNode.createChildAssertionNode();
                        }
                        this.unmarshalNodeContent(childNode, childElement, reader);
                        break;
                    }
                    default: {
                        throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0011_UNABLE_TO_UNMARSHALL_POLICY_XML_ELEM_EXPECTED()));
                    }
                }
            }
            catch (XMLStreamException e) {
                throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0068_FAILED_TO_UNMARSHALL_POLICY_EXPRESSION(), e));
            }
        }
        if (lastNode.isAssertionRelatedNode()) {
            String visibilityValue;
            HashMap<QName, String> attributeMap = new HashMap<QName, String>();
            Iterator<Attribute> iterator = lastStartElement.getAttributes();
            while (iterator.hasNext()) {
                Attribute nextAttribute = iterator.next();
                QName name = nextAttribute.getName();
                if (attributeMap.containsKey(name)) {
                    throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0059_MULTIPLE_ATTRS_WITH_SAME_NAME_DETECTED_FOR_ASSERTION(nextAttribute.getName(), lastElementName)));
                }
                attributeMap.put(name, nextAttribute.getValue());
            }
            AssertionData nodeData = new AssertionData(lastElementName, valueBuffer == null ? null : valueBuffer.toString(), attributeMap, lastNode.getType());
            if (nodeData.containsAttribute(PolicyConstants.VISIBILITY_ATTRIBUTE) && !"private".equals(visibilityValue = nodeData.getAttributeValue(PolicyConstants.VISIBILITY_ATTRIBUTE))) {
                throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0004_UNEXPECTED_VISIBILITY_ATTR_VALUE(visibilityValue)));
            }
            lastNode.setOrReplaceNodeData(nodeData);
        }
    }

    private XMLEventReader createXMLEventReader(Object storage) throws PolicyException {
        if (!(storage instanceof Reader)) {
            throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0022_STORAGE_TYPE_NOT_SUPPORTED(storage.getClass().getName())));
        }
        try {
            return XMLInputFactory.newInstance().createXMLEventReader((Reader)storage);
        }
        catch (XMLStreamException e) {
            throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0014_UNABLE_TO_INSTANTIATE_READER_FOR_STORAGE(), e));
        }
    }

    private void checkEndTagName(QName expected, EndElement element) throws PolicyException {
        QName actual = element.getName();
        if (!expected.equals(actual)) {
            throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0003_UNMARSHALLING_FAILED_END_TAG_DOES_NOT_MATCH(expected, actual)));
        }
    }

    private StringBuffer processCharacters(ModelNode.Type currentNodeType, Characters characters, StringBuffer currentValueBuffer) throws PolicyException {
        if (characters.isWhiteSpace()) {
            return currentValueBuffer;
        }
        StringBuffer buffer = currentValueBuffer == null ? new StringBuffer() : currentValueBuffer;
        String data = characters.getData();
        if (currentNodeType == ModelNode.Type.ASSERTION || currentNodeType == ModelNode.Type.ASSERTION_PARAMETER_NODE) {
            return buffer.append(data);
        }
        throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_0009_UNEXPECTED_CDATA_ON_SOURCE_MODEL_NODE((Object)currentNodeType, data)));
    }

    private Attribute getAttributeByName(StartElement element, QName attributeName) {
        Attribute attribute = element.getAttributeByName(attributeName);
        if (attribute == null) {
            String localAttributeName = attributeName.getLocalPart();
            Iterator<Attribute> iterator = element.getAttributes();
            while (iterator.hasNext()) {
                Attribute nextAttribute = iterator.next();
                QName aName = nextAttribute.getName();
                boolean attributeFoundByWorkaround = aName.equals(attributeName) || aName.getLocalPart().equals(localAttributeName) && (aName.getPrefix() == null || "".equals(aName.getPrefix()));
                if (!attributeFoundByWorkaround) continue;
                attribute = nextAttribute;
                break;
            }
        }
        return attribute;
    }
}

