/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.common.domains.registry;

import com.sun.enterprise.admin.common.domains.registry.LockingStore;
import com.sun.enterprise.admin.common.domains.registry.PersistentStore;
import com.sun.enterprise.admin.common.domains.registry.TimeoutException;
import com.sun.enterprise.admin.common.domains.registry.Unlocked;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;

class Locked
implements LockingStore {
    private PersistentStore store;
    private RandomAccessFile raf;

    Locked(PersistentStore s, RandomAccessFile r) {
        this.checkNotNull(s, "null store not allowed");
        this.checkNotNull(r, "null Random Access File not allowed");
        this.store = s;
        this.raf = r;
    }

    public long lastModified() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readObject() throws IOException, ClassNotFoundException {
        try {
            Object o = null;
            ObjectInputStream ois = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.store.getStore());
                if (fis.available() > 0) {
                    ois = new ObjectInputStream(fis);
                    o = ois.readObject();
                } else {
                    o = null;
                    fis.close();
                }
            }
            catch (EOFException e) {
                o = null;
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
                if (ois != null) {
                    ois.close();
                }
            }
            return o;
        }
        catch (IOException ioe) {
            this.unlock();
            throw ioe;
        }
        catch (ClassNotFoundException cnfe) {
            this.unlock();
            throw cnfe;
        }
    }

    public void writeObject(Object o) throws IOException, IllegalStateException {
        ObjectOutputStream oos = null;
        FileOutputStream fos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(this.store.getStore(), false));
            oos.writeObject(o);
            oos.flush();
        }
        catch (IOException ioe) {
            this.unlock();
            throw ioe;
        }
        catch (IllegalStateException ise) {
            this.unlock();
            throw ise;
        }
        finally {
            if (fos != null) {
                fos.close();
            }
            if (oos != null) {
                oos.close();
            }
        }
    }

    public void lock() throws IOException, TimeoutException {
    }

    public void unlock() {
        try {
            this.raf.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.store.setState(new Unlocked(this.store));
    }

    protected void finalize() {
        this.unlock();
    }

    private void checkNotNull(Object o, String m) throws NullPointerException {
        if (o == null) {
            throw new NullPointerException(m);
        }
    }
}

