/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands.monitor;

import com.sun.appserv.management.monitor.ApplicationMonitor;
import com.sun.appserv.management.monitor.EJBModuleMonitor;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.appserv.management.monitor.WebModuleVirtualServerMonitor;
import com.sun.appserv.management.monitor.WebServiceEndpointMonitor;
import com.sun.appserv.management.monitor.statistics.WebServiceEndpointAggregateStats;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.cli.commands.monitor.MonitorTask;
import com.sun.enterprise.cli.commands.monitor.MonitorTaskException;
import com.sun.enterprise.cli.framework.CLILogger;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceEndpointMonitorTask
extends MonitorTask {
    private final String displayFormat = "%1$-8s %2$-8s %3$-8s %4$-8s %5$-8s %6$-8s %7$-8s %8$-8s %9$-8s";
    private String appName = null;
    private String moduleName = null;
    private String endpointName = null;

    public WebServiceEndpointMonitorTask(ServerRootMonitor srm, String filter, Timer timer, boolean verbose, File fileName) throws MonitorTaskException {
        super(srm, filter, timer, verbose, fileName);
        if (this.filter == null) {
            this.getDefaultFilter();
        } else {
            StringTokenizer st = new StringTokenizer(this.filter, ":");
            if (st.countTokens() < 2) {
                throw new MonitorTaskException(localStrings.getString("commands.monitor.endpoint_invalid_filter"));
            }
            if (st.countTokens() == 2) {
                this.moduleName = st.nextToken();
                this.endpointName = st.nextToken();
            } else {
                this.appName = st.nextToken();
                this.moduleName = st.nextToken();
                this.endpointName = st.nextToken();
            }
        }
        this.verifyFilterValue();
        String endpointTitle = localStrings.getString("commands.monitor.endpoint_monitoring_title", new Object[]{this.filter});
        String title = String.format("%1$50s", endpointTitle);
        CLILogger.getInstance().printMessage(title);
        this.displayHeader();
    }

    @Override
    public void run() {
        if (this.srm == null) {
            super.cancelMonitorTask();
            return;
        }
        Map webMap = null;
        Map ejbMap = null;
        if (this.appName == null) {
            webMap = this.srm.getWebModuleVirtualServerMonitorMap();
            ejbMap = this.srm.getEJBModuleMonitorMap();
        } else {
            Map appMap = this.srm.getApplicationMonitorMap();
            if (appMap == null || appMap.size() < 1) {
                this.cancelMonitorTask();
                return;
            }
            ApplicationMonitor am = (ApplicationMonitor)appMap.get(this.appName);
            if (am == null) {
                this.cancelMonitorTask();
                return;
            }
            webMap = am.getWebModuleVirtualServerMonitorMap();
            ejbMap = am.getEJBModuleMonitorMap();
        }
        WebServiceEndpointMonitor endpointMonitor = this.getEndpointMonitor(webMap, ejbMap);
        if (endpointMonitor == null) {
            this.cancelMonitorTask();
            return;
        }
        WebServiceEndpointAggregateStats endpointStats = endpointMonitor.getWebServiceEndpointAggregateStats();
        if (this.verbose && this.counter == 25) {
            this.displayHeader();
            this.counter = 0;
        }
        this.displayData(endpointStats);
        if (this.verbose) {
            ++this.counter;
        }
    }

    private WebServiceEndpointMonitor getEndpointMonitor(Map<String, WebModuleVirtualServerMonitor> webMap, Map<String, EJBModuleMonitor> ejbMap) {
        Map endpointMap = null;
        if (webMap != null && webMap.containsKey(this.moduleName)) {
            WebModuleVirtualServerMonitor webmoduleVS = webMap.get(this.moduleName);
            endpointMap = webmoduleVS.getWebServiceEndpointMonitorMap();
        } else if (ejbMap != null && ejbMap.containsKey(this.moduleName)) {
            EJBModuleMonitor ejbModule = ejbMap.get(this.moduleName);
            endpointMap = ejbModule.getWebServiceEndpointMonitorMap();
        } else {
            CLILogger.getInstance().printMessage(localStrings.getString("commands.monitor.unable_to_monitor_endpoint"));
            this.cancelMonitorTask();
        }
        return (WebServiceEndpointMonitor)endpointMap.get(this.endpointName);
    }

    private String[] possibleAppModuleFilters() {
        Map appModuleMap = this.srm.getApplicationMonitorMap();
        Vector<String> webModules = new Vector<String>();
        Vector<String> ejbModules = new Vector<String>();
        if (appModuleMap != null && appModuleMap.size() > 0) {
            String[] appModules;
            for (String appModule : appModules = MapUtil.getKeyStrings((Map)appModuleMap)) {
                ApplicationMonitor am = (ApplicationMonitor)appModuleMap.get(appModule);
                Map innerWebModuleMap = am.getWebModuleVirtualServerMonitorMap();
                webModules.addAll(this.getEndpointsInWebModules(appModule, innerWebModuleMap));
                Map innerEjbModuleMap = am.getEJBModuleMonitorMap();
                ejbModules.addAll(this.getEndpointsInEjbModules(appModule, innerEjbModuleMap));
            }
        }
        Vector<String> combineModules = webModules;
        combineModules.addAll(ejbModules);
        return combineModules.toArray(new String[0]);
    }

    private String[] possibleWebModuleFilters() {
        Map webModuleMap = this.srm.getWebModuleVirtualServerMonitorMap();
        List<String> possibleFilters = this.getEndpointsInWebModules(null, webModuleMap);
        return possibleFilters.toArray(new String[0]);
    }

    private String[] possibleEjbModuleFilters() {
        Map ejbModuleMap = this.srm.getEJBModuleMonitorMap();
        List<String> possibleFilters = this.getEndpointsInEjbModules(null, ejbModuleMap);
        return possibleFilters.toArray(new String[0]);
    }

    private List<String> getEndpointsInWebModules(String appName, Map<String, WebModuleVirtualServerMonitor> webModuleMap) {
        Vector<String> possibleEndpoints = new Vector<String>();
        String[] webModules = MapUtil.getKeyStrings(webModuleMap);
        if (webModuleMap != null && webModuleMap.size() > 0) {
            for (String webModule : webModules) {
                String[] endpoints;
                WebModuleVirtualServerMonitor webmoduleVS = webModuleMap.get(webModule);
                Map endpointMap = webmoduleVS.getWebServiceEndpointMonitorMap();
                for (String endpoint : endpoints = MapUtil.getKeyStrings((Map)endpointMap)) {
                    if (appName == null) {
                        possibleEndpoints.add(webModule + ":" + endpoint);
                        continue;
                    }
                    possibleEndpoints.add(appName + ":" + webModule + ":" + endpoint);
                }
            }
        }
        return possibleEndpoints;
    }

    private List<String> getEndpointsInEjbModules(String appName, Map<String, EJBModuleMonitor> ejbModuleMap) {
        Vector<String> possibleEndpoints = new Vector<String>();
        String[] ejbModules = MapUtil.getKeyStrings(ejbModuleMap);
        if (ejbModuleMap != null && ejbModuleMap.size() > 0) {
            for (String ejbModule : ejbModules) {
                String[] endpoints;
                EJBModuleMonitor ejbModuleMonitor = ejbModuleMap.get(ejbModule);
                Map endpointMap = ejbModuleMonitor.getWebServiceEndpointMonitorMap();
                for (String endpoint : endpoints = MapUtil.getKeyStrings((Map)endpointMap)) {
                    if (appName == null) {
                        possibleEndpoints.add(ejbModule + ":" + endpoint);
                        continue;
                    }
                    possibleEndpoints.add(appName + ":" + ejbModule + ":" + endpoint);
                }
            }
        }
        return possibleEndpoints;
    }

    private void getDefaultFilter() throws MonitorTaskException {
        String[] appModuleFilters = this.possibleAppModuleFilters();
        String[] webModuleFilters = this.possibleWebModuleFilters();
        String[] ejbModuleFilters = this.possibleEjbModuleFilters();
        if (webModuleFilters.length < 1 && appModuleFilters.length < 1 && ejbModuleFilters.length < 1) {
            throw new MonitorTaskException("No value to monitor.");
        }
        if (webModuleFilters.length == 1 && appModuleFilters.length < 1 && ejbModuleFilters.length < 1) {
            this.filter = webModuleFilters[0];
            StringTokenizer st = new StringTokenizer(this.filter, ":");
            this.moduleName = st.nextToken();
            this.endpointName = st.nextToken();
        } else if (webModuleFilters.length < 1 && appModuleFilters.length == 1 && ejbModuleFilters.length < 1) {
            this.filter = appModuleFilters[0];
            StringTokenizer st = new StringTokenizer(this.filter, ":");
            this.appName = st.nextToken();
            this.moduleName = st.nextToken();
            this.endpointName = st.nextToken();
        } else if (webModuleFilters.length < 1 && appModuleFilters.length < 1 && ejbModuleFilters.length == 1) {
            this.filter = ejbModuleFilters[0];
            StringTokenizer st = new StringTokenizer(this.filter, ":");
            this.moduleName = st.nextToken();
            this.endpointName = st.nextToken();
        } else {
            String msg = this.getAvailableFilterMessage(appModuleFilters, webModuleFilters, ejbModuleFilters);
            throw new MonitorTaskException(msg);
        }
    }

    private String getAvailableFilterMessage(String[] appModuleFilters, String[] webModuleFilters, String[] ejbModuleFilters) {
        StringBuffer sb = new StringBuffer();
        sb.append(localStrings.getString("commands.monitor.more_than_one_monitoring_elements"));
        if (webModuleFilters.length > 0) {
            sb.append(localStrings.getString("commands.monitor.available_endpoint_in_webmodule"));
            for (String webmodule : webModuleFilters) {
                sb.append("    ");
                sb.append(webmodule);
                sb.append("\n");
            }
        }
        if (ejbModuleFilters.length > 0) {
            sb.append(localStrings.getString("commands.monitor.available_endpoint_in_ejbmodule"));
            for (String ejbmodule : ejbModuleFilters) {
                sb.append("    ");
                sb.append(ejbmodule);
                sb.append("\n");
            }
        }
        if (appModuleFilters.length > 0) {
            sb.append(localStrings.getString("commands.monitor.available_endpoint_in_appmodule"));
            for (String appmodule : appModuleFilters) {
                sb.append("    ");
                sb.append(appmodule);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyFilterValue() throws MonitorTaskException {
        Map ejbModuleMap;
        if (this.appName != null) {
            Map innerEjbModuleMap;
            Map appModuleMap = this.srm.getApplicationMonitorMap();
            if (!appModuleMap.containsKey(this.appName)) throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist", new Object[]{this.appName}));
            ApplicationMonitor am = (ApplicationMonitor)appModuleMap.get(this.appName);
            Map innerWebModuleMap = am.getWebModuleVirtualServerMonitorMap();
            boolean exist = this.checkIfEndpointExists(innerWebModuleMap, innerEjbModuleMap = am.getEJBModuleMonitorMap());
            if (exist) return;
            throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist_in2", new Object[]{this.endpointName, this.appName, this.moduleName}));
        }
        Map webModuleMap = this.srm.getWebModuleVirtualServerMonitorMap();
        boolean exist = this.checkIfEndpointExists(webModuleMap, ejbModuleMap = this.srm.getEJBModuleMonitorMap());
        if (exist) return;
        throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist_in1", new Object[]{this.endpointName, this.moduleName}));
    }

    private boolean checkIfEndpointExists(Map<String, WebModuleVirtualServerMonitor> webModuleMap, Map<String, EJBModuleMonitor> ejbModuleMap) throws MonitorTaskException {
        Map endpointMap;
        if (webModuleMap.containsKey(this.moduleName)) {
            WebModuleVirtualServerMonitor webmoduleVS = webModuleMap.get(this.moduleName);
            endpointMap = webmoduleVS.getWebServiceEndpointMonitorMap();
        } else if (ejbModuleMap.containsKey(this.moduleName)) {
            EJBModuleMonitor ejbmodule = ejbModuleMap.get(this.moduleName);
            endpointMap = ejbmodule.getWebServiceEndpointMonitorMap();
        } else {
            if (this.appName == null) {
                throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist", new Object[]{this.moduleName}));
            }
            throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist_in1", new Object[]{this.moduleName, this.appName}));
        }
        return endpointMap.containsKey(this.endpointName);
    }

    private void displayHeader() {
        String art = localStrings.getString("commands.monitor.art");
        String maxrt = localStrings.getString("commands.monitor.maxrt");
        String minrt = localStrings.getString("commands.monitor.minrt");
        String rt = localStrings.getString("commands.monitor.rt");
        String tp = localStrings.getString("commands.monitor.tp");
        String taf = localStrings.getString("commands.monitor.taf");
        String tas = localStrings.getString("commands.monitor.tas");
        String tf = localStrings.getString("commands.monitor.tf");
        String tns = localStrings.getString("commands.monitor.tns");
        String header = String.format("%1$-8s %2$-8s %3$-8s %4$-8s %5$-8s %6$-8s %7$-8s %8$-8s %9$-8s", art, maxrt, minrt, rt, tp, taf, tas, tf, tns);
        CLILogger.getInstance().printMessage(header);
        if (this.fileName != null) {
            this.writeToFile(localStrings.getString("commands.monitor.endpoint_write_to_file"));
        }
    }

    private void displayData(WebServiceEndpointAggregateStats stats) {
        String data = String.format("%1$-8s %2$-8s %3$-8s %4$-8s %5$-8s %6$-8s %7$-8s %8$-8s %9$-8s", stats.getAverageResponseTime().getCount(), stats.getMaxResponseTime().getCount(), stats.getMinResponseTime().getCount(), stats.getResponseTime().getCount(), stats.getThroughput().getCurrent().longValue(), stats.getTotalAuthFailures().getCount(), stats.getTotalAuthSuccesses().getCount(), stats.getTotalFaults().getCount(), stats.getTotalNumSuccess().getCount());
        CLILogger.getInstance().printMessage(data);
        if (this.fileName != null) {
            String fileData = String.format("%1$s,%2$s,%3$s,%4$s,%5$s,%6$s,%7$s,%8$s,%9$s", stats.getAverageResponseTime().getCount(), stats.getMaxResponseTime().getCount(), stats.getMinResponseTime().getCount(), stats.getResponseTime().getCount(), stats.getThroughput().getCurrent().longValue(), stats.getTotalAuthFailures().getCount(), stats.getTotalAuthSuccesses().getCount(), stats.getTotalFaults().getCount(), stats.getTotalNumSuccess().getCount());
            this.writeToFile(fileData);
        }
    }

    @Override
    public void displayDetails() {
        String details = localStrings.getString("commands.monitor.endpoint_detail");
        CLILogger.getInstance().printMessage(details);
    }
}

