/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands.monitor;

import com.sun.appserv.management.monitor.ApplicationMonitor;
import com.sun.appserv.management.monitor.EJBModuleMonitor;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.appserv.management.monitor.StatelessSessionBeanMonitor;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.cli.commands.monitor.BeanMonitorTask;
import com.sun.enterprise.cli.commands.monitor.MonitorTaskException;
import com.sun.enterprise.cli.framework.CLILogger;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.Vector;
import javax.management.j2ee.statistics.StatelessSessionBeanStats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatelessSessionBeanMonitorTask
extends BeanMonitorTask {
    private final String displayFormat = "%1$-8s %2$-8s %3$-8s %4$-8s %5$-8s";

    public StatelessSessionBeanMonitorTask(ServerRootMonitor srm, String filter, Timer timer, boolean verbose, File fileName) throws MonitorTaskException {
        super(srm, filter, timer, verbose, fileName);
        if (this.filter == null) {
            this.getDefaultFilter();
        } else {
            StringTokenizer st = new StringTokenizer(this.filter, ":");
            if (st.countTokens() < 2) {
                throw new MonitorTaskException(localStrings.getString("commands.monitor.stateless_session_bean_invalid_filter"));
            }
            if (st.countTokens() == 2) {
                this.ejbName = st.nextToken();
                this.beanName = st.nextToken();
            } else {
                this.appName = st.nextToken();
                this.ejbName = st.nextToken();
                this.beanName = st.nextToken();
            }
            this.verifyFilterValue();
        }
        String statelessSessionBeanTitle = localStrings.getString("commands.montor.stateless_session_bean_title", new Object[]{this.filter});
        String title = String.format("%1$50s", statelessSessionBeanTitle);
        CLILogger.getInstance().printMessage(title);
        this.displayHeader();
    }

    @Override
    public void run() {
        if (this.srm == null) {
            super.cancelMonitorTask();
            return;
        }
        Map ejbMap = null;
        if (this.appName == null) {
            ejbMap = this.srm.getEJBModuleMonitorMap();
        } else {
            Map appMap = this.srm.getApplicationMonitorMap();
            if (appMap == null || appMap.size() < 1) {
                this.cancelMonitorTask();
                return;
            }
            ApplicationMonitor am = (ApplicationMonitor)appMap.get(this.appName);
            ejbMap = am.getEJBModuleMonitorMap();
        }
        if (ejbMap == null || ejbMap.size() < 1) {
            this.cancelMonitorTask();
            return;
        }
        StatelessSessionBeanMonitor monitor = this.getStatelessSessionBeanMonitor(ejbMap);
        if (monitor == null) {
            this.cancelMonitorTask();
            return;
        }
        StatelessSessionBeanStats stat = monitor.getStatelessSessionBeanStats();
        if (this.verbose && this.counter == 25) {
            this.displayHeader();
            this.counter = 0;
        }
        this.displayData(stat);
        if (this.verbose) {
            ++this.counter;
        }
    }

    private StatelessSessionBeanMonitor getStatelessSessionBeanMonitor(Map<String, EJBModuleMonitor> ejbMap) {
        EJBModuleMonitor ejbModuleMonitor = ejbMap.get(this.ejbName);
        Map mdbMap = ejbModuleMonitor.getStatelessSessionBeanMonitorMap();
        return (StatelessSessionBeanMonitor)mdbMap.get(this.beanName);
    }

    @Override
    List<String> getBeansInEjbModule(String appName, Map<String, EJBModuleMonitor> ejbModuleMap) {
        Vector<String> possibleStatelessSessionBeans = new Vector<String>();
        String[] ejbModules = MapUtil.getKeyStrings(ejbModuleMap);
        if (ejbModuleMap != null && ejbModuleMap.size() > 0) {
            for (String ejbModule : ejbModules) {
                String[] statelessBeans;
                EJBModuleMonitor ejbModuleMonitor = ejbModuleMap.get(ejbModule);
                Map beanMap = ejbModuleMonitor.getStatelessSessionBeanMonitorMap();
                for (String statelessBean : statelessBeans = MapUtil.getKeyStrings((Map)beanMap)) {
                    if (appName == null) {
                        possibleStatelessSessionBeans.add(ejbModule + ":" + statelessBean);
                        continue;
                    }
                    possibleStatelessSessionBeans.add(appName + ":" + ejbModule + ":" + statelessBean);
                }
            }
        }
        return possibleStatelessSessionBeans;
    }

    @Override
    boolean checkIfBeanExists(Map<String, EJBModuleMonitor> ejbModuleMap) throws MonitorTaskException {
        if (!ejbModuleMap.containsKey(this.ejbName)) {
            if (this.appName == null) {
                throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist", new Object[]{this.ejbName}));
            }
            throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist_in1", new Object[]{this.ejbName, this.appName}));
        }
        EJBModuleMonitor ejbModuleMonitor = ejbModuleMap.get(this.ejbName);
        Map beanMap = ejbModuleMonitor.getStatelessSessionBeanMonitorMap();
        return beanMap.containsKey(this.beanName);
    }

    private void displayHeader() {
        String methodReadyCount = localStrings.getString("commands.monitor.MethodReadyCount");
        String low = localStrings.getString("commands.monitor.low");
        String high = localStrings.getString("commands.monitor.high");
        String current = localStrings.getString("commands.monitor.current");
        String create = localStrings.getString("commands.monitor.create");
        String remove = localStrings.getString("commands.monitor.remove");
        String header = String.format("%1$20s", methodReadyCount);
        String subHeader = String.format("%1$-8s %2$-8s %3$-8s %4$-8s %5$-8s", low, high, current, create, remove);
        CLILogger.getInstance().printMessage(header);
        CLILogger.getInstance().printMessage(subHeader);
        if (this.fileName != null) {
            this.writeToFile(localStrings.getString("commands.montor.stateless_sesson_bean_write_to_file"));
        }
    }

    private void displayData(StatelessSessionBeanStats stat) {
        String data = String.format("%1$-8s %2$-8s %3$-8s %4$-8s %5$-8s", stat.getMethodReadyCount().getLowWaterMark(), stat.getMethodReadyCount().getHighWaterMark(), stat.getMethodReadyCount().getCurrent(), stat.getCreateCount().getCount(), stat.getRemoveCount().getCount());
        CLILogger.getInstance().printMessage(data);
        if (this.fileName != null) {
            String fileData = String.format("%1$s,%2$s,%3$s,%4$s,%5$s", stat.getMethodReadyCount().getLowWaterMark(), stat.getMethodReadyCount().getHighWaterMark(), stat.getMethodReadyCount().getCurrent(), stat.getCreateCount().getCount(), stat.getRemoveCount().getCount());
            this.writeToFile(fileData);
        }
    }

    @Override
    public void displayDetails() {
        String details = localStrings.getString("commands.monitor.stateless_session_bean_detail");
        CLILogger.getInstance().printMessage(details);
    }
}

