/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands.monitor;

import com.sun.appserv.management.monitor.ConnectorConnectionPoolMonitor;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.appserv.management.monitor.statistics.ConnectionPoolStats;
import com.sun.appserv.management.monitor.statistics.ConnectorConnectionPoolStats;
import com.sun.appserv.management.util.misc.MapUtil;
import com.sun.enterprise.cli.commands.monitor.ConnectionPoolTask;
import com.sun.enterprise.cli.commands.monitor.MonitorTaskException;
import com.sun.enterprise.cli.framework.CLILogger;
import java.io.File;
import java.util.Map;
import java.util.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorPoolMonitorTask
extends ConnectionPoolTask {
    public ConnectorPoolMonitorTask(ServerRootMonitor srm, String filter, Timer timer, boolean verbose, File fileName) throws MonitorTaskException {
        super(srm, filter, timer, verbose, fileName);
        Map connectorMap = srm.getConnectorConnectionPoolMonitorMap();
        if (connectorMap == null) {
            throw new MonitorTaskException(localStrings.getString("commands.monitor.unable_to_monitor_connection_pool"));
        }
        String[] keys = MapUtil.getKeyStrings((Map)connectorMap);
        if (this.filter == null) {
            this.checkForNumberOfElements(keys);
            this.filter = keys[0];
        } else if (!connectorMap.containsKey(this.filter)) {
            throw new MonitorTaskException(localStrings.getString("commands.monitor.does_not_exist", new Object[]{this.filter}));
        }
        String connPoolMonitoring = localStrings.getString("commands.monitor.connection_pool_monitoring", new Object[]{this.filter});
        String title = String.format("%1$50s", connPoolMonitoring);
        CLILogger.getInstance().printMessage(title);
        this.displayHeader();
    }

    @Override
    public void run() {
        if (this.srm == null) {
            super.cancelMonitorTask();
            return;
        }
        Map connectorMap = this.srm.getConnectorConnectionPoolMonitorMap();
        if (connectorMap == null || connectorMap.size() < 1) {
            this.cancelMonitorTask();
            return;
        }
        if (this.verbose && this.counter == 25) {
            this.displayHeader();
            this.counter = 0;
        }
        this.monitorConnectionPool(this.filter, connectorMap);
        if (this.verbose) {
            ++this.counter;
        }
    }

    private void monitorConnectionPool(String element, Map<String, ConnectorConnectionPoolMonitor> connectorMap) {
        ConnectorConnectionPoolMonitor connectorPoolMonitor = connectorMap.get(element);
        ConnectorConnectionPoolStats stats = connectorPoolMonitor.getConnectorConnectionPoolStats();
        this.displayData((ConnectionPoolStats)stats);
    }
}

