/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.JBICommand;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class JBIInstallCommands
extends JBICommand {
    private static final String INSTALL_COMPONENT = "install-jbi-component";
    private static final String INSTALL_SHARED_LIBRARY = "install-jbi-shared-library";
    private static final String DEPLOY_SERVICE_ASSEMBLY = "deploy-jbi-service-assembly";

    public void runCommand() throws CommandException, CommandValidationException {
        block15: {
            String result = "";
            String successKey = "";
            String errorKey = "";
            boolean installFromDomain = false;
            try {
                boolean isUpload = this.getBooleanOption("upload");
                if (!this.preRunInit(isUpload)) break block15;
                String targetName = this.getOption("target");
                String operand = (String)this.getOperands().get(0);
                try {
                    errorKey = this.name.equals(DEPLOY_SERVICE_ASSEMBLY) ? "JBIDeloymentFileNotFound" : "JBIInstallationFileNotFound";
                    operand = this.validateFilePath(errorKey, operand);
                }
                catch (CommandException ce) {
                    installFromDomain = true;
                    if (this.name.equals(INSTALL_COMPONENT)) {
                        result = this.mJbiAdminCommands.installComponentFromDomain(operand, targetName);
                        successKey = "JBISuccessInstallDomainComponent";
                    } else if (this.name.equals(INSTALL_SHARED_LIBRARY)) {
                        result = this.mJbiAdminCommands.installSharedLibraryFromDomain(operand, targetName);
                        successKey = "JBISuccessInstallDomainSharedLibrary";
                    } else if (this.name.equals(DEPLOY_SERVICE_ASSEMBLY)) {
                        result = this.mJbiAdminCommands.deployServiceAssemblyFromDomain(operand, targetName);
                        successKey = "JBISuccessDeployServiceAssembly";
                    }
                    this.processJBIAdminResult(result, successKey);
                }
                if (!installFromDomain) {
                    if (this.name.equals(INSTALL_COMPONENT)) {
                        Properties properties = this.checkForProperties();
                        result = this.mJbiAdminCommands.installComponent(operand, properties, targetName);
                        successKey = "JBISuccessInstallComponent";
                    } else if (this.name.equals(INSTALL_SHARED_LIBRARY)) {
                        result = this.mJbiAdminCommands.installSharedLibrary(operand, targetName);
                        successKey = "JBISuccessInstallSharedLibrary";
                    } else if (this.name.equals(DEPLOY_SERVICE_ASSEMBLY)) {
                        result = this.mJbiAdminCommands.deployServiceAssembly(operand, targetName);
                        successKey = "JBISuccessDeployServiceAssembly";
                    }
                    this.processJBIAdminResult(result, successKey);
                }
            }
            catch (Exception e) {
                this.processTaskException(e);
            }
        }
    }

    private Properties checkForProperties() throws CommandException, CommandValidationException {
        String compProperties = this.getOption("properties");
        Properties properties = new Properties();
        if (compProperties != "") {
            try {
                properties.load(new FileInputStream(compProperties));
            }
            catch (IOException e) {
                properties = this.createPropertiesParam(compProperties);
            }
        }
        return properties;
    }
}

