/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

final class InplaceDomainUpgradeHandler {
    private final String versionKey;
    private final File domainXmlFile;
    private final File domainConfigFolder;
    private final File requiredUpgradedToFile;
    private final DomainConfig dc;
    private static final StringManager lsm = StringManager.getManager(InplaceDomainUpgradeHandler.class);
    private String mSystemId;
    private static final String FILE_PREFIX = ".upgradedTo";
    private static final Map<String, String> VERSION_DTD_SYS_ID_MAP = new HashMap<String, String>();
    private static final String ONEO = "sun-domain_1_0.dtd";
    private static final String ONE1 = "sun-domain_1_1.dtd";
    private static final String ONE2 = "sun-domain_1_2.dtd";
    private static final String ONE3 = "sun-domain_1_3.dtd";

    public InplaceDomainUpgradeHandler(DomainConfig dc) {
        if (dc == null) {
            throw new IllegalArgumentException("null arguments");
        }
        this.dc = dc;
        this.domainXmlFile = new PEFileLayout((RepositoryConfig)dc).getDomainConfigFile();
        if (!this.domainXmlFile.exists() || !this.domainXmlFile.canRead()) {
            String msg = lsm.getString("InplaceUpgradeDomainNotReadable", (Object)dc.getDomainName(), (Object)dc.getDomainRoot());
            throw new IllegalArgumentException(msg);
        }
        this.domainConfigFolder = this.domainXmlFile.getParentFile();
        this.versionKey = Version.getMajorVersion() + Version.getMinorVersion();
        this.requiredUpgradedToFile = new File(this.domainConfigFolder, FILE_PREFIX + this.versionKey);
    }

    void touchUpgradedToFile() throws IOException {
        this.requiredUpgradedToFile.createNewFile();
    }

    boolean needsUpgrade() {
        boolean needed = false;
        if (!this.requiredUpgradedToFile.exists()) {
            String fromDtd = this.getSystemIdFromDtd();
            String fromMap = this.getSystemIdFromMap();
            if (!fromMap.equals(fromDtd)) {
                needed = true;
                String msg = lsm.getString("InplaceUpgradeNeeded", (Object)this.dc.getDomainName(), (Object)fromDtd, (Object)fromMap);
                CLILogger.getInstance().printMessage(msg);
            } else {
                String msg = lsm.getString("InplaceUpgradeNotNeededDtdsMatch", (Object)fromDtd);
                CLILogger.getInstance().printDebugMessage(msg);
            }
        } else {
            String msg = lsm.getString("InplaceUpgradeAlreadyDone", (Object)this.requiredUpgradedToFile.getName());
            CLILogger.getInstance().printDebugMessage(msg);
        }
        return needed;
    }

    private String getSystemIdFromDtd() {
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(this.domainXmlFile));
            XMLReader xr = XMLReaderFactory.createXMLReader();
            InputSource is = new InputSource(bis);
            xr.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String pid, String sid) throws SAXException, IOException {
                    if (sid != null) {
                        InplaceDomainUpgradeHandler.this.mSystemId = sid.trim();
                        String dtdName = sid.substring(sid.lastIndexOf("/"));
                        File dtdFile = new File(new PEFileLayout((RepositoryConfig)InplaceDomainUpgradeHandler.this.dc).getDtdsDir(), dtdName);
                        if (dtdFile.exists()) {
                            return new InputSource(new BufferedInputStream(new FileInputStream(dtdFile)));
                        }
                    }
                    return null;
                }
            });
            xr.parse(is);
            String string = this.mSystemId;
            return string;
        }
        catch (Exception ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception ee) {}
        }
    }

    private String getSystemIdFromMap() {
        String id = "";
        for (String key : VERSION_DTD_SYS_ID_MAP.keySet()) {
            if (!key.startsWith(this.versionKey)) continue;
            id = VERSION_DTD_SYS_ID_MAP.get(key);
        }
        return id;
    }

    static {
        VERSION_DTD_SYS_ID_MAP.put("80", "http://www.sun.com/software/appserver/dtds/sun-domain_1_0.dtd");
        VERSION_DTD_SYS_ID_MAP.put("81", "http://www.sun.com/software/appserver/dtds/sun-domain_1_1.dtd");
        VERSION_DTD_SYS_ID_MAP.put("82", "http://www.sun.com/software/appserver/dtds/sun-domain_1_1.dtd");
        VERSION_DTD_SYS_ID_MAP.put("90", "http://www.sun.com/software/appserver/dtds/sun-domain_1_2.dtd");
        VERSION_DTD_SYS_ID_MAP.put("91", "http://www.sun.com/software/appserver/dtds/sun-domain_1_3.dtd");
    }
}

