/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;

final class AddonControl {
    private final String PACKAGE = "com.sun.enterprise.cli.framework";
    private final String ADDONFACADE = "com.sun.enterprise.addons.AddonFacade";
    private File installRoot = null;
    private Logger logger = null;
    private Class addonFacade = null;

    AddonControl() throws Exception {
        String installDir = System.getProperty("com.sun.aas.installRoot");
        this.installRoot = new File(installDir);
        this.logger = Logger.getLogger("com.sun.enterprise.cli.framework", null);
        this.addonFacade = Class.forName("com.sun.enterprise.addons.AddonFacade");
    }

    void install(File jarFile) throws Throwable {
        try {
            Class[] args = new Class[]{File.class, File.class, Logger.class};
            Method m = this.addonFacade.getMethod("install", args);
            m.invoke(null, this.installRoot, jarFile, this.logger);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    void uninstall(String addon) throws Throwable {
        try {
            Class[] args = new Class[]{File.class, String.class, Logger.class};
            Method m = this.addonFacade.getMethod("uninstall", args);
            m.invoke(null, this.installRoot, addon, this.logger);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    void configureDAS(File domainRoot) throws Throwable {
        try {
            Class[] args = new Class[]{File.class, File.class, Logger.class};
            Method m = this.addonFacade.getMethod("configureDAS", args);
            m.invoke(null, this.installRoot, domainRoot, this.logger);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    void unconfigureDAS(File domainRoot) throws Throwable {
        try {
            Class[] args = new Class[]{File.class, File.class, Logger.class};
            Method m = this.addonFacade.getMethod("unconfigureDAS", args);
            m.invoke(null, this.installRoot, domainRoot, this.logger);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }
}

