/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.enterprise.ee.web.sessmgmt.JxtaBiDiPipeFactory;
import com.sun.enterprise.ee.web.sessmgmt.PipeFactory;
import com.sun.enterprise.ee.web.sessmgmt.PipePoolElement;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PipePool {
    public static final int DEFAULT_INITIAL_SIZE = 100;
    public static final int DEFAULT_UPPER_SIZE = -1;
    public static final int DEFAULT_POLL_TIME = 500;
    private static Logger _logger = null;
    private LinkedBlockingQueue _pool = null;
    private int _upperSize = -1;
    private int _currentUpperPermits = 0;
    private int _pollTime = 500;
    private PipeFactory _pipeFactory = new JxtaBiDiPipeFactory();

    public PipePool(ArrayList pipeWrappers) {
        this._upperSize = -1;
        this._pollTime = 500;
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
        this.initializePool(pipeWrappers);
    }

    public PipePool(int poolSize) {
        this._upperSize = -1;
        this._pollTime = 500;
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
        this.initializePool(poolSize);
    }

    public PipePool(int upperSize, int pollTime, ArrayList pipeWrappers) {
        int thePoolSize = pipeWrappers.size();
        this._pollTime = pollTime;
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
        this._upperSize = upperSize;
        this.initializePool(pipeWrappers);
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
    }

    private void initializePool(ArrayList pipeWrappers) {
        int poolSize = pipeWrappers.size();
        System.out.println("initializePool - pool size: " + poolSize);
        this._pool = poolSize == 0 ? new LinkedBlockingQueue(10) : new LinkedBlockingQueue(poolSize);
        for (int i = 0; i < poolSize; ++i) {
            PipePoolElement nextPipeWrapper = (PipePoolElement)pipeWrappers.get(i);
            try {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("initializePool-pipeWrappers  " + nextPipeWrapper.getClass());
                }
                this._pool.put(nextPipeWrapper);
                continue;
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
    }

    private void initializePool(int poolSize) {
        System.out.println("initializePool - pool size: " + poolSize);
        this._pool = poolSize == 0 ? new LinkedBlockingQueue(10) : new LinkedBlockingQueue(poolSize);
    }

    public PipePoolElement take() throws InterruptedException {
        PipePoolElement pipeWrapper = null;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN TAKE -- POLL_TIME=" + this._pollTime);
        }
        if ((pipeWrapper = (PipePoolElement)this._pool.poll(this._pollTime, TimeUnit.MILLISECONDS)) != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("IN TAKE -- GOT FROM MAIN POOL" + pipeWrapper.getClass());
            }
            return pipeWrapper;
        }
        return pipeWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PipePoolElement takePrevious() throws InterruptedException {
        PipePoolElement pipeWrapper = null;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN TAKE -- POLL_TIME=" + this._pollTime);
        }
        if ((pipeWrapper = (PipePoolElement)this._pool.poll(this._pollTime, TimeUnit.MILLISECONDS)) != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("IN TAKE -- GOT FROM MAIN POOL" + pipeWrapper.getClass());
            }
            return pipeWrapper;
        }
        PipePool pipePool = this;
        synchronized (pipePool) {
            if (this._currentUpperPermits < this._upperSize | this._upperSize < 0) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("IN TAKE -- GOT FROM UPPER POOL");
                }
                pipeWrapper = this._pipeFactory.createPipe();
                System.out.println("new pipeWrapper from factory " + pipeWrapper);
                if (pipeWrapper != null && _logger.isLoggable(Level.FINEST)) {
                    _logger.finest("pipeWrapper CLASS " + pipeWrapper.getClass() + "   " + this._pipeFactory.getClass());
                }
                ++this._currentUpperPermits;
            }
        }
        return pipeWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(PipePoolElement pipeWrapper) throws InterruptedException {
        PipePool pipePool = this;
        synchronized (pipePool) {
            if (this._currentUpperPermits > 0) {
                pipeWrapper.cleanup();
                --this._currentUpperPermits;
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("IN PUT -- PUTTING BACK INTO UPPER POOL");
                }
                return;
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN PUT -- PUTTING BACK INTO LOWER POOL");
        }
        this._pool.put(pipeWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(PipePoolElement pipeWrapper, long timeToWait, TimeUnit timeunit) throws InterruptedException {
        PipePool pipePool = this;
        synchronized (pipePool) {
            if (this._currentUpperPermits > 0) {
                pipeWrapper.cleanup();
                --this._currentUpperPermits;
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("IN OFFER -- PUTTING BACK INTO UPPER POOL");
                }
                return false;
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN OFFER -- PUTTING BACK INTO LOWER POOL");
        }
        return this._pool.offer(pipeWrapper, timeToWait, timeunit);
    }
}

