/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.appserv.ha.spi.BackingStore;
import com.sun.appserv.ha.spi.BackingStoreException;
import com.sun.appserv.ha.spi.CompositeMetadata;
import com.sun.appserv.ha.spi.Metadata;
import com.sun.appserv.ha.spi.SimpleMetadata;
import com.sun.enterprise.ee.web.sessmgmt.JxtaReplicationSender;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationHealthChecker;
import com.sun.enterprise.ee.web.sessmgmt.ReplicationState;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.logging.LogDomains;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.session.IOUtilsCaller;
import org.apache.catalina.session.WebIOUtilsFactory;

public class JxtaBackingStoreImpl
extends BackingStore {
    static final String MODE_WEB = "web";
    static final String MODE_SSO = "sso";
    static final String COMPOSITE_SAVE_COMMAND = "compositeSave";
    static final String VALVE_SAVE_COMMAND = "valveSave";
    static final String REMOVE_COMMAND = "remove";
    static final String REMOVE_EXPIRED_COMMAND = "removeExpired";
    static final String UPDATE_LAST_ACCESS_TIME_COMMAND = "updateLastAccessTime";
    static final String SIZE_COMMAND = "size";
    static final String REMOVE_IDS_COMMAND = "removeIds";
    static final String DUPLICATE_IDS_SEMANTICS_PROPERTY = "duplicate_ids_semantics_property";
    private static final Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
    private IOUtilsCaller webUtilsCaller = null;
    protected boolean _duplicateIdsSemanticsAllowed = false;
    protected Boolean _waitForAckConfigured = null;
    private String _mode = null;
    private String _appid = null;
    private int _idleTimeoutInSeconds = 0;
    private boolean _isCompositeBackingStore = false;

    public JxtaBackingStoreImpl() {
    }

    public JxtaBackingStoreImpl(String appid, Properties env) {
        this._mode = MODE_WEB;
        this._appid = appid;
        this._duplicateIdsSemanticsAllowed = env != null ? (Boolean)env.get(DUPLICATE_IDS_SEMANTICS_PROPERTY) : true;
    }

    public Metadata load(String id) throws BackingStoreException {
        if (!ReplicationHealthChecker.isOkToProceed()) {
            System.out.println("TEST:load called during reshape");
        }
        return this.findSessionViaBroadcast(id);
    }

    public Metadata load(String id, String version) throws BackingStoreException {
        if (!ReplicationHealthChecker.isOkToProceed()) {
            System.out.println("TEST:load called during reshape");
        }
        long versionLong = this.parseLong(version);
        return this.findSessionViaBroadcast(id, versionLong);
    }

    public void save(String id, Metadata value) throws BackingStoreException {
        if (value instanceof SimpleMetadata) {
            this.saveSimple(id, (SimpleMetadata)value);
        } else if (value instanceof CompositeMetadata) {
            this.saveComposite(id, (CompositeMetadata)value);
        }
    }

    public void saveSimple(String id, SimpleMetadata value) throws BackingStoreException {
        if (!ReplicationHealthChecker.isOkToProceed()) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JxtaBackingStore>>saveSimple():id = " + id + "unable to proceed due to health check");
            }
            return;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JxtaBackingStore>>saveSimple():id = " + id);
        }
        ReplicationState transmitState = this.createHttpReplicationState(id, value.getVersion(), value.getLastAccessTime(), value.getMaxInactiveInterval(), value.getExtraParam(), null, value.getState(), null, VALVE_SAVE_COMMAND);
        this.doTransmit(transmitState, this.isWaitForAckConfigured());
    }

    public void saveComposite(String id, CompositeMetadata value) throws BackingStoreException {
        if (!ReplicationHealthChecker.isOkToProceed()) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("JxtaBackingStore>>saveComposite():id = " + id + "unable to proceed due to health check");
            }
            return;
        }
        byte[] compositeState = null;
        try {
            compositeState = this.getByteArrayFromCollection(value.getEntries());
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JxtaBackingStoreImpl>>saveComposite:trunkState=" + value.getState());
            _logger.fine("JxtaBackingStoreImpl>>saveComposite:attrState=" + compositeState);
        }
        ReplicationState transmitState = this.createHttpReplicationState(id, value.getVersion(), value.getLastAccessTime(), value.getMaxInactiveInterval(), value.getExtraParam(), null, compositeState, value.getState(), COMPOSITE_SAVE_COMMAND);
        this.doTransmit(transmitState, this.isWaitForAckConfigured());
    }

    public void updateLastAccessTime(String id, long time, long version) throws BackingStoreException {
        if (!ReplicationHealthChecker.isOkToProceed()) {
            return;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JxtaBackingStoreImpl>>updateLastAccessTime");
        }
        ReplicationState transmitState = new ReplicationState(this._mode, id, this.getApplicationId(), version, time, 0L, null, null, null, UPDATE_LAST_ACCESS_TIME_COMMAND, null, null);
        this.doTransmit(transmitState, this.isWaitForAckConfigured());
    }

    public void remove(String id) throws BackingStoreException {
        if (!ReplicationHealthChecker.isOkToProceed()) {
            return;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JxtaBackingStoreImpl>>remove:id = " + id);
        }
        ReplicationState transmitState = new ReplicationState(this._mode, id, this.getApplicationId(), 0L, 0L, 0L, null, null, null, REMOVE_COMMAND, null, null);
        this.doTransmit(transmitState, this.isWaitForAckConfigured());
    }

    public int removeExpired() throws BackingStoreException {
        if (!ReplicationHealthChecker.isOkToProceed()) {
            return 0;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JxtaBackingStore>>removeExpired");
        }
        ReplicationState transmitState = new ReplicationState(this._mode, this.getApplicationId(), this.getApplicationId(), 0L, 0L, 0L, null, null, null, REMOVE_EXPIRED_COMMAND, null, null);
        this.doTransmit(transmitState, this.isWaitForAckConfigured());
        return 0;
    }

    public int size() throws BackingStoreException {
        int result = -1;
        if (!ReplicationHealthChecker.isOkToProceed()) {
            return result;
        }
        ReplicationState transmitState = ReplicationState.createQueryState(this._mode, this.getApplicationId(), this.getApplicationId(), SIZE_COMMAND);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JxtaBackingStoreImpl>>size:transmittedState=" + transmitState);
        }
        JxtaReplicationSender sender = JxtaReplicationSender.createInstance();
        ReplicationState resultState = sender.sendReplicationState(transmitState);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JxtaBackingStoreImpl>>size:resultState=" + resultState);
        }
        if (resultState != null) {
            try {
                result = (Integer)resultState.getQueryResult();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return result;
    }

    public void destroy() throws BackingStoreException {
    }

    public void removeIds(long msgID, byte[] removedIdsData) throws BackingStoreException {
        if (!ReplicationHealthChecker.isOkToProceed()) {
            return;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JxtaBackingStore>>removeIds");
        }
        String messageId = Long.toString(msgID);
        ReplicationState transmitState = new ReplicationState(this._mode, messageId, this.getApplicationId(), 0L, 0L, 0L, null, null, null, REMOVE_IDS_COMMAND, removedIdsData, null);
        this.doTransmit(transmitState, this.isWaitForAckConfigured());
    }

    protected ReplicationState createHttpReplicationState(String id, long version, long lastAccessTime, long maxInactiveInterval, String extraParam, String instanceName, byte[] sessionState, byte[] sessionTrunkState, String command) {
        ReplicationState transmitState = new ReplicationState(this._mode, id, this._appid, version, lastAccessTime, maxInactiveInterval, extraParam, null, instanceName, command, sessionState, sessionTrunkState);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JxtaBackingStoreImpl>>createHttpReplicationState:transmitState = " + transmitState);
        }
        return transmitState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getByteArray(Object obj) throws IOException {
        byte[] obs;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new ByteArrayOutputStream();
            if (oos == null) {
                oos = new ObjectOutputStream(new BufferedOutputStream(bos));
            }
            oos.writeObject(obj);
            oos.close();
            oos = null;
            obs = bos.toByteArray();
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
        return obs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getByteArrayFromCollection(Collection entries) throws IOException {
        byte[] obs;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        IOUtilsCaller utilsCaller = null;
        try {
            bos = new ByteArrayOutputStream();
            utilsCaller = this.getWebUtilsCaller();
            if (utilsCaller != null) {
                try {
                    oos = utilsCaller.createObjectOutputStream((OutputStream)new BufferedOutputStream(bos), true);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (oos == null) {
                oos = new ObjectOutputStream(new BufferedOutputStream(bos));
            }
            int entriesSize = entries.size();
            oos.writeObject(entriesSize);
            Iterator it = entries.iterator();
            while (it.hasNext()) {
                oos.writeObject(it.next());
            }
            oos.close();
            oos = null;
            obs = bos.toByteArray();
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
        return obs;
    }

    protected IOUtilsCaller getWebUtilsCaller() {
        if (this.webUtilsCaller == null) {
            WebIOUtilsFactory factory = new WebIOUtilsFactory();
            this.webUtilsCaller = factory.createWebIOUtil();
        }
        return this.webUtilsCaller;
    }

    protected ReplicationState doTransmit(ReplicationState transmitState) {
        if (!ReplicationHealthChecker.isOkToProceed()) {
            return null;
        }
        return this.doTransmit(transmitState, true);
    }

    protected ReplicationState doTransmit(ReplicationState transmitState, boolean wait) {
        if (!ReplicationHealthChecker.isOkToProceed()) {
            return null;
        }
        JxtaReplicationSender replicationSender = JxtaReplicationSender.createInstance();
        ReplicationState resultState = replicationSender.sendReplicationState(transmitState, wait, this.isDuplicateIdsSemanticsAllowed());
        return resultState;
    }

    private Metadata findSessionViaBroadcast(String id) {
        ReplicationState state = ReplicationState.createBroadcastQueryState(this.getMode(), id, this.getApplicationId(), this.getInstanceName());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JxtaBackingStoreImpl>>findSessionViaBroadcast:queryInputState=" + state);
            _logger.fine("JxtaBackingStoreImpl>>findSessionViaBroadcast:state = " + state);
        }
        JxtaReplicationSender sender = JxtaReplicationSender.createInstance();
        ReplicationState queryResult = sender.sendReplicationStateQuery(state);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JxtaBackingStoreImpl>>findSessionViaBroadcast:queryResult=" + queryResult);
        }
        Object result = null;
        String userOrSsoId = null;
        if (queryResult != null) {
            userOrSsoId = queryResult.getExtraParam();
            result = !this.isCompositeBackingStore() ? new SimpleMetadata(queryResult.getVersion(), queryResult.getLastAccess(), queryResult.getMaxInactiveInterval(), queryResult.getState(), userOrSsoId) : ReplicationState.createCompositeMetadataFrom(queryResult);
        }
        return result;
    }

    private long parseLong(String s) {
        long result = -1L;
        try {
            result = Long.parseLong(s);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        return result;
    }

    private Metadata findSessionViaBroadcast(String id, long version) {
        ReplicationState state = ReplicationState.createBroadcastQueryState(this.getMode(), id, this.getApplicationId(), version, this.getInstanceName());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JxtaBackingStoreImpl>>findSessionViaBroadcast:queryInputState=" + state);
            _logger.fine("JxtaBackingStoreImpl>>findSessionViaBroadcast:state = " + state);
        }
        JxtaReplicationSender sender = JxtaReplicationSender.createInstance();
        ReplicationState queryResult = sender.sendReplicationStateQuery(state);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("JxtaBackingStoreImpl>>findSessionViaBroadcast:queryResult=" + queryResult);
        }
        Object result = null;
        String userOrSsoId = null;
        if (queryResult != null) {
            userOrSsoId = queryResult.getExtraParam();
            result = !this.isCompositeBackingStore() ? new SimpleMetadata(queryResult.getVersion(), queryResult.getLastAccess(), queryResult.getMaxInactiveInterval(), queryResult.getState(), userOrSsoId) : ReplicationState.createCompositeMetadataFrom(queryResult);
        }
        return result;
    }

    public String getInstanceName() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        return lookup.getServerName();
    }

    String getMode() {
        return this._mode;
    }

    public void setMode(String mode) {
        this._mode = mode;
    }

    String getApplicationId() {
        return this._appid;
    }

    public boolean isCompositeBackingStore() {
        return this._isCompositeBackingStore;
    }

    public void setCompositeBackingStore(boolean value) {
        this._isCompositeBackingStore = value;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("_mode = " + this._mode + "\n");
        sb.append("_appid = " + this._appid + "\n");
        sb.append("_idleTimeoutInSeconds = " + this._idleTimeoutInSeconds);
        return sb.toString();
    }

    public boolean isDuplicateIdsSemanticsAllowed() {
        return this._duplicateIdsSemanticsAllowed;
    }

    public void setDuplicateIdsSemanticsAllowed(boolean value) {
        this._duplicateIdsSemanticsAllowed = value;
    }

    private boolean isWaitForAckConfigured() {
        if (this._waitForAckConfigured == null) {
            ServerConfigLookup lookup = new ServerConfigLookup();
            boolean waitForAckProp = lookup.getWaitForAckPropertyFromConfig();
            this._waitForAckConfigured = new Boolean(waitForAckProp);
        }
        return this._waitForAckConfigured;
    }
}

