/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.impl;

import com.sun.enterprise.admin.common.JMXFileTransfer;
import com.sun.enterprise.admin.jmx.remote.server.rmi.JmxServiceUrlFactory;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.util.JMXConnectorConfig;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.admin.clientreg.InstanceRegistry;
import com.sun.enterprise.ee.admin.servermgmt.DASPropertyReader;
import com.sun.enterprise.ee.admin.servermgmt.InstanceConfig;
import com.sun.enterprise.ee.synchronization.SynchronizationException;
import com.sun.enterprise.ee.synchronization.api.SynchronizationClient;
import com.sun.enterprise.security.store.IdentityManager;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.RelativePathResolver;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.i18n.StringManagerBase;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import javax.management.remote.JMXServiceURL;

public class SynchronizationClientImpl
implements SynchronizationClient {
    private boolean isConnectNeeded = false;
    private JMXFileTransfer jmxFileTrans = null;
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");
    StringManagerBase _strMgr = StringManagerBase.getStringManager((String)_logger.getResourceBundleName());
    private static final StringManager _localStrMgr = StringManager.getManager(SynchronizationClientImpl.class);

    public SynchronizationClientImpl(String instanceName) throws SynchronizationException {
        AdminService aService = AdminService.getAdminService();
        if (aService != null && aService.isDas()) {
            try {
                this.jmxFileTrans = new JMXFileTransfer(InstanceRegistry.getInstanceConnection(instanceName));
                this.isConnectNeeded = false;
                this.jmxFileTrans.setTargetServer(instanceName);
            }
            catch (InstanceException ie) {
                throw new SynchronizationException(this._strMgr.getString("synchronization.api.conn_reg_get_failed", (Object)instanceName), ie);
            }
            catch (IOException ioe) {
                throw new SynchronizationException(this._strMgr.getString("synchronization.api.jmx_ctor_failed", (Object)instanceName), ioe);
            }
        }
        String url = null;
        String user = IdentityManager.getUser();
        if (user == null) {
            String msg = _localStrMgr.getString("ClientUserNotFound", (Object)instanceName);
            throw new RuntimeException(msg);
        }
        String password = IdentityManager.getPassword();
        if (password == null) {
            String msg = _localStrMgr.getString("PassWordNotFound", (Object)instanceName);
            throw new RuntimeException(msg);
        }
        if ("server".compareTo(instanceName) == 0) {
            DASPropertyReader dpr = new DASPropertyReader(new InstanceConfig());
            try {
                dpr.read();
            }
            catch (IOException ioe) {
                String msg = _localStrMgr.getString("DASPropReadNotFound");
                throw new SynchronizationException(msg);
            }
            url = dpr.getJMXURL();
        } else {
            try {
                ConfigContext cfgCtx = ApplicationServer.getServerContext().getConfigContext();
                assert (cfgCtx != null);
                JMXConnectorConfig jmxConfig = ServerHelper.getJMXConnectorInfo((ConfigContext)cfgCtx, (String)instanceName);
                if (jmxConfig == null) {
                    String msg = _localStrMgr.getString("JMXInfoNotFound", (Object)instanceName);
                    throw new RuntimeException(msg);
                }
                JMXServiceURL theUrl = JmxServiceUrlFactory.forRmiWithJndiInAppserver((String)jmxConfig.getHost(), (int)Integer.parseInt(jmxConfig.getPort()));
                url = theUrl.toString();
            }
            catch (ConfigException ce) {
                throw new SynchronizationException(this._strMgr.getString("synchronization.api.jmx_config_ctor_failed", (Object)instanceName), ce);
            }
        }
        try {
            JMXServiceURL jmxurl = new JMXServiceURL(url);
            this.jmxFileTrans = new JMXFileTransfer(jmxurl, user, password, false);
            this.isConnectNeeded = true;
            assert (this.jmxFileTrans != null);
            this.jmxFileTrans.setTargetServer(instanceName);
        }
        catch (IOException ie) {
            throw new SynchronizationException(this._strMgr.getString("synchronization.api.jmx_ctor_failed", (Object)instanceName), ie);
        }
    }

    public void get(String remoteFile, File localFile) throws SynchronizationException {
        this.get(remoteFile, localFile, false);
    }

    public void getAbsolute(String remoteFile, File localFile) throws SynchronizationException {
        this.get(remoteFile, localFile, true);
    }

    private void get(String remoteFile, File localFile, boolean allowAbsolutePath) throws SynchronizationException {
        if (this.jmxFileTrans == null || this.jmxFileTrans.getMBeanServerConnection() == null) {
            throw new SynchronizationException(this._strMgr.getString("synchronization.api.connect_error"));
        }
        String relFile = this.getRelativeDir(remoteFile);
        if (relFile == null) {
            throw new SynchronizationException(_localStrMgr.getString("NotValidParamString", (Object)remoteFile));
        }
        remoteFile = relFile;
        if (!allowAbsolutePath && new File(remoteFile).isAbsolute()) {
            throw new SynchronizationException(this._strMgr.getString("synchronization.api.no_absolute", (Object)remoteFile));
        }
        try {
            if (!localFile.exists()) {
                localFile.createNewFile();
            }
        }
        catch (IOException ioe) {
            throw new SynchronizationException(this._strMgr.getString("synchronization.api.create_local_file_failed", (Object)localFile.getName()), ioe);
        }
        try {
            this.jmxFileTrans.mcDownloadFile(remoteFile, localFile);
        }
        catch (IOException e) {
            throw new SynchronizationException(this._strMgr.getString("synchronization.api.transfer_exception", (Object)remoteFile), e);
        }
    }

    public void get(String remoteFile, String localFile) throws SynchronizationException {
        String resolvedFile = RelativePathResolver.resolvePath((String)localFile);
        if (resolvedFile == null) {
            String msg = _localStrMgr.getString("NotValidResolveString", (Object)localFile);
            throw new SynchronizationException(msg);
        }
        File f = new File(resolvedFile);
        this.get(remoteFile, f);
    }

    public String put(File localFile, String remoteDir) throws SynchronizationException {
        String relFile = this.getRelativeDir(remoteDir);
        if (relFile == null) {
            throw new SynchronizationException(_localStrMgr.getString("NotValidParamString", (Object)remoteDir));
        }
        remoteDir = relFile;
        if (new File(remoteDir).isAbsolute()) {
            throw new SynchronizationException(this._strMgr.getString("synchronization.api.no_absolute", (Object)remoteDir));
        }
        if (this.jmxFileTrans == null || this.jmxFileTrans.getMBeanServerConnection() == null) {
            throw new SynchronizationException(this._strMgr.getString("synchronization.api.connect_error"));
        }
        try {
            return this.jmxFileTrans.uploadFile(localFile, remoteDir);
        }
        catch (IOException e) {
            throw new SynchronizationException(this._strMgr.getString("synchronization.api.transfer_exception", (Object)remoteDir), e);
        }
    }

    public String put(String localFile, String remoteDir) throws SynchronizationException {
        String resolvedFile = RelativePathResolver.resolvePath((String)localFile);
        if (resolvedFile == null) {
            String msg = _localStrMgr.getString("NotValidResolveString", (Object)localFile);
            throw new SynchronizationException(msg);
        }
        File f = new File(resolvedFile);
        return this.put(f, remoteDir);
    }

    public void connect() throws IOException {
        if (this.isConnectNeeded) {
            this.jmxFileTrans.setConnection();
            this.isConnectNeeded = false;
        }
    }

    public void disconnect() throws IOException {
        this.jmxFileTrans.setMBeanServerConnection(null);
    }

    String getRelativeDir(String absolute) {
        if (absolute.charAt(0) != '$') {
            return absolute;
        }
        String prefix = absolute.substring(0, 27);
        if (prefix != null && prefix.compareTo("${com.sun.aas.instanceRoot}") == 0) {
            return absolute.substring(28);
        }
        return null;
    }
}

