/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization.http;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.ee.admin.servermgmt.DASPropertyReader;
import com.sun.enterprise.ee.admin.servermgmt.InstanceConfig;
import com.sun.enterprise.ee.synchronization.SynchronizationRequest;
import com.sun.enterprise.ee.synchronization.http.X509TrustManagerImpl;
import com.sun.enterprise.ee.synchronization.util.io.Utils;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.security.store.IdentityManager;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import sun.misc.BASE64Encoder;

public class HttpUtils {
    protected static final int BUFFER_SIZE = 131072;
    private static final String SYNCHRONIZATION_URI = "/web1/SynchronizationServlet?";
    private static final StringManager _localStrMgr = StringManager.getManager(HttpUtils.class);
    private static Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");

    public static String getSynchronizationURL(ConfigContext ctx) throws ConfigException, IOException {
        String url = null;
        if (ctx != null) {
            DASPropertyReader dpr = new DASPropertyReader(new InstanceConfig());
            dpr.read();
            url = HttpUtils.getSynchronizationURL(ctx, dpr);
        }
        return url;
    }

    public static String getSynchronizationURL(ConfigContext ctx, DASPropertyReader dpr) throws ConfigException, IOException {
        String url = null;
        HttpListener listener = ServerHelper.getHttpListener((ConfigContext)ctx, (String)"server", (String)"admin-listener");
        String host = dpr.getHost();
        String port = listener.getPort();
        if (host == null || port == null) {
            String msg = _localStrMgr.getString("synchronizationUrlError", (Object)host, (Object)port);
            throw new IllegalArgumentException(msg);
        }
        url = listener.isSecurityEnabled() ? "https://" + host + ":" + port + SYNCHRONIZATION_URI : "http://" + host + ":" + port + SYNCHRONIZATION_URI;
        return url;
    }

    public static boolean ping(String url) {
        boolean tf = false;
        try {
            HttpURLConnection conn = (HttpURLConnection)HttpUtils.getConnection(url, false);
            int response = conn.getResponseCode();
            if (response == 200) {
                tf = true;
            }
            conn.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tf;
    }

    public static URLConnection getConnection(String url, boolean post) throws IOException, NoSuchAlgorithmException, KeyManagementException, Exception {
        URL sUrl = new URL(url);
        URLConnection conn = sUrl.openConnection();
        if (post) {
            ((HttpURLConnection)conn).setRequestMethod("POST");
            conn.setDoInput(true);
            conn.setDoOutput(true);
        }
        if (conn instanceof HttpsURLConnection) {
            SSLContext sc = SSLContext.getInstance("SSL");
            TrustManager[] trust = new TrustManager[]{new X509TrustManagerImpl()};
            sc.init(SSLUtils.getKeyManagers(), trust, new SecureRandom());
            SSLSocketFactory sf = sc.getSocketFactory();
            ((HttpsURLConnection)conn).setSSLSocketFactory(sf);
        }
        String user = IdentityManager.getUser();
        String password = IdentityManager.getPassword();
        byte[] encodedPassword = (user + ":" + password).getBytes();
        BASE64Encoder encoder = new BASE64Encoder();
        String auth = encoder.encode(encodedPassword);
        conn.setRequestProperty("Authorization", "Basic " + auth);
        conn.connect();
        return conn;
    }

    public static File downloadFile(String url, SynchronizationRequest synReq) throws IOException, NoSuchAlgorithmException, KeyManagementException, Exception {
        URLConnection conn = HttpUtils.getConnection(url, true);
        OutputStreamWriter out = new OutputStreamWriter(conn.getOutputStream());
        out.write(synReq.getPostData());
        out.write("\r\n");
        out.flush();
        out.close();
        BufferedInputStream bis = new BufferedInputStream(conn.getInputStream());
        File zipFile = Utils.getTempZipFile();
        FileOutputStream fout = new FileOutputStream(zipFile);
        BufferedOutputStream bos = new BufferedOutputStream(fout);
        byte[] buffer = new byte[131072];
        int bytesRead = 0;
        while ((bytesRead = bis.read(buffer, 0, 131072)) != -1) {
            bos.write(buffer, 0, bytesRead);
        }
        bis.close();
        bos.close();
        ((HttpURLConnection)conn).disconnect();
        bis = null;
        bos = null;
        return zipFile;
    }
}

