/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.synchronization;

import com.sun.enterprise.ee.synchronization.BaseRequestMediator;
import com.sun.enterprise.ee.synchronization.cleaner.GroupRequestCleaner;
import com.sun.enterprise.ee.synchronization.tx.Transaction;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseGroupRequestMediator
implements Runnable {
    protected BaseRequestMediator[] _mediators = null;
    protected Exception _exception = null;
    protected boolean _isException = false;
    protected Transaction _tx = null;
    protected static final Logger _logger = Logger.getLogger("javax.ee.enterprise.system.tools.synchronization");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            for (int i = 0; i < this._mediators.length; ++i) {
                this._mediators[i].execute();
            }
            this._tx.voteCommit();
            _logger.log(Level.FINE, "synchronization.vote_commit");
        }
        catch (Exception e) {
            this._tx.voteRollback();
            _logger.log(Level.FINE, "synchronization.vote_rollback");
            this._exception = e;
            this._isException = true;
        }
        finally {
            for (int i = 0; i < this._mediators.length; ++i) {
                this._mediators[i].commit();
            }
            _logger.log(Level.FINE, "synchronization.tran_commit");
            if (this._tx.isCommited()) {
                GroupRequestCleaner ac = new GroupRequestCleaner(this._mediators);
                ac.gc();
            }
        }
    }

    public boolean isException() {
        return this._isException;
    }

    public Exception getException() {
        return this._exception;
    }
}

