/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.servermgmt;

import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.util.TokenValue;
import com.sun.enterprise.admin.util.TokenValueSet;
import com.sun.enterprise.ee.admin.servermgmt.AgentConfig;
import com.sun.enterprise.ee.admin.servermgmt.EEFileLayout;
import com.sun.enterprise.ee.admin.servermgmt.InstanceConfig;
import java.io.File;

public final class EEScriptsTokens {
    public static final String CONFIG_HOME = "CONFIG_HOME";
    public static final String INSTANCE_ROOT = "INSTANCE_ROOT";
    public static final String SERVER_NAME = "SERVER_NAME";
    public static final String DOMAIN_NAME = "DOMAIN_NAME";
    public static final String CLUSTER_NAME = "CLUSTER_NAME";

    public static TokenValueSet getBaseTokenValueSet(RepositoryConfig config) {
        TokenValueSet tokens = new TokenValueSet();
        TokenValue tv = new TokenValue(CONFIG_HOME, config.getConfigRoot());
        tokens.add(tv);
        File instanceRoot = new EEFileLayout(config).getRepositoryDir();
        tv = new TokenValue(INSTANCE_ROOT, instanceRoot.getAbsolutePath());
        tokens.add(tv);
        return tokens;
    }

    public static TokenValueSet getTokenValueSet(AgentConfig agentConfig) {
        TokenValueSet tokens = EEScriptsTokens.getBaseTokenValueSet(agentConfig);
        TokenValue tv = new TokenValue(SERVER_NAME, agentConfig.getAgentName());
        tokens.add(tv);
        return tokens;
    }

    public static TokenValueSet getTokenValueSet(InstanceConfig instanceConfig) {
        TokenValueSet tokens = EEScriptsTokens.getBaseTokenValueSet(instanceConfig);
        TokenValue tv = new TokenValue(SERVER_NAME, instanceConfig.getInstanceName());
        tokens.add(tv);
        tv = new TokenValue(DOMAIN_NAME, instanceConfig.getRepositoryName());
        tokens.add(tv);
        return tokens;
    }
}

