/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.mbeans;

import com.sun.enterprise.admin.servermgmt.InstanceException;
import com.sun.enterprise.admin.servermgmt.RuntimeStatusList;
import com.sun.enterprise.admin.target.Target;
import com.sun.enterprise.admin.target.TargetBuilder;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.admin.util.IAdminConstants;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.ee.admin.ExceptionHandler;
import com.sun.enterprise.ee.admin.mbeans.EEBaseConfigMBean;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.logging.Logger;

public class StatusConfigMBean
extends EEBaseConfigMBean
implements IAdminConstants,
com.sun.enterprise.ee.admin.mbeanapi.StatusConfigMBean {
    private static final TargetType[] VALID_TYPES = new TargetType[]{TargetType.DOMAIN, TargetType.DAS, TargetType.CLUSTER, TargetType.SERVER, TargetType.NODE_AGENT};
    private static final StringManager _strMgr = StringManager.getManager(StatusConfigMBean.class);
    private static Logger _logger = null;
    private static ExceptionHandler _handler = null;

    private static Logger getLogger() {
        if (_logger == null) {
            _logger = Logger.getLogger("javax.ee.enterprise.system.tools.admin");
        }
        return _logger;
    }

    protected static ExceptionHandler getExceptionHandler() {
        if (_handler == null) {
            _handler = new ExceptionHandler(StatusConfigMBean.getLogger());
        }
        return _handler;
    }

    public void clearStatus(String targetName) throws InstanceException {
        try {
            ConfigContext configContext = this.getConfigContext();
            Target target = TargetBuilder.INSTANCE.createTarget(VALID_TYPES, targetName, configContext);
            if (target.getType() == TargetType.NODE_AGENT) {
                this.getNodeAgentsConfigBean().clearRuntimeStatus(target.getNodeAgents()[0].getName());
            } else if (target.getType() == TargetType.DOMAIN) {
                int i;
                Server[] servers = target.getServers();
                int numServers = servers.length;
                NodeAgent[] agents = target.getNodeAgents();
                int numAgents = agents.length;
                for (i = 0; i < numServers; ++i) {
                    this.getServersConfigBean().clearRuntimeStatus(servers[i].getName());
                }
                for (i = 0; i < numAgents; ++i) {
                    this.getNodeAgentsConfigBean().clearRuntimeStatus(agents[i].getName());
                }
            } else {
                Server[] servers = target.getServers();
                int numServers = servers.length;
                for (int i = 0; i < numServers; ++i) {
                    this.getServersConfigBean().clearRuntimeStatus(servers[i].getName());
                }
            }
        }
        catch (Exception ex) {
            throw StatusConfigMBean.getExceptionHandler().handleInstanceException(ex, "eeadmin.clearRuntimeStatus.Exception", targetName);
        }
    }

    public RuntimeStatusList getStatus(String targetName) throws InstanceException {
        try {
            ConfigContext configContext = this.getConfigContext();
            Target target = TargetBuilder.INSTANCE.createTarget("domain", VALID_TYPES, targetName, configContext);
            RuntimeStatusList result = new RuntimeStatusList();
            if (target.getType() == TargetType.NODE_AGENT) {
                result.add((Object)this.getNodeAgentsConfigBean().getRuntimeStatus(target.getNodeAgents()[0].getName()));
            } else if (target.getType() == TargetType.DOMAIN) {
                int i;
                Server[] servers = target.getServers();
                int numServers = servers.length;
                NodeAgent[] agents = target.getNodeAgents();
                int numAgents = agents.length;
                for (i = 0; i < numServers; ++i) {
                    result.add((Object)this.getServersConfigBean().getRuntimeStatus(servers[i].getName()));
                }
                for (i = 0; i < numAgents; ++i) {
                    result.add((Object)this.getNodeAgentsConfigBean().getRuntimeStatus(agents[i].getName()));
                }
            } else {
                Server[] servers = target.getServers();
                int numServers = servers.length;
                if (numServers == 0 && target.getType() == TargetType.CLUSTER) {
                    result.add((Object)this.getClustersConfigBean().getRuntimeStatus(target.getClusters()[0].getName()));
                } else {
                    for (int i = 0; i < numServers; ++i) {
                        result.add((Object)this.getServersConfigBean().getRuntimeStatus(servers[i].getName()));
                    }
                }
            }
            return result;
        }
        catch (Exception ex) {
            throw StatusConfigMBean.getExceptionHandler().handleInstanceException(ex, "eeadmin.getRuntimeStatus.Exception", targetName);
        }
    }
}

