/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.admin.lbadmin.transform;

import com.sun.enterprise.ee.admin.lbadmin.beans.Cluster;
import com.sun.enterprise.ee.admin.lbadmin.beans.WebModule;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.BaseReader;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.ClusterReader;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.HealthCheckerReader;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.InstanceReader;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.LbReaderException;
import com.sun.enterprise.ee.admin.lbadmin.reader.api.WebModuleReader;
import com.sun.enterprise.ee.admin.lbadmin.transform.HealthCheckerVisitor;
import com.sun.enterprise.ee.admin.lbadmin.transform.InstanceVisitor;
import com.sun.enterprise.ee.admin.lbadmin.transform.Visitor;
import com.sun.enterprise.ee.admin.lbadmin.transform.WebModuleVisitor;

public class ClusterVisitor
implements Visitor {
    Cluster _c = null;

    public ClusterVisitor(Cluster c) {
        this._c = c;
    }

    public void visit(BaseReader br) {
        ClusterReader cRdr = (ClusterReader)br;
        try {
            this._c.setName(cRdr.getName());
            this._c.setPolicy(cRdr.getLbPolicy());
            this._c.setPolicyModule(cRdr.getLbPolicyModule());
        }
        catch (LbReaderException le) {
            // empty catch block
        }
        InstanceReader[] iRdrs = null;
        try {
            iRdrs = cRdr.getInstances();
        }
        catch (LbReaderException le) {
            // empty catch block
        }
        if (iRdrs != null && iRdrs.length > 0) {
            int i;
            boolean[] values = new boolean[iRdrs.length];
            for (i = 0; i < iRdrs.length; ++i) {
                values[i] = true;
            }
            this._c.setInstance(values);
            for (i = 0; i < iRdrs.length; ++i) {
                iRdrs[i].accept(new InstanceVisitor(this._c, i));
            }
        }
        HealthCheckerReader hcRdr = null;
        try {
            hcRdr = cRdr.getHealthChecker();
        }
        catch (LbReaderException le) {
            // empty catch block
        }
        if (hcRdr != null) {
            hcRdr.accept(new HealthCheckerVisitor(this._c));
        }
        WebModuleReader[] wRdrs = null;
        try {
            wRdrs = cRdr.getWebModules();
        }
        catch (LbReaderException le) {
            // empty catch block
        }
        if (wRdrs != null && wRdrs.length > 0) {
            WebModule[] wMods = new WebModule[wRdrs.length];
            for (int i = 0; i < wRdrs.length; ++i) {
                wMods[i] = new WebModule();
                wRdrs[i].accept(new WebModuleVisitor(wMods[i], this._c));
            }
            this._c.setWebModule(wMods);
        }
    }
}

