/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.sun.appserv.management.monitor.CallFlowMonitor;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.GuiUtil;
import com.sun.jsftemplating.component.ComponentUtil;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.webui.jsf.component.Tree;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.faces.component.UIComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallFlowHandlers {
    private static String SUCCESS = "success";
    private static String FAILED = "failed";
    private static String[] ADMIN_APP_PREFIX = new String[]{"uri:/asadmin/", "uri:/admingui/", "uri:/theme/", "uri:/docroot/", "uri:/images/", "uri:/js/", "uri:/redirect.html", "uri:/com_sun_web_ui/", "uri:/favicon.ico", "uri:/web1/", "uri:/admin-jsf/", "uri:/resource/libs/", "uri:/theme/com/sun/webui/jsf/", "uri:/commonTask/", "uri:/clusterCommonTask/", "uri:/peTree.jsf", "uri:/header.jsf", "uri:/index.jsf", "uri:/login.jsf", "uri:/clusterProfileTree.jsf", "uri:/appServer", "uri:/clusterCommonTask/", "uri:/peTree.jsf/", "uri:/header.jsf/", "uri:/login.jsf/", "uri:/clusterProfileTree.jsf/", "uri:/appServer/", "uri:/resourceNode/", "uri:/resource/images/", "uri:/resource/js/", "uri:/applications/", "uri:/cluster/", "uri:/configuration/", "uri:/domain/", "uri:/mgmtRules/", "uri:/nodeAgent/", "uri:/standalone/", "uri:/webService/", "uri:/admin-jsf/", "uri:/resource/com_sun_faces_ajax.js", "uri:/resources/", "uri:/glue.js"};
    private static final String LOCALHOST = "127.0.0.1";
    private static final String END_TIMESTAMP_KEY = "end_timestamp";
    static int democount = 0;

    public static void getCallFlowConfigInfo(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        CallFlowMonitor cm = CallFlowHandlers.getCallFlowMonitor((String)handlerCtx.getInputValue("instanceName"));
        if (cm == null) {
            handlerCtx.setOutputValue("hasMonitor", (Object)Boolean.FALSE);
            handlerCtx.setOutputValue("host", (Object)"");
            handlerCtx.setOutputValue("user", (Object)"");
            handlerCtx.setOutputValue("enabled", (Object)Boolean.FALSE);
        } else {
            handlerCtx.setOutputValue("hasMonitor", (Object)Boolean.TRUE);
            handlerCtx.setOutputValue("host", (Object)cm.getCallerIPFilter());
            handlerCtx.setOutputValue("user", (Object)cm.getCallerPrincipalFilter());
            handlerCtx.setOutputValue("enabled", (Object)cm.getEnabled());
        }
    }

    public static void saveCallFlowConfigInfo(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        try {
            CallFlowMonitor cm = CallFlowHandlers.getCallFlowMonitor((String)handlerCtx.getInputValue("instanceName"));
            cm.setCallerIPFilter((String)handlerCtx.getInputValue("host"));
            cm.setCallerPrincipalFilter((String)handlerCtx.getInputValue("user"));
            cm.setEnabled(((Boolean)handlerCtx.getInputValue("enabled")).booleanValue());
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void clearCallFlowData(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        CallFlowMonitor cm = CallFlowHandlers.getCallFlowMonitor((String)handlerCtx.getInputValue("instanceName"));
        if (cm == null) {
            return;
        }
        try {
            cm.clearData();
        }
        catch (Exception ex) {
            GuiUtil.prepareException(handlerCtx, ex);
        }
    }

    public static void getCallFlowDataList(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        String filterValue = (String)handlerCtx.getInputValue("filterValue");
        Boolean demo = (Boolean)handlerCtx.getInputValue("demo");
        ArrayList<Map> result = new ArrayList<Map>();
        try {
            CallFlowMonitor cfm = CallFlowHandlers.getCallFlowMonitor(instanceName);
            if (cfm == null) {
                handlerCtx.setOutputValue("result", result);
                return;
            }
            List listOfMap = cfm.queryRequestInformation();
            if (demo != null && demo.booleanValue()) {
                listOfMap = CallFlowHandlers.queryDemoRequestInformation();
            } else if (listOfMap == null || listOfMap.isEmpty()) {
                handlerCtx.setOutputValue("result", result);
                return;
            }
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, GuiUtil.getLocale());
            for (Map oneRow : listOfMap) {
                Map converted;
                if (!GuiUtil.isEmpty(filterValue) && !CallFlowHandlers.includeRequest(oneRow, filterValue) || (converted = CallFlowHandlers.populateOneRow(oneRow, dateFormat)) == null) continue;
                result.add(converted);
            }
            handlerCtx.setOutputValue("result", result);
            return;
        }
        catch (Exception ex) {
            handlerCtx.setOutputValue("result", result);
            return;
        }
    }

    private static Map populateOneRow(Map oneRow, DateFormat dateFormat) {
        String app = (String)oneRow.get("ApplicationName");
        if (!GuiUtil.isEmpty(app)) {
            for (int i = 0; i < ADMIN_APP_PREFIX.length; ++i) {
                if (!app.toLowerCase().startsWith(ADMIN_APP_PREFIX[i].toLowerCase())) continue;
                return null;
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        String ms = (String)oneRow.get("TimeStampMillis");
        if (!GuiUtil.isEmpty(ms)) {
            map.put("timeStamp", new Long(ms));
            Date date = new Date(Long.parseLong(ms));
            String formattedTime = dateFormat.format(date);
            map.put("timeStampFormatted", formattedTime);
        }
        map.put("requestId", oneRow.get("RequestID"));
        String clientHost = (String)oneRow.get("ClientHost");
        if (LOCALHOST.equals(clientHost)) {
            clientHost = GuiUtil.getMessage("callFlow.localhost");
        }
        map.put("clientHost", clientHost);
        map.put("user", oneRow.get("User"));
        map.put("application", oneRow.get("ApplicationName"));
        map.put("startContainer", GuiUtil.getMessage((String)oneRow.get("RequestType")));
        String responseTime = (String)oneRow.get("ResponseTime");
        String resp = CallFlowHandlers.convertNanoToMs(responseTime);
        map.put("responseTime", resp);
        map.put("hiddenResponseTime", resp);
        String status = CallFlowHandlers.getStatus(oneRow);
        if (SUCCESS.equals(status)) {
            map.put("response", GuiUtil.getMessage("common.Success"));
        } else {
            map.put("response", GuiUtil.getMessage("common.Failed"));
        }
        map.put("selected", false);
        return map;
    }

    public static void deleteCallFlowRequest(HandlerContext handlerCtx) {
        List obj;
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        List selectedRows = obj = (List)handlerCtx.getInputValue("selectedRows");
        if (obj == null || obj.size() == 0) {
            return;
        }
        String[] requests = new String[obj.size()];
        try {
            int i = 0;
            for (Map oneRow : selectedRows) {
                String requestId = (String)oneRow.get("requestId");
                requests[i++] = requestId;
            }
            CallFlowMonitor cfm = CallFlowHandlers.getCallFlowMonitor(instanceName);
            cfm.deleteRequestIDs(requests);
        }
        catch (Exception ex) {
            GuiUtil.prepareException(handlerCtx, ex);
        }
    }

    public static void getCallFlowFilters(HandlerContext handlerCtx) {
        ArrayList<String> label = new ArrayList<String>();
        label.add(GuiUtil.getMessage("common.showAll"));
        label.add(GuiUtil.getMessage("callFlow.Success"));
        label.add(GuiUtil.getMessage("callFlow.Failed"));
        label.add(GuiUtil.getMessage("callFlow.REMOTE_WEB"));
        label.add(GuiUtil.getMessage("callFlow.REMOTE_WEB_SERVICE"));
        label.add(GuiUtil.getMessage("callFlow.REMOTE_EJB"));
        label.add(GuiUtil.getMessage("callFlow.TIMER_EJB"));
        label.add(GuiUtil.getMessage("callFlow.REMOTE_ASYNC_MESSAGE"));
        ArrayList<String> value = new ArrayList<String>();
        value.add("");
        value.add(SUCCESS);
        value.add(FAILED);
        value.add("REMOTE_WEB");
        value.add("REMOTE_WEB_SERVICE");
        value.add("REMOTE_EJB");
        value.add("TIMER_EJB");
        value.add("REMOTE_ASYNC_MESSAGE");
        handlerCtx.setOutputValue("filterListValue", value);
        handlerCtx.setOutputValue("filterListLabel", label);
    }

    public static void getCallFlowDetail(HandlerContext handlerCtx) {
        String requestId = (String)handlerCtx.getInputValue("requestId");
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        Boolean demo = (Boolean)handlerCtx.getInputValue("demo");
        if (demo == null) {
            demo = false;
        }
        HashMap<String, Object> infoMap = new HashMap<String, Object>();
        ArrayList stackList = new ArrayList();
        CallFlowMonitor cfm = CallFlowHandlers.getCallFlowMonitor(instanceName);
        if (!(demo.booleanValue() || cfm != null && requestId != null)) {
            handlerCtx.setOutputValue("detailInfo", infoMap);
            handlerCtx.setOutputValue("callFlowStackMap", stackList);
            handlerCtx.setOutputValue("hasCallFlowChart", (Object)false);
            return;
        }
        try {
            List listOfMap = null;
            listOfMap = demo != null && demo != false ? CallFlowHandlers.getDemoCallFlowStack(requestId) : cfm.queryCallStackForRequest(requestId);
            infoMap.put("user", handlerCtx.getInputValue("user"));
            infoMap.put("responseTime", handlerCtx.getInputValue("responseTime"));
            Map oneRow = CallFlowHandlers.getRow("RequestStart", listOfMap);
            if (oneRow == null) {
                return;
            }
            String ms = (String)oneRow.get("TimeStampMillis");
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, GuiUtil.getLocale());
            Date date = new Date(Long.parseLong(ms));
            String formattedTime = dateFormat.format(date);
            infoMap.put("timeStamp", formattedTime);
            infoMap.put("startContainer", oneRow.get("RequestType"));
            oneRow = CallFlowHandlers.getRow("MethodStart", listOfMap);
            if (oneRow == null) {
                return;
            }
            infoMap.put("application", oneRow.get("ApplicationName"));
            oneRow = CallFlowHandlers.getLastRow("MethodEnd", listOfMap);
            if (oneRow == null) {
                return;
            }
            String except = (String)oneRow.get("Exception");
            infoMap.put("exception", except);
            if (GuiUtil.isEmpty(except)) {
                infoMap.put("response", GuiUtil.getMessage("common.Success"));
                infoMap.put("hasException", false);
            } else {
                infoMap.put("response", GuiUtil.getMessage("common.Failed"));
                infoMap.put("hasException", true);
            }
            Map timeSpendMap = null;
            timeSpendMap = demo != null && demo != false ? CallFlowHandlers.getDemoTimeSpendMap(requestId) : cfm.queryPieInformation(requestId);
            Boolean doCharting = (Boolean)handlerCtx.getInputValue("doCharting");
            boolean hasChartData = CallFlowHandlers.getTimeSpendInfo(infoMap, timeSpendMap, doCharting);
            handlerCtx.setOutputValue("detailInfo", infoMap);
            handlerCtx.setOutputValue("callFlowStackMap", (Object)CallFlowHandlers.convertToDetailStackList(listOfMap));
            handlerCtx.setOutputValue("hasCallFlowChart", (Object)hasChartData);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            handlerCtx.setOutputValue("detailInfo", infoMap);
            handlerCtx.setOutputValue("hasCallFlowChart", (Object)false);
        }
    }

    private static Map getRow(String callStackType, List listOfMap) {
        String type;
        Map oneRow = null;
        for (int i = 0; i < listOfMap.size() && !callStackType.equals(type = (String)(oneRow = (Map)listOfMap.get(i)).get("CallStackRowType")); ++i) {
        }
        return oneRow;
    }

    private static Map getLastRow(String callStackType, List listOfMap) {
        String type;
        Map oneRow = null;
        for (int i = listOfMap.size() - 1; i >= 0 && !callStackType.equals(type = (String)(oneRow = (Map)listOfMap.get(i)).get("CallStackRowType")); --i) {
        }
        return oneRow;
    }

    private static List convertToDetailStackList(List listOfMap) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, GuiUtil.getLocale());
        ArrayList<Map> convertedList = new ArrayList<Map>();
        if (listOfMap == null || listOfMap.isEmpty()) {
            return convertedList;
        }
        try {
            ArrayList<Map> tmpList = new ArrayList<Map>();
            for (int i = 0; i < listOfMap.size(); ++i) {
                Map oneRow = (Map)listOfMap.get(i);
                String type = (String)oneRow.get("CallStackRowType");
                if ("MethodStart".equals(type)) {
                    tmpList.add(oneRow);
                }
                if (!"MethodEnd".equals(type)) continue;
                int lastIndex = tmpList.size() - 1;
                Map methodStart = (Map)tmpList.get(lastIndex);
                methodStart.put(END_TIMESTAMP_KEY, oneRow.get("TimeStampMillis"));
                tmpList.remove(lastIndex);
            }
            int sequence = 1;
            for (int i = 0; i < listOfMap.size(); ++i) {
                Map oneRow = (Map)listOfMap.get(i);
                String type = (String)oneRow.get("CallStackRowType");
                if (!"MethodStart".equals(type)) continue;
                convertedList.add(CallFlowHandlers.populateOneDetailRow(oneRow, dateFormat, sequence++));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return convertedList;
    }

    private static Map populateOneDetailRow(Map oneRow, DateFormat dateFormat, int sequence) {
        HashMap converted = new HashMap();
        converted.put("container", oneRow.get("ContainerType"));
        converted.put("module", oneRow.get("ModuleName"));
        converted.put("method", oneRow.get("MethodName"));
        converted.put("component", oneRow.get("ComponentName"));
        converted.put("sequence", sequence);
        return converted;
    }

    private static boolean getTimeSpendInfo(Map infoMap, Map<String, String> timeSpendMap, Boolean doCharting) {
        if (timeSpendMap == null || timeSpendMap.size() <= 0) {
            return false;
        }
        float total = 0.0f;
        for (String key : timeSpendMap.keySet()) {
            total += Float.parseFloat(timeSpendMap.get(key));
        }
        NumberFormat nf = NumberFormat.getInstance(GuiUtil.getLocale());
        nf.setMinimumFractionDigits(1);
        String ms = null;
        float percent = 0.0f;
        String percentStr = "";
        ArrayList<Map> labelList = new ArrayList<Map>();
        if (timeSpendMap.containsKey("WEB_APPLICATION")) {
            infoMap.put("hasWebApp", true);
            ms = timeSpendMap.get("WEB_APPLICATION");
            percent = Float.parseFloat(ms) / total * 100.0f;
            percentStr = nf.format(percent);
            infoMap.put("webApp", CallFlowHandlers.formatStr("callFlowDetail.percentMs", percentStr, ms));
            labelList.add(CallFlowHandlers.chartLabelMap("callFlowDetail.chart.webApp", percent, percentStr, ms));
        } else {
            infoMap.put("hasWebApp", false);
            labelList.add(CallFlowHandlers.emptyMap("callFlowDetail.chart.webApp"));
        }
        if (timeSpendMap.containsKey("WEB_CONTAINER")) {
            infoMap.put("hasWebContainer", true);
            ms = timeSpendMap.get("WEB_CONTAINER");
            percent = Float.parseFloat(ms) / total * 100.0f;
            percentStr = nf.format(percent);
            infoMap.put("webContainer", CallFlowHandlers.formatStr("callFlowDetail.percentMs", percentStr, ms));
            labelList.add(CallFlowHandlers.chartLabelMap("callFlowDetail.chart.webCont", percent, percentStr, ms));
        } else {
            infoMap.put("hasWebContainer", false);
            labelList.add(CallFlowHandlers.emptyMap("callFlowDetail.chart.webCont"));
        }
        if (timeSpendMap.containsKey("EJB_APPLICATION")) {
            infoMap.put("hasEjbApp", true);
            ms = timeSpendMap.get("EJB_APPLICATION");
            percent = Float.parseFloat(ms) / total * 100.0f;
            percentStr = nf.format(percent);
            infoMap.put("ejbApp", CallFlowHandlers.formatStr("callFlowDetail.percentMs", percentStr, ms));
            labelList.add(CallFlowHandlers.chartLabelMap("callFlowDetail.chart.ejbApp", percent, percentStr, ms));
        } else {
            infoMap.put("hasEjbApp", false);
            labelList.add(CallFlowHandlers.emptyMap("callFlowDetail.chart.ejbApp"));
        }
        if (timeSpendMap.containsKey("EJB_CONTAINER")) {
            infoMap.put("hasEjb", true);
            ms = timeSpendMap.get("EJB_CONTAINER");
            percent = Float.parseFloat(ms) / total * 100.0f;
            percentStr = nf.format(percent);
            infoMap.put("ejbContainer", CallFlowHandlers.formatStr("callFlowDetail.percentMs", percentStr, ms));
            labelList.add(CallFlowHandlers.chartLabelMap("callFlowDetail.chart.ejbCont", percent, percentStr, ms));
        } else {
            infoMap.put("hasEjb", false);
            labelList.add(CallFlowHandlers.emptyMap("callFlowDetail.chart.ejbCont"));
        }
        if (timeSpendMap.containsKey("ORB_CONTAINER")) {
            infoMap.put("hasOrbContainer", true);
            ms = timeSpendMap.get("ORB_CONTAINER");
            percent = Float.parseFloat(ms) / total * 100.0f;
            percentStr = nf.format(percent);
            infoMap.put("orbContainer", CallFlowHandlers.formatStr("callFlowDetail.percentMs", percentStr, ms));
            labelList.add(CallFlowHandlers.chartLabelMap("callFlowDetail.chart.orbCont", percent, percentStr, ms));
        } else {
            infoMap.put("hasOrbContainer", false);
            labelList.add(CallFlowHandlers.emptyMap("callFlowDetail.chart.orbCont"));
        }
        Collections.sort(labelList, new TimeSpentComparator());
        infoMap.put("xLabels", labelList);
        ArrayList<Integer> valueList = new ArrayList<Integer>();
        for (int i = 0; i < labelList.size(); ++i) {
            Float ff = (Float)((Map)labelList.get(i)).get("compValue");
            valueList.add(Math.round(ff.floatValue()));
        }
        HashMap<String, Object> vMap = new HashMap<String, Object>();
        vMap.put("color", "green");
        vMap.put("values", valueList);
        ArrayList<HashMap<String, Object>> vList = new ArrayList<HashMap<String, Object>>();
        vList.add(vMap);
        infoMap.put("valueList", vList);
        return doCharting;
    }

    private static Map emptyMap(String key) {
        HashMap<String, Object> aMap = new HashMap<String, Object>();
        aMap.put("title", "0%");
        aMap.put("label", GuiUtil.getMessage(key));
        aMap.put("compValue", Float.valueOf(0.0f));
        return aMap;
    }

    private static Map chartLabelMap(String key, float percent, String percentStr, String ms) {
        HashMap<String, Object> aMap = new HashMap<String, Object>();
        aMap.put("label", GuiUtil.getMessage(key));
        aMap.put("title", CallFlowHandlers.formatStr(key + "DD", percentStr, ms));
        aMap.put("compValue", Float.valueOf(percent));
        return aMap;
    }

    private static String formatStr(String key, String percent, String ms) {
        return GuiUtil.getMessage(key, new Object[]{percent, CallFlowHandlers.convertNanoToMs(ms)});
    }

    static CallFlowMonitor getCallFlowMonitor(String instanceName) {
        ServerRootMonitor serverRootMonitor = AMXUtil.getServerRootMonitor(instanceName);
        if (serverRootMonitor == null) {
            return null;
        }
        CallFlowMonitor cfm = serverRootMonitor.getCallFlowMonitor();
        return cfm;
    }

    private static boolean includeRequest(Map oneRow, String filter) {
        if (filter == null || "".equals(filter)) {
            return true;
        }
        String status = CallFlowHandlers.getStatus(oneRow);
        String container = (String)oneRow.get("RequestType");
        return filter.equalsIgnoreCase(status) || filter.equalsIgnoreCase(container);
    }

    private static String getStatus(Map oneRow) {
        String error = (String)oneRow.get("Exception");
        return GuiUtil.isEmpty(error) ? SUCCESS : FAILED;
    }

    private static String convertFromNano(String ms, DateFormat dateFormat) {
        long ns = Long.parseLong(ms);
        long ns1 = ns / 1000000L;
        Date dd = new Date(ns1);
        String formattedTime = dateFormat.format(dd);
        return formattedTime;
    }

    private static String convertNanoToMs(String nano) {
        float ns = Float.parseFloat(nano);
        float ns1 = ns / 1000000.0f;
        NumberFormat numberformat = NumberFormat.getInstance(GuiUtil.getLocale());
        numberformat.setMinimumFractionDigits(2);
        String str = numberformat.format(ns1);
        return str;
    }

    private static List queryDemoRequestInformation() {
        ArrayList listOfMap = new ArrayList();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("RequestID", "23458989");
        hashMap.put("TimeStampMillis", "" + System.nanoTime());
        hashMap.put("ClientHost", "138.243.150.122");
        hashMap.put("User", "Mary");
        hashMap.put("RequestType", "REMOTE_WEB");
        hashMap.put("Status", "true");
        hashMap.put("ResponseTime", "34");
        hashMap.put("ApplicationName", "testApp");
        listOfMap.add(hashMap);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("RequestID", "28881999");
        hashMap2.put("TimeStampMillis", "" + System.nanoTime());
        hashMap2.put("ClientHost", "138.243.140.111");
        hashMap2.put("User", "Peter");
        hashMap2.put("RequestType", "REMOTE_EJB");
        hashMap2.put("Status", "true");
        hashMap2.put("ResponseTime", "69");
        hashMap2.put("ApplicationName", "testApp");
        listOfMap.add(hashMap2);
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        hashMap3.put("RequestID", "55551111");
        hashMap3.put("TimeStampMillis", "" + System.nanoTime());
        hashMap3.put("ClientHost", "299.288.277.266");
        hashMap3.put("User", "another-user");
        hashMap3.put("RequestType", "iiop");
        hashMap3.put("Status", "false");
        hashMap3.put("ResponseTime", "44");
        hashMap3.put("ApplicationName", "another-app");
        listOfMap.add(hashMap3);
        HashMap<String, String> hashMap4 = new HashMap<String, String>();
        hashMap4.put("RequestID", "38881999");
        hashMap4.put("TimeStampMillis", "" + System.nanoTime());
        hashMap4.put("ClientHost", "178.244.140.111");
        hashMap4.put("User", "admin");
        hashMap4.put("RequestType", "REMOTE_EJB");
        hashMap4.put("Status", "false");
        hashMap4.put("ResponseTime", "20");
        hashMap4.put("ApplicationName", "testApp");
        listOfMap.add(hashMap4);
        return listOfMap;
    }

    private static List getDemoCallFlowStack(String requestId) {
        ArrayList listOfMap = new ArrayList();
        HashMap<String, String> hMap = new HashMap<String, String>();
        hMap.put("RequestID", "RequestID_1");
        hMap.put("RequestType", "REMOTE_EJB");
        hMap.put("TimeStampMillis", "10");
        hMap.put("CallStackRowType", "RequestStart");
        listOfMap.add(hMap);
        hMap = new HashMap();
        hMap.put("Status", "false");
        hMap.put("ModuleName", "Module_Name_1");
        hMap.put("MethodName", "Method_Name_1");
        hMap.put("Exception", "");
        hMap.put("ComponentName", "Component_Name_1");
        hMap.put("RequestID", "RequestID_1");
        hMap.put("ApplicationName", "APP_NAME");
        hMap.put("ContainerType", "SERVLET");
        hMap.put("TimeStampMillis", "11");
        hMap.put("CallStackRowType", "MethodStart");
        listOfMap.add(hMap);
        hMap = new HashMap();
        hMap.put("Status", "false");
        hMap.put("ModuleName", "Module_Name_2");
        hMap.put("MethodName", "Method_Name_2");
        hMap.put("Exception", "");
        hMap.put("ComponentName", "Component_Name_2");
        hMap.put("RequestID", "RequestID_1");
        hMap.put("ApplicationName", "APP_NAME");
        hMap.put("ContainerType", "SERVLET");
        hMap.put("TimeStampMillis", "12");
        hMap.put("CallStackRowType", "MethodStart");
        listOfMap.add(hMap);
        hMap = new HashMap();
        hMap.put("Status", "false");
        hMap.put("Exception", "exe_1");
        hMap.put("RequestID", "RequestID_1");
        hMap.put("TimeStampMillis", "13");
        hMap.put("CallStackRowType", "MethodEnd");
        listOfMap.add(hMap);
        hMap = new HashMap();
        hMap.put("Status", "false");
        hMap.put("Exception", "exe_1");
        hMap.put("RequestID", "RequestID_1");
        hMap.put("TimeStampMillis", "14");
        hMap.put("CallStackRowType", "MethodEnd");
        listOfMap.add(hMap);
        hMap = new HashMap();
        hMap.put("RequestID", "RequestID_1");
        hMap.put("TimeStampMillis", "15");
        hMap.put("CallStackRowType", "RequestEnd");
        listOfMap.add(hMap);
        return listOfMap;
    }

    private static Map getDemoTimeSpendMap(String id) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (democount == 0) {
            hashMap.put("WEB_CONTAINER", "10");
            hashMap.put("WEB_APPLICATION", "30");
            hashMap.put("EJB_CONTAINER", "15");
            hashMap.put("EJB_APPLICATION", "40");
            hashMap.put("ORB_CONTAINER", "5");
        } else if (democount == 1) {
            hashMap.put("WEB_CONTAINER", "20");
            hashMap.put("WEB_APPLICATION", "10");
            hashMap.put("EJB_CONTAINER", "15");
            hashMap.put("EJB_APPLICATION", "30");
        } else if (democount == 2) {
            hashMap.put("WEB_CONTAINER", "20");
            hashMap.put("WEB_APPLICATION", "10");
            hashMap.put("EJB_CONTAINER", "15");
        } else {
            hashMap.put("WEB_CONTAINER", "20");
            hashMap.put("WEB_APPLICATION", "35");
        }
        if (democount++ >= 3) {
            democount = 0;
        }
        return hashMap;
    }

    public void getCallFlowStackMaps(HandlerContext handlerCtx) {
        String requestId = (String)handlerCtx.getInputValue("requestId");
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        Boolean demo = (Boolean)handlerCtx.getInputValue("demo");
        CallFlowMonitor cfm = CallFlowHandlers.getCallFlowMonitor(instanceName);
        if (cfm == null) {
            return;
        }
        try {
            List listOfMap = null;
            listOfMap = demo != null && demo != false ? CallFlowHandlers.getDemoCallFlowStack(requestId) : cfm.queryCallStackForRequest(requestId);
            handlerCtx.setOutputValue("callStackMap", (Object)listOfMap);
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
            ex.printStackTrace();
        }
    }

    public void createCallFlowStackTree(HandlerContext handlerCtx) {
        UIComponent parent = (UIComponent)handlerCtx.getInputValue("parent");
        List content = (List)handlerCtx.getInputValue("content");
        CallFlowStackTreeDS dataSource = new CallFlowStackTreeDS(content);
        Tree tree = dataSource.createJSFTree(parent);
        handlerCtx.setOutputValue("tree", (Object)tree);
    }

    private static final class TimeSpentComparator
    implements Comparator {
        private TimeSpentComparator() {
        }

        public int compare(Object o1, Object o2) {
            Float f1 = (Float)((Map)o1).get("compValue");
            Float f2 = (Float)((Map)o2).get("compValue");
            return f2.compareTo(f1);
        }

        public boolean equals(Object other) {
            return other instanceof TimeSpentComparator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CallFlowStackTreeDS
    implements TreeDataSource {
        private List<Map> _maps = new ArrayList<Map>();

        public CallFlowStackTreeDS(List<Map> maps) {
            if (maps != null) {
                this._maps = maps;
            }
        }

        @Override
        public Tree createJSFTree(UIComponent parent) {
            Map ms;
            String rowType;
            Map nodeMap = null;
            UIComponent child = null;
            String type = null;
            String methodName = null;
            Tree tree = null;
            Iterator<Map> it = this._maps.iterator();
            if (!it.hasNext()) {
                return null;
            }
            String application = "";
            for (int i = 0; i < this._maps.size() && (!(rowType = (String)(ms = this._maps.get(i)).get("CallStackRowType")).equals("MethodStart") || GuiUtil.isEmpty(application = (String)ms.get("ApplicationName"))); ++i) {
            }
            nodeMap = it.next();
            if (!((String)nodeMap.get("CallStackRowType")).equals("RequestStart")) {
                throw new RuntimeException("CallFlow stack should begin with RequestStart, instead got: '" + nodeMap.get("CallStackRowType") + "'.");
            }
            Properties props = new Properties();
            props.put("expanded", Boolean.TRUE);
            if (application == null) {
                application = "";
            }
            props.put("text", application);
            child = ComponentUtil.getChild((UIComponent)parent, (String)"callFlowTree", (String)"com.sun.jsftemplating.component.factory.sun.TreeFactory", (Properties)props);
            parent.getChildren().add(child);
            tree = (Tree)child;
            tree.setClientSide(false);
            int idx = 0;
            while (it.hasNext()) {
                nodeMap = it.next();
                type = (String)nodeMap.get("CallStackRowType");
                if (type.equals("MethodStart")) {
                    parent = child;
                    methodName = (String)nodeMap.get("MethodName");
                    props = (Properties)props.clone();
                    props.setProperty("text", methodName);
                    child = ComponentUtil.getChild((UIComponent)parent, (String)("node" + ++idx), (String)"com.sun.jsftemplating.component.factory.sun.TreeNodeFactory", (Properties)props);
                    parent.getChildren().add(child);
                    continue;
                }
                if (type.equals("MethodEnd")) {
                    child = child.getParent();
                    continue;
                }
                if (!type.equals("RequestEnd")) continue;
                break;
            }
            return tree;
        }
    }

    private static interface TreeDataSource {
        public Tree createJSFTree(UIComponent var1);
    }
}

