/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.Transaction;
import com.sun.messaging.jmq.util.JMQXid;
import javax.jms.JMSException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceImpl
implements XAResource {
    private SessionImpl _session;
    private ConnectionImpl _connection;
    private Transaction _transaction = null;
    private long resourceManagerId = 0L;
    private int transactionTimeout = 0;

    public XAResourceImpl(SessionImpl sessionImpl) throws JMSException {
        this._session = sessionImpl;
        this._connection = sessionImpl.connection;
        this.resourceManagerId = this._connection.protocolHandler.generateUID();
    }

    public void commit(Xid xid, boolean bl) throws XAException {
        JMQXid jMQXid = new JMQXid(xid);
        try {
            try {
                this._connection.openConnection(true);
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this._connection.openConnection(true);
            }
            if (this._transaction == null) {
                this._connection.getProtocolHandler().commit(0L, bl ? 0x40000000 : 0, jMQXid);
            } else {
                this._transaction.setProtocolHandler(this._connection.getProtocolHandler());
                if (!this._session.isClosed) {
                    this._session.setInSyncState();
                    this._session.receiveCommit();
                }
                this._transaction.commitXATransaction(jMQXid, bl);
            }
            this._connection.closeConnection();
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            XAException xAException = new XAException(-7);
            xAException.initCause(exception);
            throw xAException;
        }
        finally {
            this._session.releaseInSyncState();
            this._session.switchOffXATransaction();
        }
    }

    public void end(Xid xid, int n) throws XAException {
        JMQXid jMQXid = new JMQXid(xid);
        try {
            this._session.transaction.endXATransaction(n, jMQXid);
        }
        catch (JMSException jMSException) {
            Debug.printStackTrace((Exception)((Object)jMSException));
            XAException xAException = new XAException(-7);
            xAException.initCause(jMSException);
            throw xAException;
        }
    }

    public void forget(Xid xid) throws XAException {
    }

    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    public boolean isSameRM(XAResource xAResource) throws XAException {
        return this.getClass().isInstance(xAResource) ? this.isSameJMQRM((XAResourceImpl)xAResource) : false;
    }

    public boolean isSameJMQRM(XAResourceImpl xAResourceImpl) {
        if (this.resourceManagerId != 0L) {
            return this.resourceManagerId == xAResourceImpl.getResourceManagerId();
        }
        return false;
    }

    public int prepare(Xid xid) throws XAException {
        int n = 0;
        JMQXid jMQXid = new JMQXid(xid);
        try {
            try {
                this._connection.openConnection(true);
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this._connection.openConnection(true);
            }
            if (this._transaction == null) {
                this._connection.getProtocolHandler().prepare(0L, jMQXid);
            } else {
                this._transaction.setProtocolHandler(this._connection.getProtocolHandler());
                this._transaction.prepareXATransaction(jMQXid);
            }
            this._connection.closeConnection();
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            XAException xAException = new XAException(-7);
            xAException.initCause(exception);
            throw xAException;
        }
        return n;
    }

    public Xid[] recover(int n) throws XAException {
        Xid[] xidArray = null;
        try {
            try {
                this._connection.openConnection(true);
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this._connection.openConnection(true);
            }
            xidArray = this._connection.getProtocolHandler().recover(n);
            this._connection.closeConnection();
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            XAException xAException = new XAException(-7);
            xAException.initCause(exception);
            throw xAException;
        }
        return xidArray;
    }

    public void rollback(Xid xid) throws XAException {
        JMQXid jMQXid = new JMQXid(xid);
        try {
            try {
                this._connection.openConnection(true);
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                this._connection.openConnection(true);
            }
            if (this._transaction == null) {
                this._connection.getProtocolHandler().rollback(0L, jMQXid);
            } else {
                this._transaction.setProtocolHandler(this._connection.getProtocolHandler());
                if (!this._session.isClosed) {
                    this._session.setInSyncState();
                    this._session.receiveRollback();
                }
                this._transaction.rollbackXATransaction(jMQXid);
            }
            this._connection.closeConnection();
        }
        catch (JMSException jMSException) {
            Debug.printStackTrace((Exception)((Object)jMSException));
            XAException xAException = new XAException(-7);
            xAException.initCause(jMSException);
            throw xAException;
        }
        finally {
            this._session.releaseInSyncState();
            this._session.switchOffXATransaction();
        }
    }

    public boolean setTransactionTimeout(int n) throws XAException {
        return false;
    }

    public void start(Xid xid, int n) throws XAException {
        JMQXid jMQXid = new JMQXid(xid);
        try {
            this._session.switchOnXATransaction();
            this._transaction = this._session.transaction;
            this._transaction.startXATransaction(n, jMQXid);
        }
        catch (JMSException jMSException) {
            Debug.printStackTrace((Exception)((Object)jMSException));
            XAException xAException = new XAException(-7);
            xAException.initCause(jMSException);
            throw xAException;
        }
    }

    public long getResourceManagerId() {
        return this.resourceManagerId;
    }
}

