/*
 * Decompiled with CFR 0.152.
 */
package com.sun.genericra.outbound;

import com.sun.genericra.AbstractXAResourceType;
import com.sun.genericra.XAResourceType;
import com.sun.genericra.outbound.ManagedConnection;
import com.sun.genericra.util.ExceptionUtils;
import com.sun.genericra.util.LogUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceProxy
extends AbstractXAResourceType {
    private static Logger logger = LogUtils.getLogger();
    private ManagedConnection mc;

    public XAResourceProxy(ManagedConnection mc) {
        this.mc = mc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.debugxid("Comitting outbound transaction with ID ", xid);
        try {
            this._getXAResource().commit(xid, onePhase);
            this.debugxid("Comitted outbound transaction with ID ", xid);
        }
        finally {
            try {
                this.mc._endXaTx();
            }
            catch (Exception e) {
                throw ExceptionUtils.newXAException(e);
            }
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        this.debug("Ending tx..." + this.convertFlag(flags));
        this.debugxid("Ending outbound transaction with ID ", xid);
        this._getXAResource().end(xid, flags);
        this.debugxid("Ended outbound transaction with ID ", xid);
    }

    public void forget(Xid xid) throws XAException {
        this._getXAResource().forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this._getXAResource().getTransactionTimeout();
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        XAResource inxa = xares;
        if (xares instanceof XAResourceType) {
            XAResourceType wrapper = (XAResourceType)((Object)xares);
            inxa = (XAResource)wrapper.getWrappedObject();
            if (!this.compare(wrapper)) {
                this.debug("isSameRM returns(compare) : false");
                return false;
            }
        }
        boolean result = this._getXAResource().isSameRM(inxa);
        this.debug("isSameRM returns : " + result);
        return result;
    }

    public int prepare(Xid xid) throws XAException {
        this.debugxid("Preparing transaction with ID ", xid);
        return this._getXAResource().prepare(xid);
    }

    public Xid[] recover(int flag) throws XAException {
        return this._getXAResource().recover(flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        this.debugxid("Rolling back transaction with ID ", xid);
        try {
            this._getXAResource().rollback(xid);
            this.debugxid("Rolled back transaction with ID ", xid);
        }
        finally {
            try {
                this.mc._endXaTx();
            }
            catch (Exception e) {
                throw ExceptionUtils.newXAException(e);
            }
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this._getXAResource().setTransactionTimeout(seconds);
    }

    public void start(Xid xid, int flags) throws XAException {
        this.debug("Starting tx..." + this.convertFlag(flags));
        this.debugxid("Starting outbound transaction with ID ", xid);
        try {
            this.mc._startXaTx();
        }
        catch (Exception e) {
            XAException xae = new XAException();
            xae.initCause(e);
            throw xae;
        }
        this._getXAResource().start(xid, flags);
        this.debugxid("Started outbound transaction with ID ", xid);
    }

    private XAResource _getXAResource() throws XAException {
        try {
            return this.mc._getXAResource();
        }
        catch (Exception e) {
            throw ExceptionUtils.newXAException(e);
        }
    }

    public Object getWrappedObject() {
        try {
            return this.mc._getXAResource();
        }
        catch (Exception e) {
            throw ExceptionUtils.newRuntimeException(e);
        }
    }

    String convertFlag(int i) {
        if (i == 0x200000) {
            return "TMJOIN";
        }
        if (i == 0) {
            return "TMNOFLAGS";
        }
        if (i == 0x4000000) {
            return "TMSUCCESS";
        }
        if (i == 0x2000000) {
            return "TMSUSPEND";
        }
        if (i == 0x8000000) {
            return "TMRESUME";
        }
        return "" + i;
    }

    public void startDelayedXA() {
        throw new UnsupportedOperationException();
    }

    public boolean endCalled() {
        throw new UnsupportedOperationException();
    }

    public void setToRollback(boolean rb) {
        throw new UnsupportedOperationException();
    }

    void debug(String s) {
        logger.log(Level.FINEST, "Managed Connection = " + this.mc + " XAResourceProxy" + s);
    }

    void debugxid(String s, Xid xid) {
        if (logger.getLevel() == Level.FINEST) {
            logger.log(Level.FINEST, s + this.printXid(xid));
        }
    }
}

