/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.registration;

import com.sun.enterprise.registration.RegistrationException;
import com.sun.enterprise.registration.RegistrationLogger;
import com.sun.enterprise.registration.SysnetRegistrationService;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RegistrationDaemon {
    private static final long TIMER_INTERVAL = Long.getLong("com.sun.enterprise.registration.TIMER_INTERVAL", 86400000L);
    private static final Logger logger = RegistrationLogger.getLogger();

    public static void start(File serviceTagRegistry) {
        final SysnetRegistrationService registrationService = new SysnetRegistrationService(serviceTagRegistry);
        if (registrationService.isRegistrationEnabled()) {
            final Timer registrationTimer = new Timer("registration", true);
            TimerTask registrationTask = new TimerTask(){

                public void run() {
                    try {
                        registrationService.transferEligibleServiceTagsToSysNet();
                        registrationTimer.cancel();
                    }
                    catch (RegistrationException e) {
                        logger.log(Level.INFO, "Exception while transfering tags" + (Object)((Object)e));
                    }
                }
            };
            registrationTimer.schedule(registrationTask, 0L, TIMER_INTERVAL);
        }
    }
}

