/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.web.sessmgmt;

import com.sun.appserv.util.cache.BaseCache;
import com.sun.enterprise.ee.web.authenticator.HASingleSignOn;
import com.sun.enterprise.ee.web.initialization.ServerConfigReader;
import com.sun.enterprise.ee.web.sessmgmt.ConfigChangeElement;
import com.sun.enterprise.ee.web.sessmgmt.ConnectionUtil;
import com.sun.enterprise.ee.web.sessmgmt.EEHADBHealthChecker;
import com.sun.enterprise.ee.web.sessmgmt.HADBConnectionGroup;
import com.sun.enterprise.ee.web.sessmgmt.HAErrorManager;
import com.sun.enterprise.ee.web.sessmgmt.HAManagerBase;
import com.sun.enterprise.ee.web.sessmgmt.HASession;
import com.sun.enterprise.ee.web.sessmgmt.HAStorePoolElement;
import com.sun.enterprise.ee.web.sessmgmt.HATimeoutException;
import com.sun.enterprise.ee.web.sessmgmt.IntHolder;
import com.sun.enterprise.ee.web.sessmgmt.WebModuleStatistics;
import com.sun.enterprise.security.web.SingleSignOn;
import com.sun.enterprise.security.web.SingleSignOnEntry;
import com.sun.enterprise.web.ServerConfigLookup;
import com.sun.logging.LogDomains;
import com.sun.web.security.RealmAdapter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.session.IOUtilsCaller;
import org.apache.catalina.session.PersistentManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StoreBase;
import org.apache.catalina.session.WebIOUtilsFactory;

public class HAStore
extends StoreBase
implements HAStorePoolElement {
    protected static int _maxBaseCacheSize = 4096;
    protected static float _loadFactor = 0.75f;
    protected String threadName = "HAStore";
    protected BaseCache sessions = new BaseCache();
    private static Logger _logger = null;
    private static int CHUNK_SIZE = 100;
    protected int _debug = 0;
    protected Level _logLevel = null;
    private IOUtilsCaller webUtilsCaller = null;
    protected String blobSessionTable = "blobsessions";
    protected String driverName = "com.sun.hadb.jdbc.Driver";
    protected String timeoutSecs = new Long(300L).toString();
    protected String timeoutSecs2 = new Long(120L).toString();
    protected Connection conn = null;
    protected HAErrorManager haErr = null;
    protected HAErrorManager haErrLoad = null;
    protected HAErrorManager haErrRemove = null;
    protected HAErrorManager haErrRemoveExpired = null;
    protected HAErrorManager haErrClear = null;
    protected HAErrorManager haErrKeys = null;
    protected HAErrorManager haErrSize = null;
    protected HAErrorManager haErrExists = null;
    protected HAErrorManager haErrExists2 = null;
    protected HAErrorManager haErrExpiredKeys = null;
    protected ConnectionUtil connectionUtil = null;
    private PreparedStatement preparedKeysSql = null;
    private PreparedStatement preparedExpiredKeysSql = null;
    private PreparedStatement preparedRemoveExpiredKeysSql = null;
    private PreparedStatement preparedSizeSql = null;
    private PreparedStatement preparedDualSql = null;
    private PreparedStatement preparedLoadSql = null;
    private PreparedStatement preparedInsertSql = null;
    private PreparedStatement preparedRemoveSql = null;
    private PreparedStatement preparedClearSql = null;
    private PreparedStatement preparedUpdateSql = null;
    private PreparedStatement preparedExistsSql = null;
    private PreparedStatement preparedExistsSql2 = null;
    private PreparedStatement preparedUpdateNoSessionSql = null;
    protected String clusterId = null;
    protected String applicationId = null;
    protected String shortApplicationId = null;

    public BaseCache getSessions() {
        return this.sessions;
    }

    public void setSessions(BaseCache sesstable) {
        this.sessions = sesstable;
    }

    public BaseCache getMainStoreCache() {
        PersistentManagerBase pmb = (PersistentManagerBase)this.getManager();
        HAStore myStore = (HAStore)pmb.getStore();
        return myStore.getSessions();
    }

    protected void putSessionInMainStoreCache(Session session) {
        if (session == null) {
            return;
        }
        BaseCache theSessions = this.getMainStoreCache();
        theSessions.put((Object)session.getIdInternal(), (Object)session);
    }

    protected Session getSessionFromMainStoreCache(String id) {
        BaseCache theSessions = this.getMainStoreCache();
        return (Session)theSessions.get((Object)id);
    }

    public void removeSessionFromMainStoreCache(String id) {
        BaseCache theSessions = this.getMainStoreCache();
        theSessions.remove((Object)id);
    }

    protected IOUtilsCaller getWebUtilsCaller() {
        if (this.webUtilsCaller == null) {
            WebIOUtilsFactory factory = new WebIOUtilsFactory();
            this.webUtilsCaller = factory.createWebIOUtil();
        }
        return this.webUtilsCaller;
    }

    protected void setLogLevel() {
        Level level;
        this._logLevel = level = _logger.getLevel();
        this._debug = level.equals(Level.FINE) ? 1 : (level.equals(Level.FINER) ? 2 : (level.equals(Level.FINEST) ? 5 : 0));
    }

    protected static boolean checkSessionCacheProperties() {
        boolean result = false;
        try {
            String loadFactor;
            Properties props = System.getProperties();
            String cacheSize = props.getProperty("HTTP_SESSION_CACHE_MAX_BASE_CACHE_SIZE");
            if (null != cacheSize) {
                _maxBaseCacheSize = new Integer(cacheSize);
            }
            if (null != (loadFactor = props.getProperty("HTTP_SESSION_CACHE_MAX_BASE_LOAD_FACTOR"))) {
                _loadFactor = new Float(loadFactor).floatValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected String getClusterIdFromConfig() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        return lookup.getClusterIdFromConfig();
    }

    protected String getClusterId() {
        if (this.clusterId == null) {
            this.clusterId = this.getClusterIdFromConfig();
        }
        return this.clusterId;
    }

    protected ConnectionUtil getConnectionUtil() {
        if (this.connectionUtil == null) {
            this.connectionUtil = new ConnectionUtil(this.getManager().getContainer(), this.getManager());
        }
        return this.connectionUtil;
    }

    public String getApplicationId() {
        if (this.applicationId != null) {
            return this.applicationId;
        }
        StringBuffer sb = new StringBuffer(50);
        sb.append(this.getClusterId());
        ArrayList<String> list = new ArrayList<String>();
        for (Container container = this.manager.getContainer(); container != null; container = container.getParent()) {
            if (container.getName() == null) continue;
            if (container.getName().equals("")) {
                list.add(":/");
                continue;
            }
            list.add(":" + container.getName());
        }
        for (int i = list.size() - 1; i > -1; --i) {
            String nextString = (String)list.get(i);
            sb.append(nextString);
        }
        this.applicationId = sb.toString();
        return this.applicationId;
    }

    public String getShortApplicationId() {
        if (this.shortApplicationId != null) {
            return this.shortApplicationId;
        }
        Container container = this.manager.getContainer();
        StringBuffer sb = new StringBuffer(50);
        sb.append(this.getClusterId());
        sb.append(":");
        if (container != null && container.getName() != null) {
            if (container.getName().equals("")) {
                sb.append("/");
            } else {
                sb.append(container.getName());
            }
        }
        container = container.getParent();
        this.shortApplicationId = sb.toString();
        return this.shortApplicationId;
    }

    public String extractShortApplicationIdFromApplicationId(String appid) {
        StringTokenizer st = new StringTokenizer(appid, ":");
        ArrayList<String> list = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken();
            list.add(nextToken);
        }
        StringBuffer sb = new StringBuffer();
        int listSize = list.size();
        if (listSize > 2) {
            sb.append(list.get(0));
            sb.append(":");
            sb.append(list.get(listSize - 1));
        }
        return sb.toString();
    }

    public void setTimeoutSecs(String timeoutSecs) {
        this.debug("in setTimeoutSecs");
        String oldTimeoutSecs = this.timeoutSecs;
        this.timeoutSecs = timeoutSecs;
        this.support.firePropertyChange("timeoutSecs", oldTimeoutSecs, this.timeoutSecs);
    }

    public String getTimeoutSecs() {
        this.debug("in getTimeoutSecs");
        return this.timeoutSecs;
    }

    protected long getTimeout() {
        return new Long(this.timeoutSecs);
    }

    protected void debug(String message) {
        this.log(message);
        System.out.println(message);
    }

    public HAStore() {
        this.info = "S1AS7.0EE HAStore/1.0";
        this.threadName = "HAStore";
        this.storeName = "HAStore";
        long timeout = new Long(this.timeoutSecs);
        long timeout2 = new Long(this.timeoutSecs2);
        this.haErr = new HAErrorManager(timeout, this.threadName);
        this.haErrLoad = new HAErrorManager(timeout, this.threadName);
        this.haErrRemove = new HAErrorManager(timeout, this.threadName);
        this.haErrRemoveExpired = new HAErrorManager(timeout, this.threadName);
        this.haErrExpiredKeys = new HAErrorManager(timeout, this.threadName);
        this.haErrKeys = new HAErrorManager(timeout, this.threadName);
        this.haErrSize = new HAErrorManager(timeout, this.threadName);
        this.haErrClear = new HAErrorManager(timeout2, this.threadName);
        this.haErrExists = new HAErrorManager(timeout, this.threadName);
        this.haErrExists2 = new HAErrorManager(timeout, this.threadName);
        if (_logger == null) {
            _logger = LogDomains.getLogger((String)"javax.enterprise.system.container.web");
        }
        this.setLogLevel();
        this.sessions = new BaseCache();
        this.sessions.init(_maxBaseCacheSize, _loadFactor, null);
    }

    public int getSize() throws IOException {
        return this.getSize(this.blobSessionTable);
    }

    public int getSize(String sessionTable) throws IOException {
        int size = 0;
        String sizeSql = "SELECT COUNT(id) FROM " + sessionTable + " WHERE appid = '" + this.getApplicationId() + "'";
        Connection conn = this.getConnection(false);
        ResultSet rst = null;
        try {
            if (this.preparedSizeSql == null) {
                this.preparedSizeSql = conn.prepareStatement(sizeSql);
            }
            if ((rst = this.executeStatement(this.preparedSizeSql, true, this.haErrSize)).next()) {
                size = rst.getInt(1);
            }
            conn.commit();
            this.closeResultSet(rst);
        }
        catch (SQLException e) {
            try {
                try {
                    conn.rollback();
                }
                catch (SQLException ee) {
                    // empty catch block
                }
                IOException ex1 = (IOException)new IOException("Error from HA Store: " + e.getMessage()).initCause(e);
                throw ex1;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rst);
                throw throwable;
            }
        }
        return size;
    }

    public String[] keys() throws IOException {
        return this.keys(this.blobSessionTable);
    }

    public void processStaleCachedSessions() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        if (!lookup.getStaleSessionCheckingFromConfig()) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("stale session checking disabled");
            }
            return;
        }
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        Connection connection = null;
        try {
            connection = this.getConnectionValidated(false);
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (connection == null) {
            return;
        }
        try {
            this.removeStaleCachedSessions(connection, CHUNK_SIZE);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void processExpires() {
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        Connection connection = null;
        try {
            connection = this.getConnectionValidated(false);
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (connection == null) {
            return;
        }
        try {
            this.removeExpiredSessions(connection, CHUNK_SIZE);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private String[] getSessionIds() {
        BaseCache mainStoreCachedSessions = this.getMainStoreCache();
        String[] ids = null;
        int numberOfIds = mainStoreCachedSessions.getEntryCount();
        ArrayList<String> idsList = new ArrayList<String>(numberOfIds);
        Iterator keysIter = mainStoreCachedSessions.keys();
        while (keysIter.hasNext()) {
            idsList.add((String)keysIter.next());
        }
        String[] template = new String[idsList.size()];
        ids = idsList.toArray(template);
        return ids;
    }

    private void removeStaleCachedSessions(Connection connection, int chunksize) throws IOException {
        String[] ids = this.getSessionIds();
        boolean finished = false;
        int chunk = chunksize;
        int idsSize = ids.length;
        if (idsSize == 0) {
            return;
        }
        int startIdx = 0;
        int endIdx = 0;
        if (chunksize > idsSize) {
            chunk = idsSize;
        }
        endIdx = startIdx + chunk;
        while (!finished) {
            this.removeStaleCachedSessions(connection, ids, startIdx, endIdx);
            startIdx = endIdx + 1;
            endIdx = startIdx + chunk;
            if (startIdx >= idsSize - 1) {
                finished = true;
                break;
            }
            if (endIdx < idsSize - 1) continue;
            idsSize = 1;
            endIdx = 1;
        }
    }

    private void removeStaleCachedSessions(Connection connection, String[] ids, int startIdx, int endIdx) throws IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("removeStaleCachedSessions: start=" + startIdx + " end=" + endIdx);
        }
        ResultSet rst = null;
        String[] keys = null;
        ArrayList<ConfigChangeElement> keyList = new ArrayList<ConfigChangeElement>(100);
        ArrayList<String> staleIdList = new ArrayList<String>(100);
        if (connection == null) {
            return;
        }
        String inClause = this.getInClause(ids, startIdx, endIdx);
        String keysSql = "SELECT id, lastaccess FROM " + this.blobSessionTable + " WHERE appid = '" + this.getApplicationId() + "'" + " AND id IN " + inClause;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("keysSql = " + keysSql);
        }
        try {
            this.haErrRemoveExpired.txStart();
            while (!this.haErrRemoveExpired.isTxCompleted()) {
                try {
                    this.preparedKeysSql = connection.prepareStatement(keysSql);
                    rst = this.preparedKeysSql.executeQuery();
                    if (rst.isBeforeFirst()) {
                        while (rst.next()) {
                            String nextKey = rst.getString(1);
                            long nextLastAccessTime = rst.getLong(2);
                            ConfigChangeElement nextElem = new ConfigChangeElement(nextKey, new Long(nextLastAccessTime));
                            keyList.add(nextElem);
                        }
                        rst.close();
                        BaseCache mainStoreCachedSessions = this.getMainStoreCache();
                        for (int i = 0; i < keyList.size(); ++i) {
                            ConfigChangeElement nextElem = (ConfigChangeElement)keyList.get(i);
                            String nextId = nextElem.getName();
                            long nextPersistentLastAccessTime = (Long)nextElem.getValue();
                            Session cachedSession = (Session)mainStoreCachedSessions.get((Object)nextId);
                            long nextCachedLastAccessTime = ((StandardSession)cachedSession).getLastAccessedTimeInternal();
                            if (nextCachedLastAccessTime >= nextPersistentLastAccessTime) continue;
                            staleIdList.add(nextId);
                        }
                        connection.commit();
                        this.closeStatement(this.preparedKeysSql);
                        String[] template = new String[staleIdList.size()];
                        keys = staleIdList.toArray(template);
                        this.removeSessionsForCache(keys);
                        HAManagerBase mgr = (HAManagerBase)this.getManager();
                        mgr.removeSessionIdsFromManagerCache(keys);
                        this.haErrRemoveExpired.txEnd();
                        return;
                    }
                    rst.close();
                    break;
                }
                catch (SQLException e) {
                    this.closeStatement(this.preparedKeysSql);
                    this.haErrRemoveExpired.checkError(e, connection);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                connection.rollback();
                this.closeStatement(this.preparedKeysSql);
            }
            catch (SQLException ee) {
                ee.printStackTrace();
            }
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from HAStore-removeStaleCachedSessions: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
    }

    private String getInClause(String[] ids, int startIdx, int endIdx) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = startIdx; i < endIdx; ++i) {
            if (i != startIdx) {
                sb.append(", ");
            }
            sb.append("'" + ids[i] + "'");
        }
        sb.append(")");
        return sb.toString();
    }

    public void removeFromStoreCache(String id) {
        this.removeSessionFromMainStoreCache(id);
    }

    private int removeExpiredSessions(Connection connection, int chunk) throws IOException {
        int result = 0;
        String[] keys = null;
        ArrayList<String> keyList = new ArrayList<String>(100);
        if (connection == null) {
            return result;
        }
        ResultSet rst = null;
        long timeNow = System.currentTimeMillis();
        Manager mgr = this.getManager();
        long maxInactiveIntervalMillis = mgr.getMaxInactiveInterval() * 1000;
        long relevantTime = timeNow;
        PreparedStatement preparedKeysSql = null;
        String keysSql = "SELECT id FROM " + this.blobSessionTable + " WHERE appid = '" + this.getApplicationId() + "'" + " AND ((lastaccess + (maxinactive * 1000)) < ? OR valid = '0')" + "ORDER BY id";
        PreparedStatement preparedDeleteSql = null;
        String deleteSql = "DELETE FROM " + this.blobSessionTable + " WHERE id BETWEEN ? AND ? AND appid = '" + this.getApplicationId() + "'" + " AND ((lastaccess + (maxinactive * 1000)) < ? OR valid = '0')";
        try {
            this.haErrRemoveExpired.txStart();
            while (!this.haErrRemoveExpired.isTxCompleted()) {
                try {
                    boolean moreLeft = true;
                    while (moreLeft) {
                        preparedKeysSql = connection.prepareStatement(keysSql);
                        preparedKeysSql.setLong(1, relevantTime);
                        rst = preparedKeysSql.executeQuery();
                        if (!rst.isBeforeFirst()) {
                            rst.close();
                            moreLeft = false;
                            break;
                        }
                        int rowno = 0;
                        String keyLow = null;
                        String keyHigh = null;
                        boolean chunkSizeReached = false;
                        while (rst.next()) {
                            if (rowno == 0) {
                                keyLow = rst.getString(1);
                            }
                            keyHigh = rst.getString(1);
                            keyList.add(rst.getString(1));
                            if (++rowno < chunk) continue;
                            chunkSizeReached = true;
                            break;
                        }
                        if (!chunkSizeReached) {
                            moreLeft = false;
                        }
                        rst.close();
                        preparedDeleteSql = connection.prepareStatement(deleteSql);
                        preparedDeleteSql.setString(1, keyLow);
                        preparedDeleteSql.setString(2, keyHigh);
                        preparedDeleteSql.setLong(3, relevantTime);
                        int cnt = preparedDeleteSql.executeUpdate();
                        result += cnt;
                        connection.commit();
                    }
                    connection.commit();
                    this.closeStatement(preparedKeysSql);
                    this.closeStatement(preparedDeleteSql);
                    String[] template = new String[keyList.size()];
                    keys = keyList.toArray(template);
                    this.removeSessionsForCache(keys);
                    this.haErrRemoveExpired.txEnd();
                    _logger.finest("HAStore>>removeExpiredSessions: result = " + result);
                    return result;
                }
                catch (SQLException e) {
                    this.closeStatement(preparedKeysSql);
                    this.closeStatement(preparedDeleteSql);
                    this.haErrRemoveExpired.checkError(e, connection);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                connection.rollback();
                this.closeStatement(preparedKeysSql);
                this.closeStatement(preparedDeleteSql);
            }
            catch (SQLException ee) {
                ee.printStackTrace();
            }
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from HAStore-removeExpiredSessions: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        _logger.finest("HAStore>>removeExpiredSessions: result = " + result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSessionsForCache(String[] sessionIds) {
        BaseCache mainStoreCachedSessions;
        HAManagerBase mgr = (HAManagerBase)this.getManager();
        BaseCache baseCache = mainStoreCachedSessions = this.getMainStoreCache();
        synchronized (baseCache) {
            for (int i = 0; i < sessionIds.length; ++i) {
                String nextId = sessionIds[i];
                StandardSession nextSess = null;
                try {
                    nextSess = (StandardSession)mgr.findSessionFromCacheOnly(nextId);
                }
                catch (IOException ex) {
                    // empty catch block
                }
                if (nextSess == null) continue;
                nextSess.expire(true, false);
                if (nextId == null) continue;
                mainStoreCachedSessions.remove((Object)nextId);
            }
        }
    }

    public String[] keys(String sessionTable) throws IOException {
        String[] keys;
        ResultSet rst;
        block14: {
            String[] result = new String[]{};
            String keysSql = "SELECT id FROM " + sessionTable + " WHERE appid = '" + this.getApplicationId() + "'";
            try {
                Connection conn = this.getConnectionValidated(false);
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (this.conn == null) {
                return result;
            }
            rst = null;
            keys = null;
            if (this.preparedKeysSql == null) {
                this.preparedKeysSql = this.conn.prepareStatement(keysSql);
            }
            if ((rst = this.executeStatement(this.preparedKeysSql, true, this.haErrKeys)) != null) break block14;
            if (this._debug > 0) {
                this.debug("keys(): No rows returned, returning an empty array");
            }
            String[] stringArray = new String[]{};
            this.closeResultSet(rst);
            return stringArray;
        }
        try {
            ArrayList<String> keysArray = new ArrayList<String>();
            int i = 0;
            while (rst.next()) {
                if (this._debug > 0) {
                    this.debug("in keys, id is " + rst.getString(1));
                }
                keysArray.add(rst.getString(1));
                ++i;
            }
            keys = keysArray.toArray(new String[0]);
            this.conn.commit();
            this.closeResultSet(rst);
        }
        catch (SQLException e) {
            try {
                try {
                    this.conn.rollback();
                }
                catch (SQLException ee) {
                    // empty catch block
                }
                IOException ex1 = (IOException)new IOException("Error from HA Store: " + e.getMessage()).initCause(e);
                throw ex1;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rst);
                throw throwable;
            }
        }
        return keys;
    }

    public String[] expiredKeys() throws IOException {
        return this.expiredKeys(this.blobSessionTable);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] expiredKeys(String sessionTable) throws IOException {
        String[] result = new String[]{};
        long timeNow = System.currentTimeMillis();
        Manager mgr = this.getManager();
        long maxInactiveIntervalMillis = mgr.getMaxInactiveInterval() * 1000;
        long relevantTime = timeNow - maxInactiveIntervalMillis;
        String expiredKeysSql = "SELECT id FROM " + sessionTable + " WHERE appid = '" + this.getApplicationId() + "'" + " AND (lastaccess < ? OR valid = '0')";
        try {
            Connection conn = this.getConnectionValidated(false);
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (this.conn == null) {
            return result;
        }
        ResultSet rst = null;
        String[] keys = null;
        try {
            this.haErrExpiredKeys.txStart();
            while (!this.haErrExpiredKeys.isTxCompleted()) {
                try {
                    if (this.preparedExpiredKeysSql == null) {
                        this.preparedExpiredKeysSql = this.conn.prepareStatement(expiredKeysSql);
                    }
                    this.preparedExpiredKeysSql.setLong(1, relevantTime);
                    rst = this.preparedExpiredKeysSql.executeQuery();
                    if (rst == null) {
                        if (this._debug > 0) {
                            this.debug("expiredKeys(): No rows returned, returning an empty array");
                        }
                        String[] stringArray = new String[]{};
                        this.closeResultSet(rst);
                        return stringArray;
                    }
                    ArrayList<String> keysArray = new ArrayList<String>();
                    int i = 0;
                    while (rst.next()) {
                        if (this._debug > 0) {
                            this.debug("in expiredKeys, id is " + rst.getString(1));
                        }
                        keysArray.add(rst.getString(1));
                        ++i;
                    }
                    keys = keysArray.toArray(new String[0]);
                    this.conn.commit();
                    this.haErrExpiredKeys.txEnd();
                }
                catch (SQLException e) {
                    this.haErrExpiredKeys.checkError(e, this.conn);
                }
            }
            this.closeResultSet(rst);
            return keys;
        }
        catch (SQLException e) {
            try {
                try {
                    this.conn.rollback();
                }
                catch (SQLException ee) {
                    // empty catch block
                }
                IOException ex1 = (IOException)new IOException("Error from HA Store expiredKeys: " + e.getMessage()).initCause(e);
                throw ex1;
                catch (HATimeoutException tex) {
                    IOException ex2 = (IOException)new IOException("Timeout from HA Store expiredKeys " + tex.getMessage()).initCause(tex);
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                this.closeResultSet(rst);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Session load(String id) throws ClassNotFoundException, IOException {
        block52: {
            block54: {
                block55: {
                    block48: {
                        block51: {
                            block46: {
                                block53: {
                                    block47: {
                                        if (HAStore._logger.isLoggable(Level.FINEST)) {
                                            HAStore._logger.finest("IN NEW LOAD METHOD");
                                        }
                                        if (!EEHADBHealthChecker.isOkToProceed()) {
                                            return null;
                                        }
                                        if (id == null) {
                                            if (this._debug > 0) {
                                                this.debug("in load, id is null, returning null");
                                            }
                                            Thread.dumpStack();
                                            return null;
                                        }
                                        session = this.getSessionFromMainStoreCache(id);
                                        if (session != null) {
                                            if (this._debug <= 0) return session;
                                            this.debug("Session " + id + " loaded from cache");
                                            return session;
                                        }
                                        rst = null;
                                        connGroup = null;
                                        try {
                                            connGroup = this.getConnectionsFromPool(true);
                                        }
                                        catch (IOException ex) {
                                            params = new Object[]{"HAStore>>load"};
                                            HAStore._logger.log(Level.SEVERE, "hastore.hadbConnectionFailure1", params);
                                            HAStore._logger.log(Level.SEVERE, "hastore.hadbConnectionFailure2", params);
                                            HAStore._logger.log(Level.SEVERE, "hastore.hadbConnectionFailure3", params);
                                        }
                                        if (connGroup == null) {
                                            if (this._debug > 0) {
                                                this.debug("HAStore>>load: Failure to obtain connection from pool: returning null");
                                            }
                                            config = new ServerConfigLookup();
                                            connURL = config.getConnectionURLFromConfig();
                                            HAStore._logger.warning("ConnectionUtil>>getConnectionsFromPool failed using connection URL: " + connURL + " -- returning null. Check connection pool configuration.");
                                            return null;
                                        }
                                        internalConn = connGroup._internalConn;
                                        externalConn = connGroup._externalConn;
                                        shortAppId = null;
                                        loadSql = "SELECT id, sessdata, username , ssoid, appid FROM " + this.blobSessionTable + " WHERE id = ? AND appid = ?";
                                        try {
                                            try {
                                                this.haErrLoad.txStart();
                                                while (!this.haErrLoad.isTxCompleted()) {
                                                    try {
                                                        this.preparedLoadSql = internalConn.prepareStatement(loadSql);
                                                        this.preparedLoadSql.setString(1, id);
                                                        this.preparedLoadSql.setString(2, this.getApplicationId());
                                                        rst = this.preparedLoadSql.executeQuery();
                                                        if (rst == null || !rst.next()) {
                                                            if (this._debug > 0) {
                                                                this.debug("No persisted data found for session " + id);
                                                            }
                                                            var9_11 = null;
                                                        }
                                                        ** GOTO lbl-1000
                                                    }
                                                    catch (SQLException e) {
                                                        this.closeStatement(this.preparedLoadSql);
                                                        this.preparedLoadSql = null;
                                                        this.haErrLoad.checkError(e, internalConn);
                                                    }
                                                    var12_19 = null;
                                                    this.closeResultSet(rst);
                                                    if (this.preparedLoadSql == null) break block46;
                                                    break block47;
lbl60:
                                                    // 2 sources

                                                    return var9_11;
lbl-1000:
                                                    // 1 sources

                                                    {
                                                        session = this.getSession(rst);
                                                        appId = rst.getString(5);
                                                        shortAppId = this.extractShortApplicationIdFromApplicationId(appId);
                                                        this.preparedLoadSql.close();
                                                        this.preparedLoadSql = null;
                                                        try {
                                                            externalConn.close();
                                                        }
                                                        catch (SQLException ex) {
                                                            // empty catch block
                                                        }
                                                        externalConn = null;
                                                        this.haErrLoad.txEnd();
                                                    }
                                                }
                                                break block48;
                                            }
                                            catch (SQLException e) {
                                                try {
                                                    internalConn.rollback();
                                                }
                                                catch (SQLException ee) {
                                                    // empty catch block
                                                }
                                                e.printStackTrace();
                                                ex1 = (IOException)new IOException("Error from HA Store load: " + e.getMessage()).initCause(e);
                                                throw ex1;
                                            }
                                            catch (HATimeoutException tex) {
                                                ex2 = (IOException)new IOException("Timeout from HA Store load " + tex.getMessage()).initCause(tex);
                                                throw ex2;
                                            }
                                        }
                                        catch (Throwable var11_25) {
                                            var12_21 = null;
                                            this.closeResultSet(rst);
                                            if (this.preparedLoadSql != null) {
                                                try {
                                                    this.preparedLoadSql.close();
                                                }
                                                catch (SQLException e) {
                                                    // empty catch block
                                                }
                                                this.preparedLoadSql = null;
                                            }
                                            if (externalConn != null) {
                                                try {
                                                    externalConn.close();
                                                }
                                                catch (Exception ex) {
                                                    // empty catch block
                                                }
                                            }
                                            if ((stdSess = (StandardSession)session) == null || !stdSess.isForegroundLocked()) throw var11_25;
                                            if (HAStore._logger.isLoggable(Level.FINEST)) {
                                                HAStore._logger.finest("inHAStore>>load before unlockForeground:lock = " + stdSess.getSessionLock());
                                            }
                                            stdSess.unlockForeground();
                                            if (!HAStore._logger.isLoggable(Level.FINEST)) throw var11_25;
                                            HAStore._logger.finest("inHAStore>>load after unlockForeground:lock = " + stdSess.getSessionLock());
                                            throw var11_25;
                                        }
                                    }
                                    ** try [egrp 7[TRYBLOCK] [12 : 625->637)] { 
lbl116:
                                    // 1 sources

                                    this.preparedLoadSql.close();
                                    break block53;
lbl118:
                                    // 1 sources

                                    catch (SQLException e) {
                                        // empty catch block
                                    }
                                }
                                this.preparedLoadSql = null;
                            }
                            if (externalConn != null) {
                                ** try [egrp 8[TRYBLOCK] [13 : 649->659)] { 
lbl125:
                                // 1 sources

                                externalConn.close();
                                break block51;
lbl127:
                                // 1 sources

                                catch (Exception ex) {
                                    // empty catch block
                                }
                            }
                        }
                        if ((stdSess = (StandardSession)session) == null || !stdSess.isForegroundLocked()) ** GOTO lbl60
                        if (HAStore._logger.isLoggable(Level.FINEST)) {
                            HAStore._logger.finest("inHAStore>>load before unlockForeground:lock = " + stdSess.getSessionLock());
                        }
                        stdSess.unlockForeground();
                        if (!HAStore._logger.isLoggable(Level.FINEST)) ** GOTO lbl60
                        HAStore._logger.finest("inHAStore>>load after unlockForeground:lock = " + stdSess.getSessionLock());
                        return var9_11;
                    }
                    var12_20 = null;
                    this.closeResultSet(rst);
                    if (this.preparedLoadSql == null) break block54;
                    ** try [egrp 7[TRYBLOCK] [12 : 625->637)] { 
lbl142:
                    // 1 sources

                    this.preparedLoadSql.close();
                    break block55;
lbl144:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                this.preparedLoadSql = null;
            }
            if (externalConn != null) {
                ** try [egrp 8[TRYBLOCK] [13 : 649->659)] { 
lbl151:
                // 1 sources

                externalConn.close();
                break block52;
lbl153:
                // 1 sources

                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if ((stdSess = (StandardSession)session) != null && stdSess.isForegroundLocked()) {
            if (HAStore._logger.isLoggable(Level.FINEST)) {
                HAStore._logger.finest("inHAStore>>load before unlockForeground:lock = " + stdSess.getSessionLock());
            }
            stdSess.unlockForeground();
            if (HAStore._logger.isLoggable(Level.FINEST)) {
                HAStore._logger.finest("inHAStore>>load after unlockForeground:lock = " + stdSess.getSessionLock());
            }
        }
        if (!this.getShortApplicationId().equals(shortAppId)) {
            ((HAManagerBase)this.manager).removeSessionFromManagerCache(session);
            return null;
        }
        this.putSessionInMainStoreCache(session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session getSession(ResultSet rst) throws SQLException, IOException, ClassNotFoundException {
        String ssoId;
        Principal pal;
        Session _session;
        block23: {
            _session = null;
            BufferedInputStream bis = null;
            Loader loader = null;
            ClassLoader classLoader = null;
            ObjectInputStream ois = null;
            Container container = this.manager.getContainer();
            pal = null;
            ssoId = null;
            IOUtilsCaller utilsCaller = null;
            try {
                String id = rst.getString(1);
                Blob blob = rst.getBlob(2);
                String username = rst.getString(3);
                ssoId = rst.getString(4);
                if (username != null && !username.equals("")) {
                    if (this._debug > 0) {
                        this.debug("Username retrived from DB is " + username);
                    }
                    pal = ((RealmAdapter)container.getRealm()).createFailOveredPrincipal(username);
                    if (this._debug > 0) {
                        this.debug("principal created using username  " + pal);
                    }
                }
                bis = new BufferedInputStream(blob.getBinaryStream());
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("loaded seasion from hastore, length = " + blob.length());
                }
                if (container != null) {
                    loader = container.getLoader();
                }
                if (loader != null) {
                    classLoader = loader.getClassLoader();
                }
                if (classLoader != null && (utilsCaller = this.getWebUtilsCaller()) != null) {
                    try {
                        ois = utilsCaller.createObjectInputStream((InputStream)bis, true, classLoader);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (ois == null) {
                    ois = new ObjectInputStream(bis);
                }
                if (ois == null) break block23;
                try {
                    _session = this.readSession(this.manager, ois);
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                            bis = null;
                        }
                        catch (IOException e) {}
                    }
                }
            }
            catch (ClassNotFoundException e) {
                System.err.println("getSession :" + e.getMessage());
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
        }
        _session.setNew(false);
        _session.setPrincipal(pal);
        if (ssoId != null && !ssoId.equals("")) {
            this.associate(ssoId, _session);
        }
        if (this._debug > 0) {
            this.debug("getSession principal=" + pal + " was added to session=" + _session);
        }
        return _session;
    }

    protected void associate(String ssoId, Session _session) {
        if (this._debug > 0) {
            this.debug("Inside associate() -- HAStore");
        }
        Container parent = this.manager.getContainer();
        SingleSignOn sso = null;
        while (sso == null && parent != null) {
            if (this._debug > 0) {
                this.debug("Inside associate()  while loop -- HAStore");
            }
            if (!(parent instanceof Pipeline)) {
                if (this._debug > 0) {
                    this.debug("Inside associate()  parent instanceof Pipeline -- HAStore");
                }
                parent = parent.getParent();
                continue;
            }
            Valve[] valves = ((Pipeline)parent).getValves();
            for (int i = 0; i < valves.length; ++i) {
                if (!(valves[i] instanceof SingleSignOn)) continue;
                if (this._debug > 0) {
                    this.debug("Inside associate()  valves[i] instanceof SingleSignOn -- HAStore");
                }
                sso = (SingleSignOn)valves[i];
                break;
            }
            if (sso != null) continue;
            parent = parent.getParent();
        }
        if (sso != null) {
            if (this._debug > 0) {
                this.debug("Inside associate() sso != null");
            }
            SingleSignOnEntry ssoEntry = ((HASingleSignOn)sso).lookupEntry(ssoId);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Inside associate() ssoEntry = " + ssoEntry);
            }
            if (ssoEntry != null) {
                ssoEntry.addSession(sso, _session);
            }
        }
    }

    public void remove(String id) throws IOException {
        if (this._debug > 0) {
            this.debug("in remove");
        }
        if (id == null) {
            if (this._debug > 0) {
                this.debug("In remove, got a null id");
            }
            return;
        }
        Manager mgr = this.getManager();
        if (mgr instanceof HAManagerBase) {
            HAManagerBase pMgr = (HAManagerBase)mgr;
            pMgr.doRemove(id);
        } else {
            this.removeSynchronized(id);
        }
    }

    public synchronized void removeSynchronized(String id) throws IOException {
        if (this._debug > 0) {
            this.debug("in remove");
        }
        if (id == null) {
            if (this._debug > 0) {
                this.debug("In remove, got a null id");
            }
            return;
        }
        HADBConnectionGroup connGroup = null;
        try {
            connGroup = this.getConnectionsFromPool(true);
        }
        catch (IOException ex) {
            Object[] params = new Object[]{"HAStore>>remove"};
            _logger.log(Level.SEVERE, "hastore.hadbConnectionFailure1", params);
            _logger.log(Level.SEVERE, "hastore.hadbConnectionFailure2", params);
            _logger.log(Level.SEVERE, "hastore.hadbConnectionFailure3", params);
        }
        if (connGroup == null) {
            if (this._debug > 0) {
                this.debug("HAStore>>remove: Failure to obtain connection from pool");
            }
            ServerConfigLookup config = new ServerConfigLookup();
            String connURL = config.getConnectionURLFromConfig();
            _logger.warning("ConnectionUtil>>getConnectionsFromPool failed using connection URL: " + connURL + " -- returning null. Check connection pool configuration.");
            return;
        }
        Connection internalConn = connGroup._internalConn;
        Connection externalConn = connGroup._externalConn;
        this.sessions.remove((Object)id);
        String removeSql = "DELETE FROM " + this.blobSessionTable + " WHERE id = ? AND appid = ?";
        try {
            this.haErrRemove.txStart();
            while (!this.haErrRemove.isTxCompleted()) {
                try {
                    this.preparedRemoveSql = internalConn.prepareStatement(removeSql);
                    this.preparedRemoveSql.setString(1, id);
                    this.preparedRemoveSql.setString(2, this.getApplicationId());
                    this.preparedRemoveSql.executeUpdate();
                    this.preparedRemoveSql.close();
                    this.preparedRemoveSql = null;
                    try {
                        externalConn.close();
                    }
                    catch (SQLException ex) {
                        // empty catch block
                    }
                    externalConn = null;
                    this.haErrRemove.txEnd();
                }
                catch (SQLException e) {
                    this.closeStatement(this.preparedRemoveSql);
                    this.preparedRemoveSql = null;
                    this.haErrRemove.checkError(e, internalConn);
                }
            }
        }
        catch (SQLException e) {
            try {
                internalConn.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from HA Store remove: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from HA Store remove " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        finally {
            if (this.preparedRemoveSql != null) {
                try {
                    this.preparedRemoveSql.close();
                }
                catch (SQLException e) {}
                this.preparedRemoveSql = null;
            }
            if (externalConn != null) {
                try {
                    externalConn.close();
                }
                catch (Exception ex) {}
            }
        }
        if (this._debug > 0) {
            this.debug("Removed session " + id + " from HA Store");
        }
    }

    public void doRemove(String id) throws IOException {
        if (this._debug > 0) {
            this.debug("in remove");
        }
        if (id == null) {
            if (this._debug > 0) {
                this.debug("In remove, got a null id");
            }
            return;
        }
        HADBConnectionGroup connGroup = null;
        try {
            connGroup = this.getConnectionsFromPool(true);
        }
        catch (IOException ex) {
            Object[] params = new Object[]{"HAStore>>remove"};
            _logger.log(Level.SEVERE, "hastore.hadbConnectionFailure1", params);
            _logger.log(Level.SEVERE, "hastore.hadbConnectionFailure2", params);
            _logger.log(Level.SEVERE, "hastore.hadbConnectionFailure3", params);
        }
        if (connGroup == null) {
            if (this._debug > 0) {
                this.debug("HAStore>>remove: Failure to obtain connection from pool");
            }
            ServerConfigLookup config = new ServerConfigLookup();
            String connURL = config.getConnectionURLFromConfig();
            _logger.warning("ConnectionUtil>>getConnectionsFromPool failed using connection URL: " + connURL + " -- returning null. Check connection pool configuration.");
            return;
        }
        Connection internalConn = connGroup._internalConn;
        Connection externalConn = connGroup._externalConn;
        this.sessions.remove((Object)id);
        String removeSql = "DELETE FROM " + this.blobSessionTable + " WHERE id = ? AND appid = ?";
        try {
            this.haErrRemove.txStart();
            while (!this.haErrRemove.isTxCompleted()) {
                try {
                    this.preparedRemoveSql = internalConn.prepareStatement(removeSql);
                    this.preparedRemoveSql.setString(1, id);
                    this.preparedRemoveSql.setString(2, this.getApplicationId());
                    this.preparedRemoveSql.executeUpdate();
                    this.preparedRemoveSql.close();
                    this.preparedRemoveSql = null;
                    try {
                        externalConn.close();
                    }
                    catch (SQLException ex) {
                        // empty catch block
                    }
                    externalConn = null;
                    this.haErrRemove.txEnd();
                }
                catch (SQLException e) {
                    this.closeStatement(this.preparedRemoveSql);
                    this.preparedRemoveSql = null;
                    this.haErrRemove.checkError(e, internalConn);
                }
            }
        }
        catch (SQLException e) {
            try {
                internalConn.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from HA Store remove: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from HA Store remove " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        finally {
            if (this.preparedRemoveSql != null) {
                try {
                    this.preparedRemoveSql.close();
                }
                catch (SQLException e) {}
                this.preparedRemoveSql = null;
            }
            if (externalConn != null) {
                try {
                    externalConn.close();
                }
                catch (Exception ex) {}
            }
        }
        if (this._debug > 0) {
            this.debug("Removed session " + id + " from HA Store");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() throws IOException {
        if (this._debug > 0) {
            this.debug("in clear");
        }
        this.sessions = new BaseCache();
        this.sessions.init(_maxBaseCacheSize, _loadFactor, null);
        HADBConnectionGroup connGroup = null;
        try {
            connGroup = this.getConnectionsFromPool(true);
        }
        catch (IOException ex) {
            Object[] params = new Object[]{"HAStore>>clear"};
            _logger.log(Level.SEVERE, "hastore.hadbConnectionFailure1", params);
            _logger.log(Level.SEVERE, "hastore.hadbConnectionFailure2", params);
            _logger.log(Level.SEVERE, "hastore.hadbConnectionFailure3", params);
        }
        if (connGroup == null) {
            if (this._debug > 0) {
                this.debug("HAStore>>clear: Failure to obtain connection from pool");
            }
            ServerConfigLookup config = new ServerConfigLookup();
            String connURL = config.getConnectionURLFromConfig();
            _logger.warning("ConnectionUtil>>getConnectionsFromPool failed using connection URL: " + connURL + " -- returning null. Check connection pool configuration.");
            return;
        }
        Connection internalConn = connGroup._internalConn;
        Connection externalConn = connGroup._externalConn;
        try {
            this.removeAllSessions(internalConn, CHUNK_SIZE);
            try {
                externalConn.close();
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            externalConn = null;
        }
        catch (IOException ex) {
            _logger.log(Level.WARNING, "clear: failed to remove all the sessions for this app " + this.getApplicationId());
            ex.printStackTrace();
        }
        finally {
            if (externalConn != null) {
                try {
                    externalConn.close();
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
                externalConn = null;
            }
        }
    }

    public void removeAllSessions(Connection connection, int chunk) throws IOException {
        if (connection == null) {
            return;
        }
        int result = 0;
        ResultSet rst = null;
        PreparedStatement preparedKeysSql = null;
        String keysSql = "SELECT id FROM " + this.blobSessionTable + " WHERE appid = ? ORDER BY id";
        PreparedStatement preparedDeleteSql = null;
        String deleteSql = "DELETE FROM " + this.blobSessionTable + " WHERE id BETWEEN ? AND ? AND appid = ?";
        try {
            this.haErrClear.txStart();
            while (!this.haErrClear.isTxCompleted()) {
                try {
                    boolean moreLeft = true;
                    while (moreLeft) {
                        preparedKeysSql = connection.prepareStatement(keysSql);
                        preparedKeysSql.setString(1, this.getApplicationId());
                        rst = preparedKeysSql.executeQuery();
                        if (!rst.isBeforeFirst()) {
                            rst.close();
                            moreLeft = false;
                            break;
                        }
                        int rowno = 0;
                        String keyLow = null;
                        String keyHigh = null;
                        boolean chunkSizeReached = false;
                        while (rst.next()) {
                            if (rowno == 0) {
                                keyLow = rst.getString(1);
                            }
                            keyHigh = rst.getString(1);
                            if (++rowno < chunk) continue;
                            chunkSizeReached = true;
                            break;
                        }
                        if (!chunkSizeReached) {
                            moreLeft = false;
                        }
                        rst.close();
                        preparedDeleteSql = connection.prepareStatement(deleteSql);
                        preparedDeleteSql.setString(1, keyLow);
                        preparedDeleteSql.setString(2, keyHigh);
                        preparedDeleteSql.setString(3, this.getApplicationId());
                        int cnt = preparedDeleteSql.executeUpdate();
                        result += cnt;
                        connection.commit();
                    }
                    connection.commit();
                    this.closeStatement(preparedKeysSql);
                    this.closeStatement(preparedDeleteSql);
                    this.haErrClear.txEnd();
                    _logger.finest("HAStore>>removeAllSessions - successfully removed " + result + " sessions");
                    return;
                }
                catch (SQLException e) {
                    this.closeStatement(preparedKeysSql);
                    this.closeStatement(preparedDeleteSql);
                    preparedKeysSql = null;
                    preparedDeleteSql = null;
                    this.haErrClear.checkError(e, connection);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            try {
                connection.rollback();
                this.closeStatement(preparedKeysSql);
                this.closeStatement(preparedDeleteSql);
            }
            catch (SQLException ee) {
                ee.printStackTrace();
            }
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from HAStore-removeAllSessions: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        _logger.finest("HAStore>removeAllSessions - successfully removed " + result + " sessions");
    }

    public void save(Session session) throws IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("XXXXXXX In save, id is " + session.getIdInternal());
        }
        if (!EEHADBHealthChecker.isOkToProceed()) {
            return;
        }
        if (!((StandardSession)session).getIsValid()) {
            return;
        }
        boolean isMonitoringEnabled = ServerConfigReader.isMonitoringEnabled();
        long startTime = 0L;
        HAManagerBase mgr = (HAManagerBase)this.getManager();
        WebModuleStatistics stats = mgr.getWebModuleStatistics();
        if (isMonitoringEnabled) {
            startTime = System.currentTimeMillis();
        }
        HASession sess = (HASession)session;
        boolean previousDirtyFlag = sess.isDirty();
        if (this._debug > 0) {
            this.debug("in save");
        }
        Connection conn = this.getConnection(false);
        byte[] in = null;
        boolean sessionIsPersistent = false;
        boolean sessionInStoreOk = false;
        try {
            sessionIsPersistent = this.sessionInStore(session);
            sessionInStoreOk = true;
        }
        catch (IOException ex) {
            sessionInStoreOk = false;
        }
        if (!sessionInStoreOk) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "HAStore-save: sessionInStore failed: aborting save ");
            }
            return;
        }
        try {
            if (sessionIsPersistent) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("Session is in store");
                }
                if (sess.isDirty()) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("Session IS Dirty");
                    }
                    in = this.getByteArray(session);
                    this.updateSessionBlob(session, in);
                } else {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("Session is NOT Dirty");
                    }
                    this.updateSessionNoDataBlob(session, in);
                }
            } else {
                in = this.getByteArray(session);
                this.insertSessionBlob(session, in);
            }
            sess.setDirty(false);
            if (isMonitoringEnabled) {
                long endTime = System.currentTimeMillis();
                stats.processBackgroundSave(endTime - startTime);
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("session class= " + sess.getClass().getName());
                _logger.finest("after save: session dirty= " + sess.isDirty());
            }
        }
        catch (IOException e) {
            sess.setDirty(previousDirtyFlag);
            e.printStackTrace();
            throw e;
        }
        if (this._debug > 0) {
            this.debug("Saved session " + session.getIdInternal() + " into HA Store");
        }
        this.putSessionInMainStoreCache(session);
    }

    public void valveSave(Session session) throws IOException {
        boolean sessionInStoreOk;
        boolean sessionIsPersistent;
        byte[] in;
        Connection externalConn;
        Connection internalConn;
        WebModuleStatistics stats;
        boolean previousDirtyFlag;
        HASession sess;
        boolean isMonitoringEnabled;
        block33: {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("XXXXXXX In valveSave, id is " + session.getIdInternal());
            }
            if (!EEHADBHealthChecker.isOkToProceed()) {
                return;
            }
            if (!((StandardSession)session).getIsValid()) {
                return;
            }
            isMonitoringEnabled = ServerConfigReader.isMonitoringEnabled();
            sess = (HASession)session;
            previousDirtyFlag = sess.isDirty();
            if (this._debug > 0) {
                this.debug("in valveSave");
            }
            HAManagerBase mgr = (HAManagerBase)this.getManager();
            stats = mgr.getWebModuleStatistics();
            long getConnStartTime = 0L;
            if (isMonitoringEnabled) {
                getConnStartTime = System.currentTimeMillis();
            }
            HADBConnectionGroup connGroup = null;
            try {
                connGroup = this.getConnectionsFromPool(true);
            }
            catch (IOException ex) {
                Object[] params = new Object[]{"HAStore>>valveSave"};
                _logger.log(Level.SEVERE, "hastore.hadbConnectionFailure1", params);
                _logger.log(Level.SEVERE, "hastore.hadbConnectionFailure2", params);
                _logger.log(Level.SEVERE, "hastore.hadbConnectionFailure3", params);
            }
            if (isMonitoringEnabled) {
                long getConnEndTime = System.currentTimeMillis();
                stats.processGetConnectionFromPool(getConnEndTime - getConnStartTime);
            }
            if (connGroup == null) {
                return;
            }
            internalConn = connGroup._internalConn;
            externalConn = connGroup._externalConn;
            in = null;
            sessionIsPersistent = false;
            sessionInStoreOk = false;
            try {
                sessionIsPersistent = this.sessionInStore(session, internalConn);
                sessionInStoreOk = true;
            }
            catch (IOException ex) {
                sessionInStoreOk = false;
                if (externalConn == null) break block33;
                try {
                    externalConn.close();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
            }
        }
        if (!sessionInStoreOk) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "HAStore-valveSave: sessionInStore failed: aborting save ");
            }
            return;
        }
        try {
            if (sessionIsPersistent) {
                if (sess.isDirty()) {
                    in = this.getByteArray(session);
                    this.updateSessionNewBlob(session, in, internalConn);
                } else {
                    this.updateSessionNoDataNewBlob(session, in, internalConn);
                }
            } else {
                in = this.getByteArray(session);
                this.insertSessionNewBlob(session, in, internalConn);
            }
            sess.setDirty(false);
            long getConnCloseStartTime = 0L;
            if (isMonitoringEnabled) {
                getConnCloseStartTime = System.currentTimeMillis();
            }
            try {
                externalConn.close();
            }
            catch (SQLException ex) {
                // empty catch block
            }
            externalConn = null;
            if (isMonitoringEnabled) {
                long getConnCloseEndTime = System.currentTimeMillis();
                stats.processPutConnectionIntoPool(getConnCloseEndTime - getConnCloseStartTime);
            }
        }
        catch (IOException e) {
            sess.setDirty(previousDirtyFlag);
            e.printStackTrace();
            throw e;
        }
        finally {
            if (externalConn != null) {
                try {
                    externalConn.close();
                }
                catch (Exception ex) {}
            }
        }
        this.putSessionInMainStoreCache(session);
    }

    private void insertSessionNewBlob(Session session, byte[] in, Connection connection) throws IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN insertSessionNewBlob");
        }
        String insertSql = "INSERT INTO " + this.blobSessionTable + " (" + "id, sessdata, valid, maxinactive, lastaccess, appid, username, ssoid) " + "VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        try {
            this.haErr.txStart();
            while (!this.haErr.isTxCompleted()) {
                try {
                    this.preparedInsertSql = connection.prepareStatement(insertSql);
                    this.preparedInsertSql.setString(1, session.getIdInternal());
                    this.preparedInsertSql.setBytes(2, in);
                    this.preparedInsertSql.setString(3, ((StandardSession)session).getIsValid() ? "1" : "0");
                    this.preparedInsertSql.setInt(4, session.getMaxInactiveInterval());
                    this.preparedInsertSql.setLong(5, ((StandardSession)session).getLastAccessedTimeInternal());
                    this.preparedInsertSql.setString(6, this.getApplicationId());
                    if (session.getPrincipal() != null) {
                        if (this._debug > 0) {
                            this.debug(" session.getPrincipal().getName() =" + session.getPrincipal().getName());
                        }
                        this.preparedInsertSql.setString(7, session.getPrincipal().getName());
                    } else {
                        this.preparedInsertSql.setString(7, "");
                        if (this._debug > 0) {
                            this.debug(" session.getPrincipal() =" + session.getPrincipal());
                        }
                    }
                    String ssoId = ((HASession)session).getSsoId();
                    if (ssoId == null) {
                        ssoId = "";
                    }
                    this.preparedInsertSql.setString(8, ssoId);
                    this.preparedInsertSql.executeUpdate();
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("inserted session, length = " + in.length);
                    }
                    this.preparedInsertSql.close();
                    this.preparedInsertSql = null;
                    this.haErr.txEnd();
                }
                catch (SQLException e) {
                    this.closeStatement(this.preparedInsertSql);
                    this.preparedInsertSql = null;
                    this.haErr.checkError(e, connection);
                }
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            if (this.haErr.isPrimaryKeyViolation(e)) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("Redirecting primary key violation from HA Store insertSessionNewBlob to update: " + e.getMessage());
                }
                this.updateSessionNewBlob(session, in, connection);
                return;
            }
            IOException ex1 = (IOException)new IOException("Error from HA Store insertSessionNewBlob: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from HA Store insertSessionNewBlob " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        finally {
            if (this.preparedInsertSql != null) {
                try {
                    this.preparedInsertSql.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private void updateSessionNewBlob(Session session, byte[] in, Connection connection) throws IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN updateSessionNewBlob");
        }
        HAManagerBase mgr = (HAManagerBase)this.getManager();
        WebModuleStatistics stats = mgr.getWebModuleStatistics();
        boolean isMonitoringEnabled = ServerConfigReader.isMonitoringEnabled();
        String updateSql = "UPDATE " + this.blobSessionTable + " SET sessdata = ?, valid = ?, maxinactive = ?, lastaccess = ? , username = ?, ssoid=?" + "WHERE id = ? AND appid = ?";
        long startPrepTime = 0L;
        try {
            this.haErr.txStart();
            while (!this.haErr.isTxCompleted()) {
                try {
                    if (isMonitoringEnabled) {
                        startPrepTime = System.currentTimeMillis();
                    }
                    this.preparedUpdateSql = connection.prepareStatement(updateSql);
                    this.preparedUpdateSql.setBytes(1, in);
                    this.preparedUpdateSql.setString(2, ((StandardSession)session).getIsValid() ? "1" : "0");
                    this.preparedUpdateSql.setInt(3, session.getMaxInactiveInterval());
                    this.preparedUpdateSql.setLong(4, ((StandardSession)session).getLastAccessedTimeInternal());
                    if (session.getPrincipal() != null) {
                        if (this._debug > 0) {
                            this.debug(" session.getPrincipal().getName() =" + session.getPrincipal().getName());
                        }
                        this.preparedUpdateSql.setString(5, session.getPrincipal().getName());
                    } else {
                        this.preparedUpdateSql.setString(5, "");
                        if (this._debug > 0) {
                            this.debug(" session.getPrincipal() =" + session.getPrincipal());
                        }
                    }
                    String ssoId = ((HASession)session).getSsoId();
                    if (ssoId == null) {
                        ssoId = "";
                    }
                    this.preparedUpdateSql.setString(6, ssoId);
                    this.preparedUpdateSql.setString(7, session.getIdInternal());
                    this.preparedUpdateSql.setString(8, this.getApplicationId());
                    if (isMonitoringEnabled) {
                        long endPrepTime = System.currentTimeMillis();
                        stats.processStatementPrepBlock(endPrepTime - startPrepTime);
                    }
                    long startTime = 0L;
                    if (isMonitoringEnabled) {
                        startTime = System.currentTimeMillis();
                    }
                    this.preparedUpdateSql.executeUpdate();
                    if (isMonitoringEnabled) {
                        long endTime = System.currentTimeMillis();
                        stats.processExecuteStatement(endTime - startTime);
                    }
                    long commitStartTime = 0L;
                    if (isMonitoringEnabled) {
                        commitStartTime = System.currentTimeMillis();
                    }
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("updated session, length = " + in.length);
                    }
                    this.preparedUpdateSql.close();
                    this.preparedUpdateSql = null;
                    this.haErr.txEnd();
                }
                catch (SQLException e) {
                    this.closeStatement(this.preparedUpdateSql);
                    this.preparedUpdateSql = null;
                    this.haErr.checkError(e, connection);
                }
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from HA Store updateSessionNewBlob: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from HA Store updateSessionNewBlob: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        finally {
            if (this.preparedUpdateSql != null) {
                try {
                    this.preparedUpdateSql.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private void updateSessionNoDataNewBlob(Session session, byte[] in, Connection connection) throws IOException {
        String updateSql = "UPDATE " + this.blobSessionTable + " SET valid = ?, maxinactive = ?, lastaccess = ? , username = ? , ssoid = ?" + "WHERE id = ? AND appid = ?";
        try {
            this.haErr.txStart();
            while (!this.haErr.isTxCompleted()) {
                try {
                    this.preparedUpdateNoSessionSql = connection.prepareStatement(updateSql);
                    this.preparedUpdateNoSessionSql.setString(1, ((StandardSession)session).getIsValid() ? "1" : "0");
                    this.preparedUpdateNoSessionSql.setInt(2, session.getMaxInactiveInterval());
                    this.preparedUpdateNoSessionSql.setLong(3, ((StandardSession)session).getLastAccessedTimeInternal());
                    if (session.getPrincipal() != null) {
                        if (this._debug > 0) {
                            this.debug(" session.getPrincipal().getName() =" + session.getPrincipal().getName());
                        }
                        this.preparedUpdateNoSessionSql.setString(4, session.getPrincipal().getName());
                    } else {
                        this.preparedUpdateNoSessionSql.setString(4, "");
                    }
                    String ssoId = ((HASession)session).getSsoId();
                    if (ssoId == null) {
                        ssoId = "";
                    }
                    this.preparedUpdateNoSessionSql.setString(5, ssoId);
                    this.preparedUpdateNoSessionSql.setString(6, session.getIdInternal());
                    this.preparedUpdateNoSessionSql.setString(7, this.getApplicationId());
                    this.preparedUpdateNoSessionSql.executeUpdate();
                    this.preparedUpdateNoSessionSql.close();
                    this.preparedUpdateNoSessionSql = null;
                    this.haErr.txEnd();
                }
                catch (SQLException e) {
                    this.closeStatement(this.preparedUpdateNoSessionSql);
                    this.preparedUpdateNoSessionSql = null;
                    this.haErr.checkError(e, connection);
                }
            }
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (Exception e1) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from HA Store updateSessionNoDataNewBlob: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from HA Store updateSessionNoDataNewBlob: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        finally {
            if (this.preparedUpdateNoSessionSql != null) {
                try {
                    this.preparedUpdateNoSessionSql.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public boolean sessionInStore(Session session) throws IOException {
        return this.sessionInStore(session, this.blobSessionTable);
    }

    public boolean sessionInStore(Session session, String storeTable) throws IOException {
        if (!EEHADBHealthChecker.isOkToProceed()) {
            throw new IOException("Error from HA Store-sessionInStore: HADBHealthCheck reports HADB down");
        }
        Session sess = this.getSessionFromMainStoreCache(session.getIdInternal());
        if (sess != null) {
            return true;
        }
        Connection conn = this.getConnection(false);
        String existsSql = "SELECT id FROM " + storeTable + " WHERE id = ? AND appid = ?";
        ResultSet rs = null;
        boolean found = false;
        try {
            this.haErrExists.txStart();
            while (!this.haErrExists.isTxCompleted()) {
                try {
                    if (this.preparedExistsSql == null) {
                        this.preparedExistsSql = conn.prepareStatement(existsSql);
                    }
                    this.preparedExistsSql.setString(1, session.getIdInternal());
                    this.preparedExistsSql.setString(2, this.getApplicationId());
                    rs = this.preparedExistsSql.executeQuery();
                    found = rs != null && rs.next();
                    conn.commit();
                    this.haErrExists.txEnd();
                }
                catch (SQLException e) {
                    this.haErrExists.checkError(e, conn);
                }
            }
        }
        catch (SQLException e) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "HAStore-sessionInStore: EXCEPTION HERE  " + existsSql);
            }
            try {
                conn.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from HA Store-sessionInStore: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from HAStore-sessionInStore: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        finally {
            this.closeResultSet(rs);
        }
        return found;
    }

    public boolean sessionInStore(Session session, Connection conn) throws IOException {
        return this.sessionInStore(session, conn, this.blobSessionTable);
    }

    public boolean sessionInStore(Session session, Connection conn, String storeTable) throws IOException {
        if (!EEHADBHealthChecker.isOkToProceed()) {
            throw new IOException("Error from HA Store-sessionInStore: HADBHealthCheck reports HADB down");
        }
        HAManagerBase mgr = (HAManagerBase)this.getManager();
        HAStore backgroundStore = (HAStore)mgr.getStore();
        BaseCache sesstbl = backgroundStore.getSessions();
        Session sess = (Session)sesstbl.get((Object)session.getIdInternal());
        if (sess != null) {
            return true;
        }
        String existsSql = "SELECT id FROM " + storeTable + " WHERE id = ? AND appid = ?";
        ResultSet rs = null;
        boolean found = false;
        try {
            this.haErrExists2.txStart();
            while (!this.haErrExists2.isTxCompleted()) {
                try {
                    this.preparedExistsSql2 = conn.prepareStatement(existsSql);
                    this.preparedExistsSql2.setString(1, session.getIdInternal());
                    this.preparedExistsSql2.setString(2, this.getApplicationId());
                    rs = this.preparedExistsSql2.executeQuery();
                    found = rs != null && rs.next();
                    conn.commit();
                    this.preparedExistsSql2.close();
                    this.preparedExistsSql2 = null;
                    this.haErrExists2.txEnd();
                }
                catch (SQLException e) {
                    this.closeStatement(this.preparedExistsSql2);
                    this.preparedExistsSql2 = null;
                    this.haErrExists2.checkError(e, conn);
                }
            }
        }
        catch (SQLException e) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "HAStore-sessionInStore: EXCEPTION HERE  " + existsSql);
            }
            try {
                conn.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from HA Store-sessionInStore: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from HAStore-sessionInStore: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
        finally {
            this.closeResultSet(rs);
            if (this.preparedExistsSql2 != null) {
                try {
                    this.preparedExistsSql2.close();
                }
                catch (SQLException e) {}
                this.preparedExistsSql2 = null;
            }
        }
        return found;
    }

    private void insertSessionBlob(Session session, byte[] in) throws IOException {
        String insertSql = "INSERT INTO " + this.blobSessionTable + " (" + "id, sessdata, valid, maxinactive, lastaccess, appid, username, ssoid) " + "VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        try {
            this.haErr.txStart();
            while (!this.haErr.isTxCompleted()) {
                try {
                    if (this.preparedInsertSql == null) {
                        this.preparedInsertSql = this.conn.prepareStatement(insertSql);
                    }
                    this.preparedInsertSql.setString(1, session.getIdInternal());
                    this.preparedInsertSql.setBytes(2, in);
                    this.preparedInsertSql.setString(3, ((StandardSession)session).getIsValid() ? "1" : "0");
                    this.preparedInsertSql.setInt(4, session.getMaxInactiveInterval());
                    this.preparedInsertSql.setLong(5, ((StandardSession)session).getLastAccessedTimeInternal());
                    this.preparedInsertSql.setString(6, this.getApplicationId());
                    if (session.getPrincipal() != null) {
                        if (this._debug > 0) {
                            this.debug(" session.getPrincipal().getName() =" + session.getPrincipal().getName());
                        }
                        this.preparedInsertSql.setString(7, session.getPrincipal().getName());
                    } else {
                        this.preparedInsertSql.setString(7, "");
                    }
                    String ssoId = ((HASession)session).getSsoId();
                    if (ssoId == null) {
                        ssoId = "";
                    }
                    this.preparedInsertSql.setString(8, ssoId);
                    this.preparedInsertSql.executeUpdate();
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("inserted session, length = " + in.length);
                    }
                    this.haErr.txEnd();
                }
                catch (SQLException e) {
                    this.haErr.checkError(e, this.conn);
                }
            }
        }
        catch (SQLException e) {
            try {
                this.conn.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            if (this.haErr.isPrimaryKeyViolation(e)) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("Redirecting primary key violation from HA Store insertSessionNewBlob to update: " + e.getMessage());
                }
                this.updateSessionBlob(session, in);
                return;
            }
            IOException ex1 = (IOException)new IOException("Error from HA Store insertSessionBlob: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from HA Store insertSessionBlob: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
    }

    private void updateSessionBlob(Session session, byte[] in) throws IOException {
        String updateSql = "UPDATE " + this.blobSessionTable + " SET sessdata = ?, valid = ?, maxinactive = ?, lastaccess = ? , username=?, ssoid=?" + "WHERE id = ? AND appid = ?";
        try {
            this.haErr.txStart();
            while (!this.haErr.isTxCompleted()) {
                try {
                    if (this.preparedUpdateSql == null) {
                        this.preparedUpdateSql = this.conn.prepareStatement(updateSql);
                    }
                    this.preparedUpdateSql.setBytes(1, in);
                    this.preparedUpdateSql.setString(2, ((StandardSession)session).getIsValid() ? "1" : "0");
                    this.preparedUpdateSql.setInt(3, session.getMaxInactiveInterval());
                    this.preparedUpdateSql.setLong(4, ((StandardSession)session).getLastAccessedTimeInternal());
                    if (session.getPrincipal() != null) {
                        if (this._debug > 0) {
                            this.debug(" session.getPrincipal().getName() =" + session.getPrincipal().getName());
                        }
                        this.preparedUpdateSql.setString(5, session.getPrincipal().getName());
                    } else {
                        this.preparedUpdateSql.setString(5, "");
                    }
                    String ssoId = ((HASession)session).getSsoId();
                    if (ssoId == null) {
                        ssoId = "";
                    }
                    this.preparedUpdateSql.setString(6, ssoId);
                    this.preparedUpdateSql.setString(7, session.getIdInternal());
                    this.preparedUpdateSql.setString(8, this.getApplicationId());
                    this.preparedUpdateSql.executeUpdate();
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.finest("updated session, length = " + in.length);
                    }
                    this.haErr.txEnd();
                }
                catch (SQLException e) {
                    this.haErr.checkError(e, this.conn);
                }
            }
        }
        catch (SQLException e) {
            try {
                this.conn.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from HA Store updateSessionBlob: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from HA Store updateSessionBlob: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
    }

    private void updateSessionNoDataBlob(Session session, byte[] in) throws IOException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN updateSessionNoDataBlob");
        }
        String updateSql = "UPDATE " + this.blobSessionTable + " SET valid = ?, maxinactive = ?, lastaccess = ? , username= ? , ssoid=?" + "WHERE id = ? AND appid = ?";
        try {
            this.haErr.txStart();
            while (!this.haErr.isTxCompleted()) {
                try {
                    if (this.preparedUpdateNoSessionSql == null) {
                        this.preparedUpdateNoSessionSql = this.conn.prepareStatement(updateSql);
                    }
                    this.preparedUpdateNoSessionSql.setString(1, ((StandardSession)session).getIsValid() ? "1" : "0");
                    this.preparedUpdateNoSessionSql.setInt(2, session.getMaxInactiveInterval());
                    this.preparedUpdateNoSessionSql.setLong(3, ((StandardSession)session).getLastAccessedTimeInternal());
                    if (session.getPrincipal() != null) {
                        if (this._debug > 0) {
                            this.debug(" session.getPrincipal().getName() =" + session.getPrincipal().getName());
                        }
                        this.preparedUpdateNoSessionSql.setString(4, session.getPrincipal().getName());
                    } else {
                        this.preparedUpdateNoSessionSql.setString(4, "");
                    }
                    String ssoId = ((HASession)session).getSsoId();
                    if (ssoId == null) {
                        ssoId = "";
                    }
                    this.preparedUpdateNoSessionSql.setString(5, ssoId);
                    this.preparedUpdateNoSessionSql.setString(6, session.getIdInternal());
                    this.preparedUpdateNoSessionSql.setString(7, this.getApplicationId());
                    this.preparedUpdateNoSessionSql.executeUpdate();
                    this.haErr.txEnd();
                }
                catch (SQLException e) {
                    this.haErr.checkError(e, this.conn);
                }
            }
        }
        catch (SQLException e) {
            try {
                this.conn.rollback();
            }
            catch (SQLException ee) {
                // empty catch block
            }
            IOException ex1 = (IOException)new IOException("Error from HA Store updateSessionNoDataBlob: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException tex) {
            IOException ex2 = (IOException)new IOException("Timeout from HA Store updateSessionNoDataBlob: " + tex.getMessage()).initCause(tex);
            throw ex2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedInputStream getInputStream(Session session, IntHolder length) throws IOException {
        ByteArrayOutputStream bos = null;
        ByteArrayInputStream bis = null;
        ObjectOutputStream oos = null;
        BufferedInputStream in = null;
        IOUtilsCaller utilsCaller = null;
        try {
            bos = new ByteArrayOutputStream();
            utilsCaller = this.getWebUtilsCaller();
            if (utilsCaller != null) {
                try {
                    oos = utilsCaller.createObjectOutputStream((OutputStream)new BufferedOutputStream(bos), true);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (oos == null) {
                oos = new ObjectOutputStream(new BufferedOutputStream(bos));
            }
            this.writeSession(session, oos);
            oos.close();
            oos = null;
            byte[] obs = bos.toByteArray();
            boolean isMonitoringEnabled = ServerConfigReader.isMonitoringEnabled();
            if (isMonitoringEnabled) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("IN HAStore>>getInputStream for monitoring");
                }
                HAManagerBase mgr = (HAManagerBase)this.getManager();
                WebModuleStatistics stats = mgr.getWebModuleStatistics();
                stats.processSessionSize((long)obs.length);
            }
            bis = new ByteArrayInputStream(obs, 0, obs.length);
            in = new BufferedInputStream(bis, obs.length);
            length.value = obs.length;
        }
        finally {
            if (oos != null) {
                oos.close();
            }
            if (bis != null) {
                bis.close();
            }
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getByteArray(Session session) throws IOException {
        byte[] obs;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        IOUtilsCaller utilsCaller = null;
        try {
            bos = new ByteArrayOutputStream();
            utilsCaller = this.getWebUtilsCaller();
            if (utilsCaller != null) {
                try {
                    oos = utilsCaller.createObjectOutputStream((OutputStream)new BufferedOutputStream(bos), true);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (oos == null) {
                oos = new ObjectOutputStream(new BufferedOutputStream(bos));
            }
            this.writeSession(session, oos);
            oos.close();
            oos = null;
            obs = bos.toByteArray();
            boolean isMonitoringEnabled = ServerConfigReader.isMonitoringEnabled();
            if (isMonitoringEnabled) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("IN HAStore>>getInputStream for monitoring");
                }
                HAManagerBase mgr = (HAManagerBase)this.getManager();
                WebModuleStatistics stats = mgr.getWebModuleStatistics();
                stats.processSessionSize((long)obs.length);
            }
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
        return obs;
    }

    protected ResultSet executeStatement(PreparedStatement stmt, boolean isQuery, HAErrorManager errorMgr) throws IOException {
        ResultSet rst = null;
        try {
            errorMgr.txStart();
            while (!errorMgr.isTxCompleted()) {
                try {
                    if (isQuery) {
                        rst = stmt.executeQuery();
                    } else {
                        stmt.executeUpdate();
                    }
                    errorMgr.txEnd();
                }
                catch (SQLException e) {
                    errorMgr.checkError(e, this.conn);
                    if (this._debug <= 0) continue;
                    this.debug("Got a retryable exception from HA Store: " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            IOException ex1 = (IOException)new IOException("Error from HA Store: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from HA Store " + e.getMessage()).initCause(e);
            throw ex1;
        }
        return rst;
    }

    protected ResultSet executeStatement(PreparedStatement stmt, boolean isQuery) throws IOException {
        ResultSet rst = null;
        try {
            this.haErr.txStart();
            while (!this.haErr.isTxCompleted()) {
                try {
                    if (isQuery) {
                        rst = stmt.executeQuery();
                    } else {
                        stmt.executeUpdate();
                    }
                    this.haErr.txEnd();
                }
                catch (SQLException e) {
                    this.haErr.checkError(e, this.conn);
                    if (this._debug <= 0) continue;
                    this.debug("Got a retryable exception from HA Store: " + e.getMessage());
                }
            }
        }
        catch (SQLException e) {
            IOException ex1 = (IOException)new IOException("Error from HA Store: " + e.getMessage()).initCause(e);
            throw ex1;
        }
        catch (HATimeoutException e) {
            IOException ex1 = (IOException)new IOException("Timeout from HA Store " + e.getMessage()).initCause(e);
            throw ex1;
        }
        return rst;
    }

    protected void closeResultSet(ResultSet rst) {
        try {
            if (rst != null) {
                rst.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void cleanup() {
        this.closeStatements();
        this.closeConnection();
        this.setSessions(new BaseCache());
        this.sessions.init(_maxBaseCacheSize, _loadFactor, null);
    }

    protected void closeConnection() {
        try {
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (SQLException ex) {
            // empty catch block
        }
        this.conn = null;
        ConnectionUtil util = this.getConnectionUtil();
        if (util != null) {
            util.clearCachedConnection();
        }
    }

    protected void closeStatements() {
        PreparedStatement[] statements = new PreparedStatement[]{this.preparedKeysSql, this.preparedExpiredKeysSql, this.preparedRemoveExpiredKeysSql, this.preparedSizeSql, this.preparedDualSql, this.preparedLoadSql, this.preparedInsertSql, this.preparedRemoveSql, this.preparedClearSql, this.preparedUpdateSql, this.preparedExistsSql, this.preparedExistsSql2, this.preparedUpdateNoSessionSql};
        for (int i = 0; i < statements.length; ++i) {
            PreparedStatement nextStatement = statements[i];
            this.closeStatement(nextStatement);
        }
        this.clearStatementReferences();
    }

    protected void clearStatementReferences() {
        this.preparedKeysSql = null;
        this.preparedExpiredKeysSql = null;
        this.preparedRemoveExpiredKeysSql = null;
        this.preparedSizeSql = null;
        this.preparedDualSql = null;
        this.preparedLoadSql = null;
        this.preparedInsertSql = null;
        this.preparedRemoveSql = null;
        this.preparedClearSql = null;
        this.preparedUpdateSql = null;
        this.preparedExistsSql = null;
        this.preparedExistsSql2 = null;
        this.preparedUpdateNoSessionSql = null;
    }

    protected void closeStatement(PreparedStatement stmt) {
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void privateForTestSetConnection(Connection connection) {
        this.conn = connection;
    }

    public Connection privateGetConnection(boolean autocommit) throws IOException {
        return this.getConnection(autocommit);
    }

    protected HADBConnectionGroup getConnectionsFromPool() throws IOException {
        ConnectionUtil util = this.getConnectionUtil();
        return util.getConnectionsFromPool();
    }

    protected HADBConnectionGroup getConnectionsFromPool(boolean autoCommit) throws IOException {
        ConnectionUtil util = this.getConnectionUtil();
        return util.getConnectionsFromPool(autoCommit);
    }

    protected Connection getConnectionValidated(boolean autoCommit) throws IOException {
        Connection connection = null;
        boolean keepTrying = true;
        int numRetries = 3;
        int count = 1;
        while (keepTrying) {
            connection = this.getConnection(autoCommit);
            boolean connectionValid = this.validateConnection(connection);
            if (connectionValid) {
                keepTrying = false;
            } else {
                try {
                    this.cleanupConnectionCaches();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.conn = null;
                this.threadSleep(100L);
            }
            if (++count != numRetries) continue;
            keepTrying = false;
        }
        if (this.conn == null) {
            throw new IOException("Could not obtain viable connection");
        }
        try {
            this.conn.setAutoCommit(autoCommit);
        }
        catch (SQLException ex) {
            // empty catch block
        }
        return this.conn;
    }

    protected void cleanupConnectionCaches() {
        this.closeConnection();
        this.closeStatements();
        this.conn = null;
    }

    protected boolean validateConnection(Connection connection) {
        boolean result = true;
        try {
            this.testQueryForConnValidation(connection);
        }
        catch (IOException ex) {
            result = false;
        }
        catch (NullPointerException ex1) {
            result = false;
        }
        return result;
    }

    public int getSizeForConnValidation(Connection connection) throws IOException {
        if (this._debug > 0) {
            this.debug("in getSizeForConnValidation");
        }
        int size = 0;
        String sizeSql = "SELECT COUNT(id) FROM " + this.blobSessionTable + " WHERE appid = '" + this.getApplicationId() + "'";
        ResultSet rst = null;
        try {
            if (this.preparedSizeSql == null) {
                this.preparedSizeSql = connection.prepareStatement(sizeSql);
            }
            if ((rst = this.executeStatement(this.preparedSizeSql, true)).next()) {
                size = rst.getInt(1);
            }
            connection.commit();
            this.closeResultSet(rst);
        }
        catch (SQLException e) {
            try {
                try {
                    connection.rollback();
                }
                catch (SQLException ee) {
                    // empty catch block
                }
                IOException ex1 = (IOException)new IOException("Error from HA Store: " + e.getMessage()).initCause(e);
                throw ex1;
            }
            catch (Throwable throwable) {
                this.closeResultSet(rst);
                throw throwable;
            }
        }
        return size;
    }

    public int testQueryForConnValidation(Connection connection) throws IOException {
        try {
            connection.getMetaData();
            return 1;
        }
        catch (SQLException ex) {
            IOException ex1 = (IOException)new IOException("Error from HA Store Connection Validation: " + ex.getMessage()).initCause(ex);
            throw ex1;
        }
    }

    protected void threadSleep(long sleepTime) {
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected Connection getConnection() throws IOException {
        return this.getConnection(true);
    }

    protected Connection getConnection(boolean autoCommit) throws IOException {
        ConnectionUtil util = this.getConnectionUtil();
        this.conn = util.getConnection(autoCommit);
        return this.conn;
    }

    public void privateCloseCachedConnection() {
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        HAStore.checkSessionCacheProperties();
    }
}

