/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdmk;

import com.sun.jdmk.UnsignedByte;
import com.sun.jdmk.UnsignedInt;
import com.sun.jdmk.UnsignedShort;

public class UnsignedLong
extends Number
implements Comparable {
    private static final long serialVersionUID = 862366467859516825L;
    public static final UnsignedLong MAX_VALUE = new UnsignedLong(-1L);
    static final UnsignedByte ZERO = new UnsignedByte(0);
    static final UnsignedByte ONE = new UnsignedByte(1);
    static final UnsignedByte TWO = new UnsignedByte(2);
    long value;

    public UnsignedLong(long value) {
        this.value = value;
    }

    public static UnsignedLong make(long x) {
        if (x >= 0L) {
            if (x < 256L) {
                if (x == 0L) {
                    return ZERO;
                }
                if (x == 1L) {
                    return ONE;
                }
                return new UnsignedByte((byte)x);
            }
            if (x < 65536L) {
                return new UnsignedShort((short)x);
            }
            if (x < 0x100000000L) {
                return new UnsignedInt((int)x);
            }
        }
        return new UnsignedLong(x);
    }

    UnsignedLong makeIfDifferent(long x) {
        if (this.value == x) {
            return this;
        }
        return UnsignedLong.make(x);
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public double doubleValue() {
        if (this.value >= 0L) {
            return this.value;
        }
        return (double)this.value - -1.8446744073709552E19;
    }

    public float floatValue() {
        if (this.value >= 0L) {
            return this.value;
        }
        return (float)this.value - -1.8446744E19f;
    }

    public int compareTo(Object o) {
        UnsignedLong u = (UnsignedLong)o;
        return UnsignedLong.unsignedCompare(this.value, u.value);
    }

    public int compareTo(long x) {
        if (x < 0L || this.value < 0L || this.value > x) {
            return 1;
        }
        if (this.value == x) {
            return 0;
        }
        return -1;
    }

    public boolean equals(Object o) {
        return o instanceof UnsignedLong && this.value == ((UnsignedLong)o).value;
    }

    public int hashCode() {
        return (int)(this.value >>> 32 ^ this.value);
    }

    public String toString() {
        return UnsignedLong.unsignedToString(this.value);
    }

    public static String toHexString(UnsignedLong u) {
        return Long.toHexString(u.value);
    }

    public static String toOctalString(UnsignedLong u) {
        return Long.toOctalString(u.value);
    }

    public static String toBinaryString(UnsignedLong u) {
        return Long.toBinaryString(u.value);
    }

    public static UnsignedLong valueOf(String s) throws NumberFormatException {
        return UnsignedLong.valueOf(s, 10);
    }

    public static UnsignedLong valueOf(String s, int radix) throws NumberFormatException {
        return UnsignedLong.make(UnsignedLong.parseUnsignedLong(s, radix));
    }

    public static UnsignedLong decode(String s) throws NumberFormatException {
        int radix;
        if (s.startsWith("#")) {
            radix = 16;
            s = s.substring(1);
        } else if (s.startsWith("0x")) {
            radix = 16;
            s = s.substring(2);
        } else if (s.startsWith("0") && s.length() > 1) {
            radix = 8;
            s = s.substring(1);
        } else {
            radix = 10;
        }
        return UnsignedLong.valueOf(s, radix);
    }

    public UnsignedLong add(UnsignedLong x) {
        return this.makeIfDifferent(this.value + x.value);
    }

    public UnsignedLong subtract(UnsignedLong x) {
        return this.makeIfDifferent(this.value - x.value);
    }

    public UnsignedLong multiply(UnsignedLong x) {
        return this.makeIfDifferent(this.value * x.value);
    }

    public UnsignedLong divide(UnsignedLong x) throws ArithmeticException {
        return this.makeIfDifferent(UnsignedLong.unsignedDivide(this.value, x.value));
    }

    public UnsignedLong mod(UnsignedLong x) throws ArithmeticException {
        return this.makeIfDifferent(UnsignedLong.unsignedMod(this.value, x.value));
    }

    public UnsignedLong shiftLeft(int n) {
        if (n < 0) {
            return this.shiftRight(-n);
        }
        if (n >= 64) {
            return ZERO;
        }
        return this.makeIfDifferent(this.value << n);
    }

    public UnsignedLong shiftRight(int n) {
        if (n < 0) {
            return this.shiftLeft(-n);
        }
        if (n >= 64) {
            return ZERO;
        }
        return this.makeIfDifferent(this.value >>> n);
    }

    public UnsignedLong and(UnsignedLong x) {
        return this.makeIfDifferent(this.value & x.value);
    }

    public UnsignedLong or(UnsignedLong x) {
        return this.makeIfDifferent(this.value | x.value);
    }

    public UnsignedLong xor(UnsignedLong x) {
        return this.makeIfDifferent(this.value ^ x.value);
    }

    public UnsignedLong not() {
        return UnsignedLong.make(this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public boolean testBit(int n) {
        if (n < 0 || n >= 64) {
            return false;
        }
        return (this.value & 1L << n) != 0L;
    }

    public UnsignedLong setBit(int n) {
        if (n < 0 || n >= 64) {
            return this;
        }
        return this.makeIfDifferent(this.value | (long)(1 << n));
    }

    public UnsignedLong clearBit(int n) {
        if (n < 0 || n >= 64) {
            return this;
        }
        return this.makeIfDifferent(this.value & (long)(~(1 << n)));
    }

    public UnsignedLong min(UnsignedLong x) {
        if (UnsignedLong.unsignedCompare(this.value, x.value) < 0) {
            return this;
        }
        return x;
    }

    public UnsignedLong max(UnsignedLong x) {
        if (UnsignedLong.unsignedCompare(this.value, x.value) > 0) {
            return this;
        }
        return x;
    }

    static int unsignedCompare(long x, long y) {
        if (x == y) {
            return 0;
        }
        if (x + Long.MIN_VALUE < y + Long.MIN_VALUE) {
            return -1;
        }
        return 1;
    }

    static long unsignedMultiply(long x, long y) {
        return x * y;
    }

    static long unsignedDivide(long x, long y) throws ArithmeticException {
        if (x >= 0L) {
            if (y >= 0L) {
                return x / y;
            }
            return 0L;
        }
        if (y < 0L) {
            if (x < y) {
                return 0L;
            }
            return 1L;
        }
        if ((y & 1L) == 0L) {
            long X_div_2 = x >>> 1;
            long y_div_2 = y >>> 1;
            return X_div_2 / y_div_2;
        }
        if (y == 1L) {
            return x;
        }
        long m = x & Long.MAX_VALUE;
        long m_div_y = m / y;
        long m_mod_y = m % y;
        long K_div_y = Long.MAX_VALUE / y;
        long K_mod_y = Long.MAX_VALUE % y + 1L;
        long z = K_div_y + m_div_y;
        if (K_mod_y + m_mod_y >= y) {
            ++z;
        }
        return z;
    }

    static long unsignedMod(long x, long y) {
        return x - y * UnsignedLong.unsignedDivide(x, y);
    }

    static String unsignedToString(long x) {
        if (x >= 0L) {
            return Long.toString(x);
        }
        long xmod2 = x & 1L;
        long xdiv2 = x >>> 1;
        long xmod10 = xdiv2 % 5L * 2L + xmod2;
        long xdiv10 = xdiv2 / 5L;
        return Long.toString(xdiv10) + Long.toString(xmod10);
    }

    static long parseUnsignedLong(String s, int radix) throws NumberFormatException {
        if (s.startsWith("-")) {
            throw new NumberFormatException("negative unsigned");
        }
        try {
            return Long.parseLong(s, radix);
        }
        catch (NumberFormatException e) {
            int len = s.length();
            long left = Long.parseLong(s.substring(0, len - 1), radix);
            if (left > UnsignedLong.unsignedDivide(-1L, radix)) {
                throw new NumberFormatException("unrepresentable unsigned");
            }
            long leftShifted = left * (long)radix;
            long right = Long.parseLong(s.substring(len - 1), radix);
            long u = leftShifted + right;
            if (u >= 0L) {
                throw new NumberFormatException("unrepresentable unsigned");
            }
            return u;
        }
    }
}

