/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.jsf.framework.model;

import com.sun.jbi.jsf.framework.common.XmlUtils;
import com.sun.jbi.jsf.framework.model.JBIEndpoint;
import org.w3c.dom.Element;

public class JBIConnection {
    private JBIEndpoint consumer;
    private JBIEndpoint provider;

    public JBIConnection(JBIEndpoint consumer, JBIEndpoint provider) {
        this.consumer = consumer;
        this.provider = provider;
    }

    public JBIEndpoint getConsumer() {
        return this.consumer;
    }

    public JBIEndpoint getProvider() {
        return this.provider;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        if (this.consumer != null) {
            str.append("Consumer: " + this.consumer.toString());
        }
        if (this.provider != null) {
            str.append("\nProvider: " + this.provider.toString());
        }
        return str.toString();
    }

    public static JBIConnection create(JBIEndpoint consumer, JBIEndpoint provider) {
        return new JBIConnection(consumer, provider);
    }

    public static JBIConnection create(Element element) {
        Element consumer = XmlUtils.getChildElement(element, "consumer");
        JBIEndpoint consumerEndpoint = JBIEndpoint.create(consumer);
        Element provider = XmlUtils.getChildElement(element, "provider");
        JBIEndpoint providerEndpoint = JBIEndpoint.create(provider);
        return JBIConnection.create(consumerEndpoint, providerEndpoint);
    }
}

