/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import com.sun.org.apache.commons.modeler.BaseModelMBean;
import com.sun.org.apache.commons.modeler.ManagedBean;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import org.apache.catalina.Group;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.mbeans.MBeanUtils;

public class MemoryUserDatabaseMBean
extends BaseModelMBean {
    protected MBeanServer mserver = MBeanUtils.createServer();
    protected ManagedBean managed;
    protected ManagedBean managedGroup;
    protected ManagedBean managedRole;
    protected ManagedBean managedUser;

    public MemoryUserDatabaseMBean() throws MBeanException, RuntimeOperationsException {
        this.registry = MBeanUtils.createRegistry();
        this.managed = this.registry.findManagedBean("MemoryUserDatabase");
        this.managedGroup = this.registry.findManagedBean("Group");
        this.managedRole = this.registry.findManagedBean("Role");
        this.managedUser = this.registry.findManagedBean("User");
    }

    public String[] getGroups() {
        UserDatabase database = (UserDatabase)this.resource;
        ArrayList<String> results = new ArrayList<String>();
        Iterator groups = database.getGroups();
        while (groups.hasNext()) {
            Group group = (Group)groups.next();
            results.add(this.findGroup(group.getGroupname()));
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] getRoles() {
        UserDatabase database = (UserDatabase)this.resource;
        ArrayList<String> results = new ArrayList<String>();
        Iterator roles = database.getRoles();
        while (roles.hasNext()) {
            Role role = (Role)roles.next();
            results.add(this.findRole(role.getRolename()));
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] getUsers() {
        UserDatabase database = (UserDatabase)this.resource;
        ArrayList<String> results = new ArrayList<String>();
        Iterator users = database.getUsers();
        while (users.hasNext()) {
            User user = (User)users.next();
            results.add(this.findUser(user.getUsername()));
        }
        return results.toArray(new String[results.size()]);
    }

    public String createGroup(String groupname, String description) {
        UserDatabase database = (UserDatabase)this.resource;
        Group group = database.createGroup(groupname, description);
        try {
            MBeanUtils.createMBean(group);
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException("Exception creating group " + group + " MBean");
            iae.initCause(e);
            throw iae;
        }
        return this.findGroup(groupname);
    }

    public String createRole(String rolename, String description) {
        UserDatabase database = (UserDatabase)this.resource;
        Role role = database.createRole(rolename, description);
        try {
            MBeanUtils.createMBean(role);
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException("Exception creating role " + role + " MBean");
            iae.initCause(e);
            throw iae;
        }
        return this.findRole(rolename);
    }

    public String createUser(String username, String password, String fullName) {
        UserDatabase database = (UserDatabase)this.resource;
        User user = database.createUser(username, password, fullName);
        try {
            MBeanUtils.createMBean(user);
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException("Exception creating user " + user + " MBean");
            iae.initCause(e);
            throw iae;
        }
        return this.findUser(username);
    }

    public String findGroup(String groupname) {
        UserDatabase database = (UserDatabase)this.resource;
        Group group = database.findGroup(groupname);
        if (group == null) {
            return null;
        }
        try {
            ObjectName oname = MBeanUtils.createObjectName(this.managedGroup.getDomain(), group);
            return oname.toString();
        }
        catch (MalformedObjectNameException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Cannot create object name for group " + group);
            iae.initCause(e);
            throw iae;
        }
    }

    public String findRole(String rolename) {
        UserDatabase database = (UserDatabase)this.resource;
        Role role = database.findRole(rolename);
        if (role == null) {
            return null;
        }
        try {
            ObjectName oname = MBeanUtils.createObjectName(this.managedRole.getDomain(), role);
            return oname.toString();
        }
        catch (MalformedObjectNameException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Cannot create object name for role " + role);
            iae.initCause(e);
            throw iae;
        }
    }

    public String findUser(String username) {
        UserDatabase database = (UserDatabase)this.resource;
        User user = database.findUser(username);
        if (user == null) {
            return null;
        }
        try {
            ObjectName oname = MBeanUtils.createObjectName(this.managedUser.getDomain(), user);
            return oname.toString();
        }
        catch (MalformedObjectNameException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Cannot create object name for user " + user);
            iae.initCause(e);
            throw iae;
        }
    }

    public void removeGroup(String groupname) {
        UserDatabase database = (UserDatabase)this.resource;
        Group group = database.findGroup(groupname);
        if (group == null) {
            return;
        }
        try {
            MBeanUtils.destroyMBean(group);
            database.removeGroup(group);
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException("Exception destroying group " + group + " MBean");
            iae.initCause(e);
            throw iae;
        }
    }

    public void removeRole(String rolename) {
        UserDatabase database = (UserDatabase)this.resource;
        Role role = database.findRole(rolename);
        if (role == null) {
            return;
        }
        try {
            MBeanUtils.destroyMBean(role);
            database.removeRole(role);
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException("Exception destroying role " + role + " MBean");
            iae.initCause(e);
            throw iae;
        }
    }

    public void removeUser(String username) {
        UserDatabase database = (UserDatabase)this.resource;
        User user = database.findUser(username);
        if (user == null) {
            return;
        }
        try {
            MBeanUtils.destroyMBean(user);
            database.removeUser(user);
        }
        catch (Exception e) {
            IllegalArgumentException iae = new IllegalArgumentException("Exception destroying user " + user + " MBean");
            iae.initCause(e);
            throw iae;
        }
    }
}

