/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.wsclient;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.tools.verifier.CheckMgr;
import com.sun.enterprise.tools.verifier.FrameworkContext;
import com.sun.enterprise.tools.verifier.JarCheck;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import javax.enterprise.deploy.shared.ModuleType;

public class WebServiceClientCheckMgrImpl
extends CheckMgr
implements JarCheck {
    private static final String testsListFileName = "TestNamesWebServicesClient.xml";
    private static final String sunONETestsListFileName = WebServiceClientCheckMgrImpl.getSunPrefix().concat("TestNamesWebServicesClient.xml");
    private String moduleName;

    public WebServiceClientCheckMgrImpl(FrameworkContext frameworkContext) {
        this.frameworkContext = frameworkContext;
    }

    public void check(Descriptor descriptor) throws Exception {
        ServiceReferenceDescriptor rootDescriptor = (ServiceReferenceDescriptor)descriptor;
        ModuleType moduleType = rootDescriptor.getBundleDescriptor().getModuleType();
        if (moduleType == ModuleType.EJB) {
            this.moduleName = "ejb";
        } else if (moduleType == ModuleType.WAR) {
            this.moduleName = "web";
        } else if (moduleType == ModuleType.CAR) {
            this.moduleName = "appclient";
        }
        super.check(rootDescriptor);
    }

    protected String getTestsListFileName() {
        return testsListFileName;
    }

    protected String getSunONETestsListFileName() {
        return sunONETestsListFileName;
    }

    protected String getSchemaVersion(Descriptor descriptor) {
        String wsclientVersion = null;
        String version = ((ServiceReferenceDescriptor)descriptor).getBundleDescriptor().getSpecVersion();
        if (this.moduleName.equals("ejb")) {
            if ("2.1".equals(version)) {
                wsclientVersion = "1.1";
            } else if ("3.0".equals(version)) {
                wsclientVersion = "1.2";
            }
        } else if (this.moduleName.equals("web")) {
            if ("2.4".equals(version)) {
                wsclientVersion = "1.1";
            } else if ("2.5".equals(version)) {
                wsclientVersion = "1.2";
            }
        } else if (this.moduleName.equals("appclient")) {
            if ("1.4".equals(version)) {
                wsclientVersion = "1.1";
            } else if ("5".equals(version)) {
                wsclientVersion = "1.2";
            }
        }
        if (wsclientVersion == null) {
            wsclientVersion = "";
        }
        return wsclientVersion;
    }

    protected void setModuleName(Result r) {
        r.setModuleName(this.moduleName);
    }

    protected BundleDescriptor getBundleDescriptor(Descriptor descriptor) {
        return ((ServiceReferenceDescriptor)descriptor).getBundleDescriptor();
    }

    protected ComponentNameConstructor getComponentNameConstructor(Descriptor descriptor) {
        return new ComponentNameConstructor((ServiceReferenceDescriptor)descriptor);
    }
}

