/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web.runtime;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.runtime.web.WebProperty;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;

public class ASWebProperty
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        boolean oneFailed = false;
        boolean notApp = false;
        try {
            WebProperty[] webProps = descriptor.getSunDescriptor().getWebProperty();
            if (webProps.length > 0) {
                oneFailed = ASWebProperty.checkWebProperties(webProps, result, descriptor, this);
            } else {
                notApp = true;
                this.addNaDetails(result, compName);
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-WEB sun-web-app] web property element not defined within the web archive [ {0} ].", new Object[]{descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (notApp) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
        }
        catch (Exception ex) {
            oneFailed = true;
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-WEB sun-web-app] could not create the web-property object"));
        }
        return result;
    }

    public static boolean checkWebProperties(WebProperty[] webProps, Result result, WebBundleDescriptor descriptor, Object obj) {
        String compName = result.getComponentName();
        boolean oneFailed = false;
        String[] names = null;
        if (webProps.length > 0) {
            names = new String[webProps.length];
            for (int rep = 0; rep < webProps.length; ++rep) {
                String name = webProps[rep].getAttributeValue("name");
                String value = webProps[rep].getAttributeValue("value");
                names[rep] = name;
                if (name != null && value != null && name.length() != 0 && value.length() != 0) {
                    boolean isDuplicate = false;
                    for (int rep1 = 0; rep1 < rep; ++rep1) {
                        if (!name.equals(names[rep1])) continue;
                        isDuplicate = true;
                        break;
                    }
                    if (!isDuplicate) {
                        result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName}));
                        result.passed(smh.getLocalString(obj.getClass().getName() + ".passed", "PASSED [AS-WEB property] Proper web property with name  [ {0} ] and value [ {1} ] defined.", new Object[]{name, value}));
                        continue;
                    }
                    if (!oneFailed) {
                        oneFailed = true;
                    }
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName}));
                    result.failed(smh.getLocalString(obj.getClass().getName() + ".failed2", "FAILED [AS-WEB property] name [ {0} ] and value [ {1} ], the name must be unique in the entire list of web property.", new Object[]{name, value}));
                    continue;
                }
                if (!oneFailed) {
                    oneFailed = true;
                }
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName}));
                result.failed(smh.getLocalString(obj.getClass().getName() + ".failed1", "FAILED [AS-WEB property] name [ {0} ] and value [ {1} ], attributes must be of finite length.", new Object[]{name, value}));
            }
        }
        return oneFailed;
    }
}

