/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.common.util.zip;

import com.sun.enterprise.tools.common.util.Assertion;
import com.sun.enterprise.tools.common.util.ContainerHelper;
import com.sun.enterprise.tools.common.util.diagnostics.Reporter;
import com.sun.enterprise.tools.common.util.zip.ZipFileException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipFile {
    private String zipFilename = null;
    private String explodeDirName = null;
    private File zipFile = null;
    private File explodeDir = null;
    private ArrayList files = null;
    private static final String specialDir = "META-INF/";
    private byte[] buffer = new byte[16384];
    private ZipInputStream zipStream = null;

    public ZipFile(String zipFilename, String explodeDirName) throws ZipFileException {
        ZipFile.assertIt(zipFilename);
        ZipFile.assertIt(explodeDirName);
        this.zipFilename = zipFilename;
        this.explodeDirName = explodeDirName;
        try {
            this.checkZipFile();
            this.zipStream = new ZipInputStream(new FileInputStream(this.zipFile));
            this.checkExplodeDir();
        }
        catch (Exception f) {
            throw new ZipFileException(f);
        }
    }

    public ZipFile(InputStream inStream, String explodeDirName) throws ZipFileException {
        ZipFile.assertIt(explodeDirName);
        this.explodeDirName = explodeDirName;
        try {
            this.zipStream = new ZipInputStream(inStream);
            this.checkExplodeDir();
        }
        catch (Assertion.Failure f) {
            throw new ZipFileException(f);
        }
    }

    public String toString() {
        String s = "Zip File Name: " + this.zipFilename + "\n";
        return s;
    }

    public String[] explode() throws ZipFileException {
        ArrayList<String> explodedFiles = new ArrayList<String>();
        ZipInputStream zin = null;
        try {
            ZipEntry ze;
            zin = this.zipStream;
            while ((ze = zin.getNextEntry()) != null) {
                FileOutputStream os;
                String filename = ze.getName();
                if (this.isManifest(filename)) continue;
                File fullpath = new File(this.explodeDir, filename);
                File newDir = fullpath.getParentFile();
                if (newDir.mkdirs()) {
                    Reporter.verbose("Created new directory:  " + newDir);
                }
                if (fullpath.delete()) {
                    Reporter.info("deleted pre-existing file: " + fullpath);
                }
                if ((os = this.getOutputStream(filename)) == null) continue;
                int totalBytes = 0;
                int numBytes = zin.read(this.buffer);
                while (numBytes > 0) {
                    os.write(this.buffer, 0, numBytes);
                    totalBytes += numBytes;
                    numBytes = zin.read(this.buffer);
                }
                os.close();
                Reporter.verbose("Wrote " + totalBytes + " to " + filename);
                explodedFiles.add(filename);
            }
        }
        catch (IOException e) {
            throw new ZipFileException(e);
        }
        finally {
            Reporter.verbose("Closing zin...");
            try {
                zin.close();
            }
            catch (IOException e) {
                throw new ZipFileException("Got an exception while trying to close Jar input stream: " + e);
            }
        }
        Reporter.info("Successfully Exploded " + this.zipFilename + " to " + this.explodeDirName);
        return ContainerHelper.toStringArray(explodedFiles);
    }

    private void createFileNameList() throws ZipFileException {
        ZipFile.assertIt(this.files == null, "createFileNameList() called a second time.  Should only be called once and only once!");
        this.files = new ArrayList();
        ZipInputStream zin = null;
        try {
            ZipEntry ze;
            zin = this.zipStream;
            while ((ze = zin.getNextEntry()) != null) {
                String name = ze.getName();
                zin.closeEntry();
                this.files.add(name);
            }
            zin.close();
        }
        catch (IOException e) {
            Reporter.error(e + "  " + this.zipFile);
            throw new ZipFileException(e);
        }
    }

    private void checkZipFile() throws ZipFileException {
        ZipFile.assertIt(this.zipFilename);
        this.zipFile = new File(this.zipFilename);
        ZipFile.assertIt(this.zipFile.exists(), "zipFile (" + this.zipFilename + ") doesn't exist");
        ZipFile.assertIt(!this.zipFile.isDirectory(), "zipFile (" + this.zipFilename + ") is actually a directory!");
    }

    private void checkExplodeDir() throws ZipFileException {
        ZipFile.assertIt(this.explodeDirName);
        this.explodeDir = new File(this.explodeDirName);
        ZipFile.assertIt(this.explodeDir.exists(), "Target Directory doesn't exist: " + this.explodeDirName);
        ZipFile.assertIt(this.explodeDir.isDirectory(), "Target Directory isn't a directory: " + this.explodeDirName);
        ZipFile.assertIt(this.explodeDir.canWrite(), "Can't write to Target Directory: " + this.explodeDirName);
    }

    private static boolean isSpecial(String filename) {
        return filename.toUpperCase().startsWith(specialDir.toUpperCase());
    }

    private void createDirs() throws ZipFileException {
        Assertion.check(this.explodeDir, "Programmer Error -- need to setup explodeDir");
        for (String fname : this.files) {
            File fullpath = new File(this.explodeDir, fname);
            File newDir = fullpath.getParentFile();
            if (newDir.mkdirs()) {
                Reporter.verbose("Created new directory:  " + newDir);
            }
            if (fullpath.delete()) {
                Reporter.info("deleted pre-existing file: " + fullpath);
            }
            ZipFile.assertIt(newDir.exists() && newDir.isDirectory(), "Couldn't create directory: " + newDir);
        }
    }

    private FileOutputStream getOutputStream(String filename) throws ZipFileException {
        Assertion.check(this.explodeDir, "Programmer Error -- need to setup explodeDir");
        File f = new File(this.explodeDir, filename);
        if (f.isDirectory()) {
            Reporter.warn("Weird!  A directory is listed as an entry in the jar file -- skipping...");
            return null;
        }
        try {
            return new FileOutputStream(f);
        }
        catch (FileNotFoundException e) {
            throw new ZipFileException(e);
        }
        catch (IOException e) {
            throw new ZipFileException(e);
        }
    }

    private boolean isManifest(String filename) {
        if (filename.toLowerCase().endsWith("manifest.mf")) {
            return false;
        }
        return false;
    }

    private static void pr(String s) {
        System.out.println(s);
    }

    private static void assertIt(String s) throws ZipFileException {
        if (s == null || s.length() < 0) {
            throw new ZipFileException();
        }
    }

    private static void assertIt(String s, String mesg) throws ZipFileException {
        if (s == null || s.length() < 0) {
            throw new ZipFileException(mesg);
        }
    }

    private static void assertIt(boolean b) throws ZipFileException {
        if (!b) {
            throw new ZipFileException();
        }
    }

    private static void assertIt(boolean b, String mesg) throws ZipFileException {
        if (!b) {
            throw new ZipFileException(mesg);
        }
    }

    public static void main(String[] String_1darray1) {
        try {
            ZipFile zip = new ZipFile("D:\\test\\AccessorTestEnterpriseBean.jar", "D:/test/zipOut");
            ZipFile.pr("" + zip);
            zip.explode();
        }
        catch (ZipFileException e) {
            ZipFile.pr("ZipFileException: " + e);
        }
    }
}

