/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server.ss.provider;

import com.sun.enterprise.server.ss.provider.ASSelector;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

final class ASInputStream
extends InputStream {
    private static final Logger logger = LogDomains.getLogger("javax.enterprise.system.core");
    private SocketChannel sc = null;
    private Socket sock = null;
    private boolean closed = false;
    private Selector selector = null;
    private ByteBuffer bb = null;
    private byte[] bs = null;
    private byte[] b1 = null;

    ASInputStream(SocketChannel sc, Socket sock) throws IOException {
        this.sc = sc;
        this.sock = sock;
        this.selector = Selector.open();
        this.sc.register(this.selector, 1);
    }

    public synchronized int read() throws IOException {
        int n;
        if (this.b1 == null) {
            this.b1 = new byte[1];
        }
        if ((n = this.read(this.b1)) == 1) {
            return this.b1[0] & 0xFF;
        }
        return -1;
    }

    public synchronized int read(byte[] bs, int off, int len) throws IOException {
        if (off < 0 || off > bs.length || len < 0 || off + len > bs.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        ByteBuffer bb = this.bs == bs ? this.bb : ByteBuffer.wrap(bs);
        bb.position(off);
        bb.limit(Math.min(off + len, bb.capacity()));
        this.bb = bb;
        this.bs = bs;
        return this.read(bb);
    }

    private int read(ByteBuffer bb) throws IOException {
        this.checkClosed();
        this.waitForSelect();
        return this.sc.read(bb);
    }

    private void waitForSelect() throws IOException {
        block7: {
            boolean wakenup;
            boolean timedout;
            Socket sock = this.sc.socket();
            if (sock.isClosed()) {
                this.close();
                throw new IOException("Socket Closed");
            }
            int timeout = sock.getSoTimeout();
            do {
                timedout = true;
                try {
                    int n = this.selector.select(timeout);
                    if (sock.isInputShutdown() || sock.isClosed()) {
                        throw new IOException("Input Shutdown");
                    }
                    if (n > 0) {
                        timedout = false;
                    }
                    Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
                    while (it.hasNext()) {
                        timedout = false;
                        SelectionKey selKey = it.next();
                        if (!selKey.isValid() || !selKey.isReadable()) continue;
                        it.remove();
                        break block7;
                    }
                }
                catch (Exception e) {
                    throw (IOException)new IOException().initCause(e);
                }
            } while (!timedout || (wakenup = ((ASSelector)this.selector).wakenUp()) || Thread.currentThread().isInterrupted());
            throw new SocketTimeoutException("Read timed out");
        }
    }

    public void close() throws IOException {
        block3: {
            if (this.closed) {
                return;
            }
            this.closed = true;
            try {
                this.selector.close();
                this.selector = null;
                this.sc = null;
            }
            catch (Exception ie) {
                if (!logger.isLoggable(Level.FINE)) break block3;
                logger.log(Level.FINE, "" + ie.getMessage(), ie);
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (this.sock.isInputShutdown()) {
            throw new IOException("Input Shutdown");
        }
    }
}

