/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.enterprise.server.MonitorListener;
import java.io.File;

final class MonitorableEntry {
    private String id;
    private String displayName;
    private File monitoredFile;
    private long lastReloadedAt;
    private MonitorListener listener;

    MonitorableEntry(String id, String displayName, File monitoredFile, MonitorListener listener) {
        this.id = id;
        this.displayName = displayName;
        this.monitoredFile = monitoredFile;
        this.lastReloadedAt = monitoredFile.lastModified();
        this.listener = listener;
    }

    MonitorableEntry(String id, File monitoredFile, MonitorListener listener) {
        this(id, id, monitoredFile, listener);
    }

    MonitorableEntry(File monitoredFile, MonitorListener listener) {
        this("AutoDeployDirectory", monitoredFile, listener);
    }

    String getId() {
        return this.id;
    }

    String getDisplayName() {
        return this.displayName;
    }

    long getLastReloadedTimeStamp() {
        return this.lastReloadedAt;
    }

    MonitorListener getListener() {
        return this.listener;
    }

    File getMonitoredFile() {
        return this.monitoredFile;
    }

    void setLastReloadedTimeStamp(long ts) {
        this.lastReloadedAt = ts;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object other) {
        return this.monitoredFile.equals(((MonitorableEntry)other).monitoredFile);
    }
}

