/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm;

import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.AuthRealmEvent;
import com.sun.enterprise.admin.event.AuthRealmEventListener;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.server.pluggable.SecuritySupport;
import java.util.Properties;

public class AuthRealmEventListenerImpl
implements AuthRealmEventListener {
    public void authRealmCreated(AuthRealmEvent event) throws AdminEventListenerException {
        try {
            this.createRealm(event);
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }

    public void authRealmDeleted(AuthRealmEvent event) throws AdminEventListenerException {
        try {
            Realm.unloadInstance(event.getAuthRealmName());
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }

    public void authRealmUpdated(AuthRealmEvent event) throws AdminEventListenerException {
        try {
            this.createRealm(event);
        }
        catch (Exception ex) {
            throw new AdminEventListenerException(ex);
        }
    }

    private void createRealm(AuthRealmEvent event) throws Exception {
        ConfigContext configContext = event.getConfigContext();
        String realmName = event.getAuthRealmName();
        SecurityService security = ServerBeansFactory.getSecurityServiceBean(configContext);
        AuthRealm authRealm = security.getAuthRealmByName(realmName);
        String className = authRealm.getClassname();
        ElementProperty[] elementProps = authRealm.getElementProperty();
        int size = elementProps != null ? elementProps.length : 0;
        Properties props = new Properties();
        for (int i = 0; i < size; ++i) {
            props.setProperty(elementProps[i].getName(), elementProps[i].getValue());
        }
        if ("com.sun.enterprise.security.auth.realm.file.FileRealm".equals(className)) {
            SecuritySupport secSupp = SecurityUtil.getSecuritySupport();
            secSupp.synchronizeKeyFile(configContext, realmName);
        }
        Realm.instantiate(realmName, className, props);
    }
}

