/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.util;

import com.sun.enterprise.admin.server.core.mbean.config.ManagedJ2EEApplication;
import com.sun.enterprise.admin.server.core.mbean.config.ManagedStandaloneConnectorModule;
import com.sun.enterprise.admin.server.core.mbean.config.ManagedStandaloneJ2EEEjbJarModule;
import com.sun.enterprise.admin.server.core.mbean.config.ManagedStandaloneJ2EEWebModule;
import com.sun.enterprise.management.model.J2EEDeployedObjectMdl;
import javax.management.MBeanException;
import javax.management.ObjectName;

public class StartStopCallback {
    private static boolean debug = false;

    public void startModule(J2EEDeployedObjectMdl modObject) throws MBeanException {
        if (debug) {
            return;
        }
        String moduleID = modObject.getname();
        String j2eeType = modObject.getj2eeType();
        String serverName = modObject.getJ2EEServer();
        if (!j2eeType.equals("J2EEApplication") && !this.standAlone(modObject)) {
            throw new MBeanException(new Exception("cannot start individual module, start the application itself"));
        }
        if (j2eeType.equals("EJBModule")) {
            this.startEJBModule(moduleID, serverName);
        } else if (j2eeType.equals("WebModule")) {
            this.startWEBModule(moduleID, serverName);
        } else if (j2eeType.equals("ResourceAdapterModule")) {
            this.startRARModule(moduleID, serverName);
        } else {
            if (j2eeType.equals("AppClientModule")) {
                return;
            }
            if (j2eeType.equals("J2EEApplication")) {
                this.startApplication(moduleID, serverName);
            }
        }
    }

    public void stopModule(J2EEDeployedObjectMdl modObject) throws MBeanException {
        if (debug) {
            return;
        }
        String moduleID = modObject.getname();
        String j2eeType = modObject.getj2eeType();
        String serverName = modObject.getJ2EEServer();
        if (!j2eeType.equals("J2EEApplication") && !this.standAlone(modObject)) {
            throw new MBeanException(new Exception("cannot stop individual module, stop the application itself"));
        }
        if (j2eeType.equals("EJBModule")) {
            this.stopEJBModule(moduleID, serverName);
        } else if (j2eeType.equals("WebModule")) {
            this.stopWEBModule(moduleID, serverName);
        } else if (j2eeType.equals("ResourceAdapterModule")) {
            this.stopRARModule(moduleID, serverName);
        } else {
            if (j2eeType.equals("AppClientModule")) {
                return;
            }
            if (j2eeType.equals("J2EEApplication")) {
                this.stopApplication(moduleID, serverName);
            }
        }
    }

    private void startEJBModule(String moduleID, String serverName) throws MBeanException {
        try {
            ManagedStandaloneJ2EEEjbJarModule msejbModule = new ManagedStandaloneJ2EEEjbJarModule(serverName, moduleID);
            msejbModule.start();
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    private void stopEJBModule(String moduleID, String serverName) throws MBeanException {
        try {
            ManagedStandaloneJ2EEEjbJarModule msejbModule = new ManagedStandaloneJ2EEEjbJarModule(serverName, moduleID);
            msejbModule.stop();
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    private void startWEBModule(String moduleID, String serverName) throws MBeanException {
        try {
            ManagedStandaloneJ2EEWebModule mswebModule = new ManagedStandaloneJ2EEWebModule(serverName, moduleID);
            mswebModule.start();
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    private void stopWEBModule(String moduleID, String serverName) throws MBeanException {
        try {
            ManagedStandaloneJ2EEWebModule mswebModule = new ManagedStandaloneJ2EEWebModule(serverName, moduleID);
            mswebModule.stop();
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    private void startRARModule(String moduleID, String serverName) throws MBeanException {
        try {
            ManagedStandaloneConnectorModule mscModule = new ManagedStandaloneConnectorModule(serverName, moduleID);
            mscModule.start();
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    private void stopRARModule(String moduleID, String serverName) throws MBeanException {
        try {
            ManagedStandaloneConnectorModule mscModule = new ManagedStandaloneConnectorModule(serverName, moduleID);
            mscModule.stop();
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    private void startApplication(String appID, String serverName) throws MBeanException {
        try {
            ManagedJ2EEApplication mApp = new ManagedJ2EEApplication(serverName, appID);
            mApp.start();
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    private void stopApplication(String appID, String serverName) throws MBeanException {
        try {
            ManagedJ2EEApplication mApp = new ManagedJ2EEApplication(serverName, appID);
            mApp.stop();
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    private boolean standAlone(J2EEDeployedObjectMdl modObject) throws MBeanException {
        try {
            ObjectName objName = new ObjectName(modObject.getobjectName());
            String appName = objName.getKeyProperty("J2EEApplication");
            if (appName == null || appName.length() < 1 || appName.equals("null") || appName.equals("NULL") || appName.equals("")) {
                return true;
            }
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
        return false;
    }
}

