/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop;

import com.sun.corba.ee.spi.monitoring.MonitoredObject;
import com.sun.enterprise.admin.monitor.stats.BoundedRangeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableBoundedRangeStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.OrbConnectionManagerStats;
import com.sun.enterprise.iiop.ORBCommonStatsImpl;
import javax.management.j2ee.statistics.BoundedRangeStatistic;
import javax.management.j2ee.statistics.CountStatistic;

public class OrbConnectionManagerStatsImpl
extends ORBCommonStatsImpl
implements OrbConnectionManagerStats {
    private MonitoredObject connection;
    private String connectionName;
    private static String stringTotalConnections = "NumberOfConnections";
    private static String stringIdleConnections = "NumberOfIdleConnections";
    private static String stringBusyConnections = "NumberOfBusyConnections";
    private MutableBoundedRangeStatisticImpl totalConnections;
    private MutableCountStatisticImpl idleConnections;
    private MutableCountStatisticImpl busyConnections;

    public OrbConnectionManagerStatsImpl(MonitoredObject connectionNode) {
        this.connection = connectionNode;
        this.connectionName = this.connection.getName();
        this.initializeStats();
    }

    private void initializeStats() {
        super.initialize("com.sun.enterprise.admin.monitor.stats.OrbConnectionManagerStats");
        long time = System.currentTimeMillis();
        this.totalConnections = new MutableBoundedRangeStatisticImpl((BoundedRangeStatistic)new BoundedRangeStatisticImpl(0L, 0L, 0L, Long.MAX_VALUE, 0L, "TotalConnections", "count", this.connection.getAttribute(stringTotalConnections).getAttributeInfo().getDescription(), time, time));
        this.idleConnections = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("ConnectionsIdle", "count", this.connection.getAttribute(stringIdleConnections).getAttributeInfo().getDescription()));
        this.busyConnections = new MutableCountStatisticImpl((CountStatistic)new CountStatisticImpl("ConnectionsInUse", "count", this.connection.getAttribute(stringBusyConnections).getAttributeInfo().getDescription()));
    }

    public BoundedRangeStatistic getTotalConnections() {
        long totalNumberOfConnections = (Long)this.connection.getAttribute(stringTotalConnections).getValue();
        this.totalConnections.setCount(totalNumberOfConnections);
        return (BoundedRangeStatistic)this.totalConnections.modifiableView();
    }

    public CountStatistic getConnectionsIdle() {
        long numberIdleConnections = (Long)this.connection.getAttribute(stringIdleConnections).getValue();
        this.idleConnections.setCount(numberIdleConnections);
        return (CountStatistic)this.idleConnections.modifiableView();
    }

    public CountStatistic getConnectionsInUse() {
        long numberBusyConnections = (Long)this.connection.getAttribute(stringBusyConnections).getValue();
        this.busyConnections.setCount(numberBusyConnections);
        return (CountStatistic)this.busyConnections.modifiableView();
    }
}

