/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.collect;

import com.sun.enterprise.diagnostics.Constants;
import com.sun.enterprise.diagnostics.Data;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.ServiceConfig;
import com.sun.enterprise.diagnostics.collect.Collector;
import com.sun.enterprise.diagnostics.collect.FileData;
import com.sun.enterprise.diagnostics.collect.WritableDataImpl;
import com.sun.enterprise.diagnostics.util.DDFilter;
import com.sun.enterprise.diagnostics.util.FileUtils;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AppInfoCollector
implements Collector {
    private String destFolder;
    private String repositoryFolder;
    private ServiceConfig config;
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.admin");

    public AppInfoCollector(String repositoryFolder, String destFolder) {
        this.destFolder = destFolder;
        this.repositoryFolder = repositoryFolder;
        this.config = this.config;
    }

    public Data capture() throws DiagnosticException {
        WritableDataImpl dataImpl = new WritableDataImpl("app info");
        dataImpl.addChild(this.captureAppRelatedInfo(Constants.GENERATED_DIR));
        dataImpl.addChild(this.captureAppRelatedInfo(Constants.APPLICATIONS_DIR, new DDFilter()));
        return dataImpl;
    }

    private Data captureAppRelatedInfo(String relativePath) throws DiagnosticException {
        try {
            String sourceFolder = this.repositoryFolder + File.separator + relativePath;
            String destFileObj = this.destFolder + File.separator + relativePath;
            FileUtils.copyDir(sourceFolder, destFileObj, true);
            return new FileData(destFileObj, "app info");
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "diagnostic-service.copy_failed", new Object[]{relativePath, ioe.getMessage()});
            return null;
        }
    }

    private Data captureAppRelatedInfo(String relativePath, FilenameFilter filter) throws DiagnosticException {
        WritableDataImpl dataImpl;
        block7: {
            dataImpl = new WritableDataImpl(relativePath);
            String sourceFolderName = this.repositoryFolder + File.separator + relativePath;
            File sourceFolder = new File(sourceFolderName);
            String[] filteredChildren = null;
            String[] children = null;
            if (filter != null) {
                filteredChildren = sourceFolder.list(filter);
            }
            if (filteredChildren == null) break block7;
            if (filteredChildren.length == 0) {
                children = sourceFolder.list();
                for (int i = 0; i < children.length; ++i) {
                    String childName = relativePath + File.separator + children[i];
                    String absoluteChildName = this.repositoryFolder + File.separator + childName;
                    File child = new File(absoluteChildName);
                    if (!child.isDirectory()) continue;
                    dataImpl.addChild(this.captureAppRelatedInfo(childName, filter));
                }
            } else {
                for (int i = 0; i < filteredChildren.length; ++i) {
                    String childName = relativePath + File.separator + filteredChildren[i];
                    String absoluteChildName = this.repositoryFolder + File.separator + childName;
                    File child = new File(absoluteChildName);
                    try {
                        String dest = this.destFolder + File.separator + childName;
                        FileUtils.copyFile(absoluteChildName, dest);
                        dataImpl.addChild(new FileData(dest, "app info"));
                        continue;
                    }
                    catch (IOException ioe) {
                        logger.log(Level.WARNING, "diagnostic-service.copy_failed", new Object[]{absoluteChildName, ioe.getMessage()});
                    }
                }
            }
        }
        return dataImpl;
    }
}

