/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics;

import com.sun.enterprise.diagnostics.CLIOptions;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.ExecutionContext;
import com.sun.enterprise.diagnostics.ReportTarget;
import com.sun.enterprise.diagnostics.ServiceConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportConfig {
    private CLIOptions options;
    private ReportTarget target;
    private ExecutionContext context;
    private List<ServiceConfig> configurations;

    public ReportConfig(CLIOptions cliOptions, ReportTarget target, ExecutionContext context) throws DiagnosticException {
        this.options = cliOptions;
        this.target = target;
        this.context = context;
        this.initialize();
    }

    public void addInstanceSpecificConfig(ServiceConfig config) {
        if (config != null) {
            this.configurations.add(config);
        }
    }

    public void addInstanceConfigs(List<ServiceConfig> configs) {
        if (configs != null) {
            Iterator<ServiceConfig> iterator = configs.iterator();
            while (iterator.hasNext()) {
                this.addInstanceSpecificConfig(iterator.next());
            }
        }
    }

    public ServiceConfig getInstanceConfigByName(String name) {
        ServiceConfig instanceConfig = null;
        for (ServiceConfig config : this.configurations) {
            if (!config.getInstanceName().equalsIgnoreCase(name)) continue;
            instanceConfig = config;
            break;
        }
        return instanceConfig;
    }

    public ReportTarget getTarget() {
        return this.target;
    }

    public CLIOptions getCLIOptions() {
        return this.options;
    }

    public ExecutionContext getExecutionContext() {
        return this.context;
    }

    public Iterator<ServiceConfig> getInstanceConfigurations() {
        return this.configurations.iterator();
    }

    public String toString() {
        return this.options.toString() + this.target.toString() + this.context.toString() + this.configurations;
    }

    private void initialize() {
        this.configurations = new ArrayList<ServiceConfig>();
    }
}

