/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.phasing.DeploymentPhase;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.resource.Resource;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourcePhase
extends DeploymentPhase {
    protected static final String resourcesMBeanName = "com.sun.appserv:type=resources,category=config";
    protected static final String CREATE_RESOURCE = "createResource";
    protected static final String CREATE_RESOURCE_REF = "createResourceReference";
    protected static final String CREATE_RESOURCE_AND_REF = "createResourceAndResourceReference";
    protected static final String DELETE_RESOURCE = "deleteResource";
    protected static final String DELETE_RESOURCE_REF = "deleteResourceReference";
    protected static final String DELETE_RESOURCE_AND_REF = "deleteResourceAndResourceReference";
    protected static final String DOMAIN_TARGET = "domain";
    protected MBeanServer mbs = MBeanServerFactory.getMBeanServer();
    private static final Logger sLogger = DeploymentLogger.get();

    protected void doResourceOperation(DeploymentRequest req) throws Exception {
        String targetListString = req.getResourceTargetList();
        List<String> targetList = DeploymentServiceUtils.getTargetNamesFromTargetString(targetListString);
        String resourceAction = req.getResourceAction();
        if (resourceAction == null || this.getActualAction(resourceAction).equals("resNoOp")) {
            return;
        }
        if (targetList == null || targetList.isEmpty()) {
            return;
        }
        List<Resource> resourceList = DeploymentServiceUtils.getResourceList(req, this.getForceParsing(resourceAction), this.deploymentCtx);
        if (resourceList.size() == 0) {
            return;
        }
        this.handleResources(resourceAction, targetList, this.getRelevantResources(resourceList));
    }

    protected void handleResources(String resourceAction, List<String> targetList, List<Resource> resourceList) throws Exception {
        if (resourceList.size() == 0) {
            return;
        }
        if (resourceAction.equals("resDeployment")) {
            this.handleDeployment(targetList, resourceList);
        } else if (resourceAction.equals("resCreateRef")) {
            this.handleCreateApplicationRef(targetList, resourceList);
        } else if (resourceAction.equals("resDeleteRef")) {
            this.handleDeleteApplicationRef(targetList, resourceList);
        } else if (resourceAction.equals("resUndeployment")) {
            this.handleUndeployment(targetList, resourceList);
        } else if (resourceAction.equals("resRedeployment")) {
            this.handleRedeployment(targetList, resourceList);
        }
        DeploymentServiceUtils.flushConfigAndSendEvents();
    }

    protected void handleDeployment(List<String> targetList, List<Resource> resourceList) throws Exception {
        ObjectName mbeanName = new ObjectName(resourcesMBeanName);
        if (targetList.size() == 1 && targetList.get(0).equals(DOMAIN_TARGET)) {
            String[] signature = new String[]{"java.util.List", "java.lang.Boolean"};
            Object[] params = new Object[]{resourceList, Boolean.TRUE};
            this.mbs.invoke(mbeanName, CREATE_RESOURCE, params, signature);
        } else {
            String[] signature = new String[]{"java.util.List", "java.util.List", "java.lang.Boolean"};
            Object[] params = new Object[]{resourceList, targetList, Boolean.TRUE};
            this.mbs.invoke(mbeanName, CREATE_RESOURCE_AND_REF, params, signature);
        }
    }

    protected void handleCreateApplicationRef(List<String> targetList, List<Resource> resourceList) throws Exception {
        ObjectName mbeanName = new ObjectName(resourcesMBeanName);
        String[] signature = new String[]{"java.util.List", "java.util.List", "java.lang.Boolean"};
        Object[] params = new Object[]{resourceList, targetList, Boolean.TRUE};
        this.mbs.invoke(mbeanName, CREATE_RESOURCE_REF, params, signature);
    }

    protected void handleUndeployment(List<String> targetList, List<Resource> resourceList) {
        try {
            ObjectName mbeanName = new ObjectName(resourcesMBeanName);
            if (targetList.size() == 1 && targetList.get(0).equals(DOMAIN_TARGET)) {
                String[] signature = new String[]{"java.util.List"};
                Object[] params = new Object[]{resourceList};
                this.mbs.invoke(mbeanName, DELETE_RESOURCE, params, signature);
            } else {
                String[] signature = new String[]{"java.util.List", "java.util.List"};
                Object[] params = new Object[]{resourceList, targetList};
                this.mbs.invoke(mbeanName, DELETE_RESOURCE_AND_REF, params, signature);
            }
        }
        catch (Exception e) {
            sLogger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    protected abstract void handleRedeployment(List<String> var1, List<Resource> var2) throws Exception;

    protected void handleDeleteApplicationRef(List<String> targetList, List<Resource> resourceList) throws Exception {
        ObjectName mbeanName = new ObjectName(resourcesMBeanName);
        String[] signature = new String[]{"java.util.List", "java.util.List"};
        Object[] params = new Object[]{resourceList, targetList};
        this.mbs.invoke(mbeanName, DELETE_RESOURCE_REF, params, signature);
    }

    protected boolean getForceParsing(String resAction) {
        return false;
    }

    protected String getActualAction(String resAction) {
        return resAction;
    }

    protected abstract List<Resource> getRelevantResources(List<Resource> var1);
}

