/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.backend.J2EEModuleExploder;
import com.sun.enterprise.deployment.backend.ModuleDeployer;
import com.sun.enterprise.deployment.interfaces.DDGenerator;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.instance.EjbModulesManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.ModuleEnvironment;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.application.EJBSecurityManager;
import com.sun.enterprise.security.factory.EJBSecurityManagerFactory;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.zip.ZipItem;
import java.util.logging.Level;

public class EjbModuleDeployer
extends ModuleDeployer {
    DDGenerator ddGenerator = null;
    private EjbModulesManager manager = null;
    private static StringManager localStrings = StringManager.getManager(EjbModuleDeployer.class);

    EjbModuleDeployer(DeploymentRequest r) throws IASDeploymentException {
        super(r);
    }

    protected boolean needsStubs() {
        return true;
    }

    protected BaseManager createConfigManager(InstanceEnvironment ienv, ModuleEnvironment menv) throws IASDeploymentException, ConfigException {
        this.manager = new EjbModulesManager(ienv);
        return this.manager;
    }

    protected void preDeploy() throws IASDeploymentException {
        assert (this.stubsDir != null);
        assert (this.moduleDir != null);
        assert (this.moduleName != null);
        try {
            if (this.request.isArchive()) {
                if (this.request.getFileSource().getFile().getName().endsWith(".class")) {
                    this.copyAutodeployedClassFile(this.request.getFileSource().getFile(), this.moduleDir);
                } else {
                    J2EEModuleExploder.explodeJar(this.request.getFileSource().getFile(), this.moduleDir);
                }
            }
            this.xmlDir.mkdirs();
            this.stubsDir.mkdirs();
        }
        catch (Exception e) {
            throw new IASDeploymentException(e.toString(), e);
        }
    }

    protected void deploy() throws IASDeploymentException, ConfigException {
        this.loadDescriptors();
        this.runVerifier();
        this.request.getDescriptor().setGeneratedXMLDirectory(this.xmlDir.getAbsolutePath());
        ZipItem[] clientStubs = this.runEJBC();
        this.createClientJar(clientStubs);
    }

    protected void register() throws IASDeploymentException, ConfigException {
        super.register();
        this.setShared(this.request.isSharedModule());
    }

    protected void generatePolicy() throws IASDeploymentException {
        try {
            if (this.request.isApplication()) {
                return;
            }
            Application app = this.request.getDescriptor();
            EjbBundleDescriptor ejbBundleDesc = (EjbBundleDescriptor)app.getStandaloneBundleDescriptor();
            String name = EJBSecurityManager.getContextID(ejbBundleDesc);
            SecurityUtil.generatePolicyFile(name);
            EJBSecurityManagerFactory ejbsmf = (EJBSecurityManagerFactory)EJBSecurityManagerFactory.getInstance();
            ejbsmf.createSecurityManager((EjbDescriptor)ejbBundleDesc.getEjbs().iterator().next());
        }
        catch (IASSecurityException se) {
            String msg = localStrings.getString("enterprise.deployment.backend.generate_policy_error");
            this.logger.log(Level.WARNING, msg, se);
            throw new IASDeploymentException(msg, se);
        }
    }

    public void removePolicy() throws IASDeploymentException {
        if (this.request.isApplication()) {
            return;
        }
        String requestName = this.request.getName();
        EJBSecurityManagerFactory ejbsmf = (EJBSecurityManagerFactory)EJBSecurityManagerFactory.getInstance();
        String[] names = ejbsmf.getAndRemoveContextIdForEjbAppName(requestName);
        String name = null;
        try {
            if (names != null && names.length > 0 && names[0] != null) {
                name = names[0];
                SecurityUtil.removePolicy(name);
                ejbsmf.removeSecurityManager(name);
            }
        }
        catch (IASSecurityException ex) {
            String msg = localStrings.getString("enterprise.deployment.backend.remove_policy_error", name);
            this.logger.log(Level.WARNING, msg, ex);
            throw new IASDeploymentException(msg, ex);
        }
    }
}

