/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.archivist.ConnectorArchivist;
import com.sun.enterprise.deployment.archivist.EjbArchivist;
import com.sun.enterprise.deployment.archivist.WebArchivist;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.phasing.DeploymentServiceUtils;
import com.sun.enterprise.instance.AppclientModulesManager;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.instance.ConnectorModulesManager;
import com.sun.enterprise.instance.EjbModulesManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.WebModulesManager;
import com.sun.enterprise.loader.ClassLoaderUtils;
import com.sun.enterprise.loader.EJBClassLoader;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DeploymentUtils {
    private static final Logger _logger = DeploymentLogger.get();

    private DeploymentUtils() {
    }

    static void setParentClassLoader(ClassLoader bootStrap, BaseManager baseMgr, DeploymentRequest req) throws ConfigException, IOException {
        List commonClassPath;
        ArrayList allClassPaths = new ArrayList();
        List systemClasspath = baseMgr.getSystemCPathPrefixNSuffix();
        if (systemClasspath.size() > 0) {
            allClassPaths.addAll(systemClasspath);
        }
        if ((commonClassPath = DeploymentUtils.getCommonClasspath(baseMgr)).size() > 0) {
            allClassPaths.addAll(commonClassPath);
        }
        String targetString = req.getResourceTargetList();
        List<String> targets = null;
        if (targetString != null) {
            targets = DeploymentServiceUtils.getTargetNamesFromTargetString(targetString);
        } else {
            Cluster[] clusters;
            Server[] servers;
            targets = new ArrayList<String>();
            ConfigContext configContext = AdminService.getAdminService().getAdminContext().getAdminConfigContext();
            for (Server server : servers = ServerHelper.getServersInDomain(configContext)) {
                targets.add(server.getName());
            }
            for (Cluster cluster : clusters = ClusterHelper.getClustersInDomain(configContext)) {
                targets.add(cluster.getName());
            }
        }
        for (String target : targets) {
            List sharedClassPath = baseMgr.getSharedClasspath(true, target);
            if (sharedClassPath.size() <= 0) continue;
            allClassPaths.addAll(sharedClassPath);
        }
        EJBClassLoader parentClassLoader = DeploymentUtils.getClassLoader(allClassPaths, bootStrap, null);
        req.setParentClassLoader(parentClassLoader);
        req.setParentClasspath(allClassPaths);
    }

    static EJBClassLoader getClassLoader(List paths, ClassLoader parent, File other) throws IOException {
        EJBClassLoader ejbCl = null;
        ejbCl = parent != null ? new EJBClassLoader(parent) : new EJBClassLoader();
        int LIST_SZ = paths.size();
        for (int i = 0; i < LIST_SZ; ++i) {
            String path = (String)paths.get(i);
            ejbCl.appendURL(new File(path));
        }
        if (other != null) {
            ejbCl.appendURL(other);
        }
        return ejbCl;
    }

    static List getCommonClasspath(BaseManager mgr) throws IOException {
        InstanceEnvironment env = mgr.getInstanceEnvironment();
        String dir = env.getLibClassesPath();
        String jarDir = env.getLibPath();
        return ClassLoaderUtils.getUrlList(new File[]{new File(dir)}, new File[]{new File(jarDir)});
    }

    protected static String getSystemPropertyIgnoreCase(String key) {
        Properties p = System.getProperties();
        Set<Map.Entry<Object, Object>> set = p.entrySet();
        for (Map.Entry<Object, Object> me : set) {
            String propKey = (String)me.getKey();
            if (key.compareToIgnoreCase(propKey) != 0) continue;
            return (String)me.getValue();
        }
        return null;
    }

    static Application getAppDescriptor(String appDir) throws IASDeploymentException {
        return DeploymentUtils.getAppDescriptor(appDir, false);
    }

    static Application getAppDescriptor(String appDir, boolean annotationProcessing) throws IASDeploymentException {
        try {
            FileArchive archive = new FileArchive();
            archive.open(appDir);
            ApplicationArchivist archivist = new ApplicationArchivist();
            archivist.setAnnotationProcessingRequested(annotationProcessing);
            archivist.setXMLValidation(false);
            return (Application)archivist.open(archive);
        }
        catch (Throwable t) {
            throw new IASDeploymentException(t);
        }
    }

    static Application getModuleDescriptor(String appDir) throws IASDeploymentException {
        return DeploymentUtils.getModuleDescriptor(appDir, false);
    }

    static Application getModuleDescriptor(String appDir, boolean annotationProcessing) throws IASDeploymentException {
        try {
            FileArchive archive = new FileArchive();
            archive.open(appDir);
            Archivist archivist = ArchivistFactory.getArchivistForArchive(archive);
            archivist.setAnnotationProcessingRequested(annotationProcessing);
            archivist.setXMLValidation(false);
            return ApplicationArchivist.openArchive(archivist, archive, true);
        }
        catch (Throwable t) {
            throw new IASDeploymentException(t);
        }
    }

    public static RootDeploymentDescriptor getDescriptor(String appId, BaseManager manager) throws IASDeploymentException {
        Application application = manager.getRegisteredDescriptor(appId);
        if (application != null) {
            if (application.isVirtual()) {
                return application.getStandaloneBundleDescriptor();
            }
            return application;
        }
        FileArchive in = new FileArchive();
        try {
            String appDir = manager.getLocation(appId);
            if (manager.isSystemAdmin(appId)) {
                in.open(appDir);
            } else {
                String xmlDir = manager.getGeneratedXMLLocation(appId);
                if (FileUtils.safeIsDirectory(xmlDir)) {
                    in.open(xmlDir);
                } else {
                    _logger.log(Level.WARNING, "enterprise.deployment.backend.no_generated_xmldir", new Object[]{appId, xmlDir, appDir});
                    in.open(appDir);
                }
            }
            Archivist archivist = null;
            if (manager instanceof AppsManager) {
                archivist = new ApplicationArchivist();
            } else if (manager instanceof EjbModulesManager) {
                archivist = new EjbArchivist();
            } else if (manager instanceof WebModulesManager) {
                archivist = new WebArchivist();
            } else if (manager instanceof AppclientModulesManager) {
                archivist = new AppClientArchivist();
            } else if (manager instanceof ConnectorModulesManager) {
                archivist = new ConnectorArchivist();
            }
            archivist.setAnnotationProcessingRequested(false);
            archivist.setXMLValidation(false);
            Application desc = ApplicationArchivist.openArchive(appId, archivist, in, true);
            if (desc.isVirtual()) {
                BundleDescriptor bundleDescriptor = (BundleDescriptor)desc.getBundleDescriptors().iterator().next();
                return bundleDescriptor;
            }
            archivist.setHandleRuntimeInfo(false);
            ((ApplicationArchivist)archivist).readModulesDescriptors(desc, in);
            archivist.setHandleRuntimeInfo(true);
            archivist.readRuntimeDeploymentDescriptor(in, desc);
            Application application2 = desc;
            return application2;
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "enterprise.deployment.backend.get_descriptor_failed", new Object[]{appId});
            IASDeploymentException de = new IASDeploymentException(ex.getMessage());
            de.initCause(ex);
            throw de;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception ex) {}
        }
    }

    public static String getRelativeEmbeddedModulePath(String appRootPath, String moduleUri) {
        if (FileUtils.safeIsDirectory(new File(appRootPath, moduleUri = FileUtils.makeLegalNoBlankFileName(moduleUri)))) {
            return moduleUri;
        }
        return FileUtils.makeFriendlyFilename(moduleUri);
    }

    public static String getEmbeddedModulePath(String appRootPath, String moduleUri) {
        return appRootPath + File.separator + DeploymentUtils.getRelativeEmbeddedModulePath(appRootPath, moduleUri);
    }
}

