/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient.jws;

import com.sun.enterprise.appclient.jws.ASJarSigner;
import com.sun.enterprise.appclient.jws.ContentOrigin;
import com.sun.enterprise.appclient.jws.StaticContent;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.security.SSLUtils;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.net.URI;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.logging.Logger;

public class SignedStaticContent
extends StaticContent {
    private final File unsignedJar;
    private final File signedJar;
    private URI installRootURI;
    private final Logger logger = DeploymentLogger.get();
    private final StringManager localStrings;

    public SignedStaticContent(ContentOrigin origin, String contentKey, String path, File signedJar, File unsignedJar, URI installRootURI, StringManager localStrings, boolean isMain) throws Exception {
        super(origin, contentKey, path, signedJar, installRootURI, isMain);
        this.installRootURI = installRootURI;
        this.unsignedJar = unsignedJar;
        this.signedJar = signedJar;
        this.localStrings = localStrings;
    }

    public URI getRelativeURI() {
        try {
            this.ensureSignedFileUpToDate();
            return this.installRootURI.relativize(this.signedJar.toURI());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private synchronized void ensureSignedFileUpToDate() throws KeyStoreException, IllegalArgumentException, Exception {
        if (!this.unsignedJar.exists()) {
            throw new IllegalArgumentException(this.localStrings.getString("jws.sign.noUnsignedJar", this.unsignedJar.getAbsolutePath()));
        }
        if (!this.signedJar.exists() || this.signedJar.lastModified() < this.unsignedJar.lastModified()) {
            this.signJar();
        }
    }

    private void signJar() throws Exception {
        File signedJarParent = this.signedJar.getParentFile();
        if (!signedJarParent.exists() && !signedJarParent.mkdirs()) {
            throw new Exception(this.localStrings.getString("jws.sign.errorCreatingDir", signedJarParent.getAbsolutePath()));
        }
        ASJarSigner.signJar(this.unsignedJar, this.signedJar);
    }

    private String getKeystorePassword() {
        return SSLUtils.getKeyStorePass();
    }

    private boolean checkUserAlias(KeyStore keystore, String candidateAlias) throws KeyStoreException {
        boolean result = keystore.containsAlias(candidateAlias);
        if (!result) {
            this.logger.warning(this.localStrings.getString("jws.sign.userAliasAbsent", candidateAlias));
        }
        return result;
    }
}

