/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient.jws;

import com.sun.enterprise.appclient.jws.NamingConventions;
import com.sun.enterprise.appclient.jws.UserContentOrigin;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.instance.BaseManager;
import java.io.File;

public class AppclientContentOrigin
extends UserContentOrigin {
    private String contextRoot;
    protected ModuleDescriptor moduleDescriptor;
    private VendorInfo vendorInfo = null;

    public AppclientContentOrigin(Application application, ModuleDescriptor moduleDescriptor, String contextRoot) {
        super(application);
        this.moduleDescriptor = moduleDescriptor;
        if (contextRoot.length() < 2 || !contextRoot.substring(0, 1).equals("/")) {
            String regName = application.getRegistrationName();
            throw new IllegalArgumentException("Java Web Start-related context root of '" + contextRoot + "' specified for app client " + regName + " must begin with a slash and contain at least one other character");
        }
        this.contextRoot = contextRoot;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public String getDisplayName() {
        return this.moduleDescriptor.getDescriptor().getDisplayName();
    }

    public String getDescription() {
        return this.getApplication().getDescription();
    }

    public String getAppclientJarPath() {
        return NamingConventions.TopLevelAppclient.appclientJarPath(this);
    }

    protected String getContentKeyPrefix() {
        return NamingConventions.TopLevelAppclient.contentKeyPrefix(this);
    }

    protected String getTargetPath() {
        return NamingConventions.TopLevelAppclient.actualContextRoot(this.application);
    }

    public String getVirtualPath() {
        return NamingConventions.TopLevelAppclient.virtualContextRoot(this.application, this.moduleDescriptor);
    }

    public String toString() {
        return super.toString() + ", context root=" + this.getVirtualPath() + ", module name=" + this.moduleDescriptor.getName();
    }

    public String getVendor() {
        return this.getVendorInfo().getVendor();
    }

    public String getImageURI() {
        return this.getVendorInfo().getImageURI();
    }

    public String getSplashImageURI() {
        return this.getVendorInfo().getSplashImageURI();
    }

    public File locateFile(BaseManager manager, String URI2) throws ConfigException {
        File file = new File(manager.getLocation(this.getApplication().getRegistrationName()), URI2);
        return file;
    }

    private VendorInfo getVendorInfo() {
        if (this.vendorInfo == null) {
            this.vendorInfo = new VendorInfo(((ApplicationClientDescriptor)this.moduleDescriptor.getDescriptor()).getJavaWebStartAccessDescriptor().getVendor());
        }
        return this.vendorInfo;
    }

    public String getName() {
        return this.application.getRegistrationName();
    }

    private class VendorInfo {
        private String vendorStringFromDescriptor;
        private String vendor = "";
        private String imageURIString = "";
        private String splashImageURIString = "";

        private VendorInfo(String vendorStringFromDescriptor) {
            this.vendorStringFromDescriptor = vendorStringFromDescriptor != null ? vendorStringFromDescriptor : "";
            String[] parts = this.vendorStringFromDescriptor.split("::");
            if (parts.length == 1) {
                this.vendor = parts[0];
            } else if (parts.length == 2) {
                this.imageURIString = parts[0];
                this.vendor = parts[0];
            } else if (parts.length == 3) {
                this.imageURIString = parts[0];
                this.splashImageURIString = parts[1];
                this.vendor = parts[2];
            }
        }

        private String getVendor() {
            return this.vendor;
        }

        private String getImageURI() {
            return this.imageURIString;
        }

        private String getSplashImageURI() {
            return this.splashImageURIString;
        }
    }
}

