/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.verifier.tests;

import com.sun.enterprise.admin.verifier.Result;
import com.sun.enterprise.admin.verifier.ServerCheck;
import com.sun.enterprise.admin.verifier.ServerXmlTest;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;

public class OrbTest
extends ServerXmlTest
implements ServerCheck {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");
    public static final String ERROR_MSG = "Message Fragment Size can be only 1024, 2048, 4096, 8192, 16284 or 32568";

    public Result check(ConfigContext context) {
        Object msgFragmentSize = null;
        Result result = super.getInitializedResult();
        return result;
    }

    public Result check(ConfigContextEvent ccce) {
        Result result = new Result();
        result.passed("Passed **");
        Object value = ccce.getObject();
        String choice = ccce.getChoice();
        ConfigContext context = ccce.getConfigContext();
        String beanName = ccce.getBeanName();
        Object msgFragmentSize = null;
        if (beanName != null) {
            return this.validateAttribute(ccce.getName(), ccce.getObject());
        }
        return result;
    }

    public Result validateAttribute(String name, Object value) {
        Result result = new Result();
        result.passed("Passed **");
        String msgFragmentSize = null;
        if (name.equals("message-fragment-size")) {
            try {
                msgFragmentSize = (String)value;
                int size = Integer.parseInt(msgFragmentSize);
                int kSize = size / 1024;
                int remainder = size % 1024;
                if (remainder != 0) {
                    result.failed(ERROR_MSG);
                } else if (kSize != 1 && kSize != 2 && kSize != 4 && kSize != 8 && kSize != 16 && kSize != 32) {
                    result.failed(ERROR_MSG);
                } else {
                    result.passed("Vaild Message Fragment Size");
                }
            }
            catch (NumberFormatException nfe) {
                result.failed("Message Fragment Size - " + msgFragmentSize + " : Invalid");
            }
        }
        if (name.equals("max-connections")) {
            try {
                if (value != null) {
                    String conn = (String)value;
                    if (Integer.parseInt(conn) < 0) {
                        result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxConnNegative", "Max Connections cannot be negative number"));
                    } else {
                        result.passed("Passed ***");
                    }
                }
            }
            catch (NumberFormatException e) {
                result.failed(this.smh.getLocalString(this.getClass().getName() + ".maxConnInvalid", "Max Connections : invalid number"));
            }
        }
        return result;
    }
}

