/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.config.ConfigChange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigChangeEvent
extends AdminEvent {
    static final String eventType = ConfigChangeEvent.class.getName();
    private boolean webCoreReconfigNeeded = false;
    private boolean initOrObjConfChanged = false;
    private HashMap matchMap;

    public ConfigChangeEvent(String instanceName, ArrayList configChangeList) {
        super(eventType, instanceName);
        this.configChangeList = configChangeList;
    }

    public ArrayList getConfigChangeList() {
        return this.configChangeList;
    }

    void setWebCoreReconfigNeeded(boolean reconfig) {
        this.webCoreReconfigNeeded = reconfig;
    }

    boolean isWebCoreReconfigNeeded() {
        return this.webCoreReconfigNeeded;
    }

    void setInitOrObjConfChanged(boolean changed) {
        this.initOrObjConfChanged = changed;
    }

    boolean isInitOrObjConfChanged() {
        return this.initOrObjConfChanged;
    }

    boolean matchXPathToPattern(Pattern pattern) {
        boolean match = false;
        if (this.configChangeList == null) {
            return match;
        }
        for (ConfigChange change : this.configChangeList) {
            Matcher matcher;
            String xpath = change.getXPath();
            if (xpath == null || !(match = (matcher = pattern.matcher(xpath)).matches())) continue;
            this.setConfigChangeMatched(change);
        }
        return match;
    }

    boolean isNoOp() {
        boolean isNoOp = false;
        if (this.configChangeList == null && !this.webCoreReconfigNeeded) {
            isNoOp = true;
        }
        return isNoOp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConfigChangeMatched(ConfigChange change) {
        ConfigChangeEvent configChangeEvent = this;
        synchronized (configChangeEvent) {
            if (this.matchMap == null) {
                this.matchMap = new HashMap();
            }
        }
        this.matchMap.put(change, change);
    }

    boolean isAllXPathMatched() {
        boolean matched = true;
        if (this.configChangeList == null || this.matchMap == null) {
            matched = false;
            return matched;
        }
        Iterator iter = this.configChangeList.iterator();
        while (iter.hasNext()) {
            if (this.matchMap.containsKey(iter.next())) continue;
            matched = false;
            break;
        }
        return matched;
    }
}

