/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.protocol;

import com.sun.corba.ee.pept.protocol.ClientRequestDispatcher;
import com.sun.corba.ee.spi.oa.ObjectAdapterFactory;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orbutil.misc.DenseIntMapImpl;
import com.sun.corba.ee.spi.protocol.CorbaServerRequestDispatcher;
import com.sun.corba.ee.spi.protocol.LocalClientRequestDispatcherFactory;
import com.sun.corba.ee.spi.protocol.RequestDispatcherRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RequestDispatcherRegistryImpl
implements RequestDispatcherRegistry {
    private ORB orb;
    protected int defaultId;
    private DenseIntMapImpl SDRegistry;
    private DenseIntMapImpl CSRegistry;
    private DenseIntMapImpl OAFRegistry;
    private DenseIntMapImpl LCSFRegistry;
    private Set objectAdapterFactories;
    private Set objectAdapterFactoriesView;
    private Map stringToServerSubcontract;

    public RequestDispatcherRegistryImpl(ORB orb, int defaultId) {
        this.orb = orb;
        this.defaultId = defaultId;
        this.SDRegistry = new DenseIntMapImpl();
        this.CSRegistry = new DenseIntMapImpl();
        this.OAFRegistry = new DenseIntMapImpl();
        this.LCSFRegistry = new DenseIntMapImpl();
        this.objectAdapterFactories = new HashSet();
        this.objectAdapterFactoriesView = Collections.unmodifiableSet(this.objectAdapterFactories);
        this.stringToServerSubcontract = new HashMap();
    }

    public synchronized void registerClientRequestDispatcher(ClientRequestDispatcher csc, int scid) {
        this.CSRegistry.set(scid, csc);
    }

    public synchronized void registerLocalClientRequestDispatcherFactory(LocalClientRequestDispatcherFactory csc, int scid) {
        this.LCSFRegistry.set(scid, csc);
    }

    public synchronized void registerServerRequestDispatcher(CorbaServerRequestDispatcher ssc, int scid) {
        this.SDRegistry.set(scid, ssc);
    }

    public synchronized void registerServerRequestDispatcher(CorbaServerRequestDispatcher scc, String name) {
        this.stringToServerSubcontract.put(name, scc);
    }

    public synchronized void registerObjectAdapterFactory(ObjectAdapterFactory oaf, int scid) {
        this.objectAdapterFactories.add(oaf);
        this.OAFRegistry.set(scid, oaf);
    }

    public CorbaServerRequestDispatcher getServerRequestDispatcher(int scid) {
        CorbaServerRequestDispatcher sdel = (CorbaServerRequestDispatcher)this.SDRegistry.get(scid);
        if (sdel == null) {
            sdel = (CorbaServerRequestDispatcher)this.SDRegistry.get(this.defaultId);
        }
        return sdel;
    }

    public CorbaServerRequestDispatcher getServerRequestDispatcher(String name) {
        CorbaServerRequestDispatcher sdel = (CorbaServerRequestDispatcher)this.stringToServerSubcontract.get(name);
        if (sdel == null) {
            sdel = (CorbaServerRequestDispatcher)this.SDRegistry.get(this.defaultId);
        }
        return sdel;
    }

    public LocalClientRequestDispatcherFactory getLocalClientRequestDispatcherFactory(int scid) {
        LocalClientRequestDispatcherFactory factory = (LocalClientRequestDispatcherFactory)this.LCSFRegistry.get(scid);
        if (factory == null) {
            factory = (LocalClientRequestDispatcherFactory)this.LCSFRegistry.get(this.defaultId);
        }
        return factory;
    }

    public ClientRequestDispatcher getClientRequestDispatcher(int scid) {
        ClientRequestDispatcher subcontract = (ClientRequestDispatcher)this.CSRegistry.get(scid);
        if (subcontract == null) {
            subcontract = (ClientRequestDispatcher)this.CSRegistry.get(this.defaultId);
        }
        return subcontract;
    }

    public ObjectAdapterFactory getObjectAdapterFactory(int scid) {
        ObjectAdapterFactory oaf = (ObjectAdapterFactory)this.OAFRegistry.get(scid);
        if (oaf == null) {
            oaf = (ObjectAdapterFactory)this.OAFRegistry.get(this.defaultId);
        }
        return oaf;
    }

    public Set getObjectAdapterFactories() {
        return this.objectAdapterFactoriesView;
    }
}

