/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.interceptors;

import com.sun.corba.ee.impl.interceptors.ClientRequestInfoImpl;
import com.sun.corba.ee.impl.interceptors.IORInfoImpl;
import com.sun.corba.ee.impl.interceptors.InterceptorList;
import com.sun.corba.ee.impl.interceptors.PICurrent;
import com.sun.corba.ee.impl.interceptors.ServerRequestInfoImpl;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.oa.ObjectAdapter;
import com.sun.corba.ee.spi.orb.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.IORInterceptor_3_0;
import org.omg.PortableInterceptor.ObjectReferenceTemplate;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public class InterceptorInvoker {
    private ORB orb;
    private InterceptorList interceptorList;
    private boolean enabled = false;
    private PICurrent current;

    InterceptorInvoker(ORB orb, InterceptorList interceptorList, PICurrent piCurrent) {
        this.orb = orb;
        this.interceptorList = interceptorList;
        this.enabled = false;
        this.current = piCurrent;
    }

    private void dprint(String msg) {
        ORBUtility.dprint(this, msg);
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    void objectAdapterCreated(ObjectAdapter oa) {
        if (this.enabled) {
            IORInterceptor interceptor;
            int i;
            IORInfoImpl info = new IORInfoImpl(oa);
            IORInterceptor[] iorInterceptors = (IORInterceptor[])this.interceptorList.getInterceptors(2);
            int size = iorInterceptors.length;
            for (i = size - 1; i >= 0; --i) {
                interceptor = iorInterceptors[i];
                try {
                    interceptor.establish_components((IORInfo)info);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            info.makeStateEstablished();
            for (i = size - 1; i >= 0; --i) {
                interceptor = iorInterceptors[i];
                if (!(interceptor instanceof IORInterceptor_3_0)) continue;
                IORInterceptor_3_0 interceptor30 = (IORInterceptor_3_0)interceptor;
                interceptor30.components_established((IORInfo)info);
            }
            info.makeStateDone();
        }
    }

    void adapterManagerStateChanged(int managerId, short newState) {
        if (this.enabled) {
            IORInterceptor[] interceptors = (IORInterceptor[])this.interceptorList.getInterceptors(2);
            int size = interceptors.length;
            for (int i = size - 1; i >= 0; --i) {
                try {
                    IORInterceptor interceptor = interceptors[i];
                    if (!(interceptor instanceof IORInterceptor_3_0)) continue;
                    IORInterceptor_3_0 interceptor30 = (IORInterceptor_3_0)interceptor;
                    interceptor30.adapter_manager_state_changed(managerId, newState);
                    continue;
                }
                catch (Exception exc) {
                    // empty catch block
                }
            }
        }
    }

    void adapterStateChanged(ObjectReferenceTemplate[] templates, short newState) {
        if (this.enabled) {
            IORInterceptor[] interceptors = (IORInterceptor[])this.interceptorList.getInterceptors(2);
            int size = interceptors.length;
            for (int i = size - 1; i >= 0; --i) {
                try {
                    IORInterceptor interceptor = interceptors[i];
                    if (!(interceptor instanceof IORInterceptor_3_0)) continue;
                    IORInterceptor_3_0 interceptor30 = (IORInterceptor_3_0)interceptor;
                    interceptor30.adapter_state_changed(templates, newState);
                    continue;
                }
                catch (Exception exc) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeClientInterceptorStartingPoint(ClientRequestInfoImpl info) {
        if (this.enabled) {
            if (this.orb.interceptorDebugFlag) {
                this.dprint("->invokeClientInterceptorStartingPoint " + info);
            }
            try {
                int size;
                this.current.pushSlotTable();
                info.setPICurrentPushed(true);
                info.setCurrentExecutionPoint(0);
                ClientRequestInterceptor[] clientInterceptors = (ClientRequestInterceptor[])this.interceptorList.getInterceptors(0);
                int flowStackIndex = size = clientInterceptors.length;
                boolean continueProcessing = true;
                for (int i = 0; continueProcessing && i < size; ++i) {
                    ClientRequestInterceptor cri = clientInterceptors[i];
                    try {
                        if (this.orb.interceptorDebugFlag) {
                            this.dprint(".invokeClientInterceptorStartingPoint: " + cri.name() + ".send_request");
                        }
                        cri.send_request((ClientRequestInfo)info);
                        continue;
                    }
                    catch (ForwardRequest e) {
                        if (this.orb.interceptorDebugFlag) {
                            this.dprint(".invokeClientInterceptorStartingPoint ForwardRequest from " + cri.name());
                        }
                        flowStackIndex = i;
                        info.setForwardRequest(e);
                        info.setEndingPointCall(2);
                        info.setReplyStatus((short)3);
                        this.updateClientRequestDispatcherForward(info);
                        continueProcessing = false;
                        continue;
                    }
                    catch (SystemException e) {
                        if (this.orb.interceptorDebugFlag) {
                            this.dprint(".invokeClientInterceptorStartingPoint SystemException " + (java.lang.Object)((java.lang.Object)e) + " from " + cri.name());
                        }
                        flowStackIndex = i;
                        info.setEndingPointCall(1);
                        info.setReplyStatus((short)1);
                        info.setException((Exception)((java.lang.Object)e));
                        continueProcessing = false;
                    }
                }
                info.setFlowStackIndex(flowStackIndex);
            }
            finally {
                if (this.orb.interceptorDebugFlag) {
                    this.dprint("<-invokeClientInterceptorStartingPoint " + info);
                }
                this.current.resetSlotTable();
            }
        }
    }

    private String getClientEndMethodName(int endingPointCall) {
        switch (endingPointCall) {
            case 0: {
                return "receive_reply";
            }
            case 1: {
                return "receive_exception";
            }
            case 2: {
                return "receive_other";
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeClientInterceptorEndingPoint(ClientRequestInfoImpl info) {
        if (this.enabled) {
            try {
                if (this.orb.interceptorDebugFlag) {
                    this.dprint("->invokeClientInterceptorEndingPoint " + info);
                }
                info.setCurrentExecutionPoint(2);
                ClientRequestInterceptor[] clientInterceptors = (ClientRequestInterceptor[])this.interceptorList.getInterceptors(0);
                int flowStackIndex = info.getFlowStackIndex();
                int endingPointCall = info.getEndingPointCall();
                if (endingPointCall == 0 && info.getIsOneWay()) {
                    endingPointCall = 2;
                    info.setEndingPointCall(endingPointCall);
                }
                for (int i = flowStackIndex - 1; i >= 0; --i) {
                    ClientRequestInterceptor cri = clientInterceptors[i];
                    try {
                        if (this.orb.interceptorDebugFlag) {
                            this.dprint(".invokeClientInterceptorEndingPoint: Interceptor " + cri.name() + "." + this.getClientEndMethodName(endingPointCall));
                        }
                        switch (endingPointCall) {
                            case 0: {
                                cri.receive_reply((ClientRequestInfo)info);
                                break;
                            }
                            case 1: {
                                cri.receive_exception((ClientRequestInfo)info);
                                break;
                            }
                            case 2: {
                                cri.receive_other((ClientRequestInfo)info);
                            }
                        }
                        continue;
                    }
                    catch (ForwardRequest e) {
                        if (this.orb.interceptorDebugFlag) {
                            this.dprint(".invokeClientInterceptorEndingPoint ForwardRequest from " + cri.name());
                        }
                        endingPointCall = 2;
                        info.setEndingPointCall(endingPointCall);
                        info.setReplyStatus((short)3);
                        info.setForwardRequest(e);
                        this.updateClientRequestDispatcherForward(info);
                        continue;
                    }
                    catch (SystemException e) {
                        if (this.orb.interceptorDebugFlag) {
                            this.dprint(".invokeClientInterceptorEndingPoint SystemException " + (java.lang.Object)((java.lang.Object)e) + " from " + cri.name());
                        }
                        endingPointCall = 1;
                        info.setEndingPointCall(endingPointCall);
                        info.setReplyStatus((short)1);
                        info.setException((Exception)((java.lang.Object)e));
                    }
                }
            }
            finally {
                if (this.orb.interceptorDebugFlag) {
                    this.dprint("<-invokeClientInterceptorEndingPoint " + info);
                }
                if (info != null && info.isPICurrentPushed()) {
                    this.current.popSlotTable();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeServerInterceptorStartingPoint(ServerRequestInfoImpl info) {
        if (this.enabled) {
            try {
                int size;
                if (this.orb.interceptorDebugFlag) {
                    this.dprint("->invokeServerInterceptorStartingPoint " + info);
                }
                this.current.pushSlotTable();
                info.setSlotTable(this.current.getSlotTable());
                this.current.pushSlotTable();
                info.setCurrentExecutionPoint(0);
                ServerRequestInterceptor[] serverInterceptors = (ServerRequestInterceptor[])this.interceptorList.getInterceptors(1);
                int flowStackIndex = size = serverInterceptors.length;
                boolean continueProcessing = true;
                for (int i = 0; continueProcessing && i < size; ++i) {
                    ServerRequestInterceptor sri = serverInterceptors[i];
                    try {
                        if (this.orb.interceptorDebugFlag) {
                            this.dprint(".invokeServerInterceptorStartingPoint: Interceptor " + sri.name() + ".receive_request_service_contexts");
                        }
                        sri.receive_request_service_contexts((ServerRequestInfo)info);
                        continue;
                    }
                    catch (ForwardRequest e) {
                        if (this.orb.interceptorDebugFlag) {
                            this.dprint(".invokeServerInterceptorStartingPoint ForwardException from " + sri.name());
                        }
                        flowStackIndex = i;
                        info.setForwardRequest(e);
                        info.setIntermediatePointCall(1);
                        info.setEndingPointCall(2);
                        info.setReplyStatus((short)3);
                        continueProcessing = false;
                        continue;
                    }
                    catch (SystemException e) {
                        if (this.orb.interceptorDebugFlag) {
                            this.dprint(".invokeServerInterceptorStartingPoint SystemException " + (java.lang.Object)((java.lang.Object)e) + " from " + sri.name());
                        }
                        flowStackIndex = i;
                        info.setException((Exception)((java.lang.Object)e));
                        info.setIntermediatePointCall(1);
                        info.setEndingPointCall(1);
                        info.setReplyStatus((short)1);
                        continueProcessing = false;
                    }
                }
                info.setFlowStackIndex(flowStackIndex);
            }
            finally {
                if (this.orb.interceptorDebugFlag) {
                    this.dprint("<-invokeServerInterceptorStartingPoint " + info);
                }
                this.current.popSlotTable();
            }
        }
    }

    void invokeServerInterceptorIntermediatePoint(ServerRequestInfoImpl info) {
        int intermediatePointCall = info.getIntermediatePointCall();
        if (this.enabled && intermediatePointCall != 1) {
            if (this.orb.interceptorDebugFlag) {
                this.dprint("->invokeServerInterceptorIntermediatePoint " + info);
            }
            info.setCurrentExecutionPoint(1);
            for (ServerRequestInterceptor sri : (ServerRequestInterceptor[])this.interceptorList.getInterceptors(1)) {
                try {
                    if (this.orb.interceptorDebugFlag) {
                        this.dprint(".invokeServerInterceptorIntermediatePoint: Interceptor " + sri.name() + ".receive_request");
                    }
                    sri.receive_request((ServerRequestInfo)info);
                }
                catch (ForwardRequest e) {
                    if (this.orb.interceptorDebugFlag) {
                        this.dprint(".invokeServerInterceptorIntermediatePoint ForwardException from " + sri.name());
                    }
                    info.setForwardRequest(e);
                    info.setEndingPointCall(2);
                    info.setReplyStatus((short)3);
                    break;
                }
                catch (SystemException e) {
                    if (this.orb.interceptorDebugFlag) {
                        this.dprint(".invokeServerInterceptorIntermediatePoint SystemException " + (java.lang.Object)((java.lang.Object)e) + " from " + sri.name());
                    }
                    info.setException((Exception)((java.lang.Object)e));
                    info.setEndingPointCall(1);
                    info.setReplyStatus((short)1);
                    break;
                }
            }
            if (this.orb.interceptorDebugFlag) {
                this.dprint("<-invokeServerInterceptorIntermediatePoint " + info);
            }
        }
    }

    private String getServerEndMethodName(int endingPointCall) {
        switch (endingPointCall) {
            case 0: {
                return "send_reply";
            }
            case 1: {
                return "send_exception";
            }
            case 2: {
                return "send_other";
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeServerInterceptorEndingPoint(ServerRequestInfoImpl info) {
        if (this.enabled) {
            try {
                if (this.orb.interceptorDebugFlag) {
                    this.dprint("->invokeServerInterceptorEndingPoint " + info);
                }
                ServerRequestInterceptor[] serverInterceptors = (ServerRequestInterceptor[])this.interceptorList.getInterceptors(1);
                int flowStackIndex = info.getFlowStackIndex();
                int endingPointCall = info.getEndingPointCall();
                for (int i = flowStackIndex - 1; i >= 0; --i) {
                    ServerRequestInterceptor sri = serverInterceptors[i];
                    try {
                        if (this.orb.interceptorDebugFlag) {
                            this.dprint(".invokeServerInterceptorEndingPoint: Interceptor " + sri.name() + "." + this.getServerEndMethodName(endingPointCall));
                        }
                        switch (endingPointCall) {
                            case 0: {
                                sri.send_reply((ServerRequestInfo)info);
                                break;
                            }
                            case 1: {
                                sri.send_exception((ServerRequestInfo)info);
                                break;
                            }
                            case 2: {
                                sri.send_other((ServerRequestInfo)info);
                            }
                        }
                        continue;
                    }
                    catch (ForwardRequest e) {
                        if (this.orb.interceptorDebugFlag) {
                            this.dprint(".invokeServerInterceptorEndingPoint ForwardRequest from " + sri.name());
                        }
                        endingPointCall = 2;
                        info.setEndingPointCall(endingPointCall);
                        info.setForwardRequest(e);
                        info.setReplyStatus((short)3);
                        info.setForwardRequestRaisedInEnding();
                        continue;
                    }
                    catch (SystemException e) {
                        if (this.orb.interceptorDebugFlag) {
                            this.dprint(".invokeServerInterceptorEndingPoint SystemException " + (java.lang.Object)((java.lang.Object)e) + " from " + sri.name());
                        }
                        endingPointCall = 1;
                        info.setEndingPointCall(endingPointCall);
                        info.setException((Exception)((java.lang.Object)e));
                        info.setReplyStatus((short)1);
                    }
                }
                info.setAlreadyExecuted(true);
            }
            finally {
                if (this.orb.interceptorDebugFlag) {
                    this.dprint("<-invokeServerInterceptorEndingPoint " + info);
                }
                this.current.popSlotTable();
            }
        }
    }

    private void updateClientRequestDispatcherForward(ClientRequestInfoImpl info) {
        ForwardRequest forwardRequest = info.getForwardRequestException();
        if (forwardRequest != null) {
            Object object = forwardRequest.forward;
            IOR ior = this.orb.getIOR(object, false);
            info.setLocatedIOR(ior);
        }
    }
}

