/*
Copyright (C) 2009-2010 wxLauncher Team

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef IDS_HPP
#define IDS_HPP

#include <wx/stdpaths.h>

/* File contains all IDs and other application constants that are to be used
in the application. */

#define TAB_AREA_WIDTH (639)	//!< the number of pixels wide for the useable area of the tab
#define TAB_AREA_HEIGHT (595)	//!< the number of pixels high for the useable area of the tab

/** The IDs that wxLauncher uses to identify its controls to wxWidgets.  These
are in no particular order, but they are grouped into the tab or section of the
the control that it represents is located on.  

These IDs are also used by the help manager to open the correct help page 
for the context help. */
enum WindowIDS {
	ID_MAINTAB = wxID_HIGHEST + 1, /* wxID_HIGHEST is the maximum event id that wx
							   will use. */
	ID_CLOSE_BUTTON,
	ID_HELP_BUTTON,
	ID_FRED_BUTTON,
	ID_UPDATE_BUTTON,
	ID_PLAY_BUTTON,
	ID_ABOUT_BUTTON,
	ID_FS2_PROCESS,
	ID_FRED2_PROCESS,

	ID_PROFILE_COMBO,
	ID_NEW_PROFILE,
	ID_DELETE_PROFILE,
	ID_SAVE_PROFILE,
	ID_SAVE_DEFAULT_CHECK,
	ID_SUMMARY_HTML_PANEL,
	ID_HEADLINES_HTML_PANEL,

	ID_VIDEO_STATIC_BOX,
	ID_RESOLUTION_COMBO,
	ID_DEPTH_COMBO,
	ID_TEXTURE_FILTER_COMBO,
	ID_ANISOTROPIC_COMBO,
	ID_AA_COMBO,

	// Lighting presets
	ID_PRESETS_OFF,
	ID_PRESET_BASELINE,
	ID_PRESET_DABRAIN,
	ID_PRESET_HERRA_TOHTORI,
	ID_PRESET_CKID,
	ID_PRESET_COLECAMPBELL666,
	ID_PRESET_CASTOR,
	ID_PRESET_SPIDEY,
	ID_PRESET_WOOLIE_WOOL,
	ID_COPY_PRESET_BUTTON,

	ID_SPEECH_TEST_TEXT,
	ID_SPEECH_VOICE_COMBO,
	ID_SPEECH_VOICE_VOLUME,
	ID_SPEECH_PLAY_BUTTON,
	ID_SPEECH_IN_TECHROOM,
	ID_SPEECH_IN_BRIEFING,
	ID_SPEECH_IN_GAME,
	ID_SPEECH_IN_MULTI,
	ID_SPEECH_MORE_VOICES_BUTTON,

	ID_NETWORK_TYPE,
	ID_NETWORK_SPEED,
	ID_NETWORK_PORT,
	ID_NETWORK_IP,

	ID_SELECT_SOUND_DEVICE,
	ID_SELECT_CAPTURE_DEVICE,
	ID_ENABLE_EFX,
	ID_AUDIO_SAMPLE_RATE,
	ID_DOWNLOAD_OPENAL,
	ID_DETECT_OPENAL,

	ID_JOY_SELECTED,
	ID_JOY_FORCE_FEEDBACK,
	ID_JOY_DIRECTIONAL_HIT,
	ID_JOY_CALIBRATE_BUTTON,
	ID_JOY_DETECT_BUTTON,

	ID_PROXY_TYPE,
	ID_PROXY_HTTP_SERVER,
	ID_PROXY_HTTP_PORT,
	ID_PROXY_AUTO_URL,

	ID_MODLISTBOX,
	ID_MODLISTBOX_ACTIVATE_BUTTON,
	ID_MODLISTBOX_INFO_BUTTON,

	ID_STATUSBAR_STATUS_ICON,
	ID_STATUSBAR_PROGRESS_BAR,

	ID_EXE_ROOT_FOLDER_BOX_TEXT,
	ID_EXE_ROOT_FOLDER_BOX,
	ID_EXE_SELECT_ROOT_BUTTON,
	ID_EXE_CHOICE_BOX,
	ID_EXE_CHOICE_REFRESH_BUTTON,
	ID_EXE_FRED_CHOICE_BOX,
	ID_EXE_FRED_CHOICE_REFRESH_BUTTON,

	ID_CLONE_PROFILE_DIALOG,
	ID_CLONE_PROFILE_NEWNAME,
	ID_CLONE_PROFILE_CHECKBOX,
	ID_DELETE_PROFILE_DIALOG,

	// Advanced settings page
	ID_FLAGLISTBOX,
	ID_SELECT_FLAG_SET,
	ID_CUSTOM_FLAGS_TEXT,
	ID_COMMAND_LINE_TEXT,
	ID_FLAG_SET_NOTES_TEXT,

	ID_NET_DOWNLOAD_NEWS,
	ID_EVENT_NET_DOWNLOAD_NEWS,
	ID_MORE_INFO_PRIVACY,
};

enum MainTabImageIDs {
	ID_TAB_WELCOME_IMAGE,
	ID_TAB_MOD_IMAGE,
	ID_TAB_BASIC_SETTINGS_IMAGE,
	ID_TAB_ADV_SETTINGS_IMAGE,
	ID_TAB_INSTALL_IMAGE,
};

enum StatusBarIconIDs {
	ID_SB_NO_CHANGE = -1,
	ID_SB_INFO,
	ID_SB_OK,
	ID_SB_WARNING,
	ID_SB_ERROR,

	ID_SB_MAX_ID,
};

enum ProfileDialogReturnValues {
	RETURN_CANCEL,
	RETURN_DO_CLONE,
	RETURN_CONFRIM_DELETE,
};

/** \defgroup Storage Storage locations */
/** @{*/
#define GET_PROFILE_STORAGEFOLDER()			wxStandardPaths::Get().GetUserDataDir()
/** @}*/

/** \defgroup Internal Store location */
/** @{ */
#define INT_CONFIG_FILE_LOCATION			_T("/wxlauncher/configlocation")	//!< string
/** @} */

/** \defgroup globalkeys Keys used in global config file */
/** @{*/
#define GBL_CFG_MAIN_AUTOSAVEPROFILES		_T("/main/autosaveprofiles") //!< bool
#define GBL_CFG_MAIN_LASTPROFILE			_T("/main/lastprofile")		//!< string, internal profile name

#define GBL_CFG_PROXY_TYPE					_T("/proxy/type")	//!< string
#define GBL_CFG_PROXY_SERVER				_T("/proxy/server")	//!< string
#define GBL_CFG_PROXY_PORT					_T("/proxy/port")	//!< int

#define GBL_CFG_NET_DOWNLOAD_NEWS			_T("/net/downloadnews")	//!< bool, true means autodownload
#define NEWS_LAST_TIME_FORMAT				_T("%Y %j %H %M %S")
#define GBL_CFG_NET_NEWS_LAST_TIME			_T("/net/lastdownloadnews") //!< string, formated time as NEWS_LAST_TIME_FORMAT
#define GBL_CFG_NET_THE_NEWS				_T("/net/thenews)")		//!< string, the formatted text (workin' for a livin'!)

#define GBL_CFG_OPT_CONFIG_FRED				_T("/opt/configfred")	//!< bool, true means show the user the FRED button and allow user to select FRED executable
/** @}*/

/** \defgroup profilekeys Keys used in profiles */
/** @{*/
#define PRO_CFG_MAIN_NAME					_T("/main/name")		//!< string, name of profile
#define PRO_CFG_MAIN_FILENAME				_T("/main/filename")	//!< string, full path to profile
#define PRO_CFG_MAIN_INITIALIZED			_T("/main/initialized")	//!< bool, indicates whether profile has been saved with initial GUI values

#define PRO_CFG_TC_ROOT_FOLDER				_T("/tc/folder")		//!< string, absolute path
#define PRO_CFG_TC_CURRENT_BINARY			_T("/tc/currentbinary")	//!< string, binary name
#define PRO_CFG_TC_CURRENT_MODLINE			_T("/tc/currentmodline")	//!< string, the entire line that should follow -mod
#define PRO_CFG_TC_CURRENT_MOD				_T("/tc/currentmod")	//!< string, the mod shortname (for modlist)
#define PRO_CFG_TC_CURRENT_FLAG_LINE		_T("/tc/flags")			//!< string, the flags that we as the modline to to make the cmdline
#define PRO_CFG_TC_CURRENT_FRED				_T("/tc/currentfred")	//!< string, FRED binary's name

#define PRO_CFG_VIDEO_RESOLUTION_WIDTH		_T("/video/width")		//!< int
#define PRO_CFG_VIDEO_RESOLUTION_HEIGHT		_T("/video/height")		//!< int
#define CFG_RES_FORMAT_STRING				_T("%d x %d")
#define PRO_CFG_VIDEO_BIT_DEPTH				_T("/video/depth")		//!< int
#define PRO_CFG_VIDEO_ANISOTROPIC			_T("/video/anisotropic")//!< int
#define PRO_CFG_VIDEO_ANTI_ALIAS			_T("/video/antialias")	//!< int
#define PRO_CFG_VIDEO_TEXTURE_FILTER		_T("/video/texturefilter")	//!< string

#define PRO_CFG_LIGHTING_PRESET				_T("/lighting/preset")	//!< string

#define PRO_CFG_SPEECH_VOICE				_T("/speech/voice")		//!< int, same as what the current engine uses
#define PRO_CFG_SPEECH_VOLUME				_T("/speech/volume")	//!< int
#define PRO_CFG_SPEECH_IN_TECHROOM			_T("/speech/intechroom")//!< bool
#define PRO_CFG_SPEECH_IN_BRIEFINGS			_T("/speech/inbriefings")//!< bool
#define PRO_CFG_SPEECH_IN_GAME				_T("/speech/ingame")	//!< bool
#define PRO_CFG_SPEECH_IN_MULTI				_T("/speech/inmulti")	//!< bool

#define PRO_CFG_NETWORK_TYPE				_T("/network/type")		//!< string
#define PRO_CFG_NETWORK_SPEED				_T("/network/speed")	//!< string
#define PRO_CFG_NETWORK_PORT				_T("/network/port")		//!< int
#define PRO_CFG_NETWORK_IP					_T("/network/ip")		//!< string

#define PRO_CFG_OPENAL_DEVICE				_T("/openal/device")	//!< string
#define PRO_CFG_OPENAL_CAPTURE_DEVICE		_T("/openal/capturedevice")	//!< string
#define PRO_CFG_OPENAL_EFX					_T("/openal/efx")		//!< bool
#define PRO_CFG_OPENAL_SAMPLE_RATE			_T("/openal/samplerate")//!< int

#define PRO_CFG_JOYSTICK_ID					_T("/joystick/id")		//!< int
#define PRO_CFG_JOYSTICK_FORCE_FEEDBACK		_T("/joystick/forcefeedback") //!< bool
#define PRO_CFG_JOYSTICK_DIRECTIONAL		_T("/joystick/directional") //!< bool
/** @}*/

/** \defgroup registrykeys Keys used in the registry or fs2_open.ini */
/** @{*/
extern const wxString REG_KEY_FOLDER_LOCATION;

extern const wxString REG_KEY_VIDEO_RESOLUTION_DEPTH;
extern const wxString REG_KEY_VIDEO_TEXTURE_FILTER;
extern const wxString REG_KEY_VIDEO_ANISOTROPIC;
extern const wxString REG_KEY_VIDEO_ANTI_ALIAS;

extern const wxString REG_KEY_AUDIO_OPENAL_DEVICE;
extern const wxString REG_KEY_AUDIO_FOLDER_CFG;
extern const wxString REG_KEY_AUDIO_FOLDER_REGISTRY;
extern const wxString REG_KEY_AUDIO_OPENAL_PLAYBACK_DEVICE;
extern const wxString REG_KEY_AUDIO_OPENAL_CAPTURE_DEVICE;
extern const wxString REG_KEY_AUDIO_OPENAL_EFX;
extern const wxString REG_KEY_AUDIO_OPENAL_SAMPLE_RATE;

extern const wxString REG_KEY_SPEECH_VOICE;
extern const wxString REG_KEY_SPEECH_VOLUME;
extern const wxString REG_KEY_SPEECH_IN_TECHROOM;
extern const wxString REG_KEY_SPEECH_IN_BRIEFINGS;
extern const wxString REG_KEY_SPEECH_IN_GAME;
extern const wxString REG_KEY_SPEECH_IN_MULTI;

extern const wxString REG_KEY_JOYSTICK_ID;
extern const wxString REG_KEY_JOYSTICK_FORCE_FEEDBACK;
extern const wxString REG_KEY_JOYSTICK_DIRECTIONAL;

extern const wxString REG_KEY_NETWORK_TYPE;
extern const wxString REG_KEY_NETWORK_SPEED;
extern const wxString REG_KEY_NETWORK_PORT;
extern const wxString REG_KEY_NETWORK_FOLDER_CFG;
extern const wxString REG_KEY_ROOT_FOLDER_CFG;
extern const wxString REG_KEY_NETWORK_FOLDER_REGISTRY;
extern const wxString REG_KEY_NETWORK_IP;
/** @}*/

/** \defgroup basicdefaults default values for basic settings */
/** @{*/
extern const long DEFAULT_VIDEO_RESOLUTION_WIDTH;
extern const long DEFAULT_VIDEO_RESOLUTION_HEIGHT;
extern const long DEFAULT_VIDEO_BIT_DEPTH;
extern const wxString DEFAULT_VIDEO_TEXTURE_FILTER;
extern const long DEFAULT_VIDEO_ANISOTROPIC;
extern const long DEFAULT_VIDEO_ANTI_ALIAS;

extern const wxString DEFAULT_AUDIO_OPENAL_DEVICE;
extern const wxString DEFAULT_AUDIO_OPENAL_PLAYBACK_DEVICE;
extern const wxString DEFAULT_AUDIO_OPENAL_CAPTURE_DEVICE;
extern const bool DEFAULT_AUDIO_OPENAL_EFX;
extern const long DEFAULT_AUDIO_OPENAL_SAMPLE_RATE;

extern const long DEFAULT_SPEECH_VOICE;
extern const long DEFAULT_SPEECH_VOLUME;
extern const bool DEFAULT_SPEECH_IN_TECHROOM;
extern const bool DEFAULT_SPEECH_IN_BRIEFINGS;
extern const bool DEFAULT_SPEECH_IN_GAME;
extern const bool DEFAULT_SPEECH_IN_MULTI;

extern const long DEFAULT_JOYSTICK_ID;
extern const bool DEFAULT_JOYSTICK_FORCE_FEEDBACK;
extern const bool DEFAULT_JOYSTICK_DIRECTIONAL;

extern const wxString DEFAULT_NETWORK_TYPE;
extern const wxString DEFAULT_NETWORK_SPEED;
extern const long DEFAULT_NETWORK_PORT;
extern const wxString DEFAULT_NETWORK_IP;
/** @}*/

/** \defgroup constants other constants */
/** @{*/
extern const unsigned int JOYMAN_INVALID_JOYSTICK;
/** @}*/

#endif
