#!/bin/sh
#
# Copyright 2006 Bart Martens <bart.martens@advalvas.be>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

set -e

mksymlink() {
	[ -e $1 ] || return -1
	[ ! -e $2 ] || return -1
	ln -s $1 $2 || return -1
	return 0
}

rmsymlink() {
	[ -e $1 ] || return 0
	[ -L $2 ] || return 0
	[ "$(readlink "$2")" = "$1" ] || return 0
	rm -f $2
}

uninstall_plugin() {
	rmsymlink /usr/lib/flashplugin-nonfree/libflashplayer.so /usr/lib/mozilla/plugins/libflashplayer.so
	rmsymlink /usr/lib/flashplugin-nonfree/flashplayer.xpt /usr/lib/mozilla/plugins/flashplayer.xpt
	rmsymlink /usr/lib/flashplugin-nonfree/libflashplayer.so /usr/lib/mozilla-snapshot/plugins/libflashplayer.so
	rmsymlink /usr/lib/flashplugin-nonfree/flashplayer.xpt /usr/lib/mozilla-snapshot/plugins/flashplayer.xpt
	rmsymlink /usr/lib/flashplugin-nonfree/libflashplayer.so /usr/lib/mozilla-firebird/plugins/libflashplayer.so
	rmsymlink /usr/lib/flashplugin-nonfree/flashplayer.xpt /usr/lib/mozilla-firebird/plugins/flashplayer.xpt
	rmsymlink /usr/lib/flashplugin-nonfree/libflashplayer.so /usr/lib/mozilla-firefox/plugins/libflashplayer.so
	rmsymlink /usr/lib/flashplugin-nonfree/flashplayer.xpt /usr/lib/mozilla-firefox/plugins/flashplayer.xpt
	rmsymlink /usr/lib/flashplugin-nonfree/libflashplayer.so /usr/lib/firefox/plugins/libflashplayer.so
	rmsymlink /usr/lib/flashplugin-nonfree/flashplayer.xpt /usr/lib/firefox/plugins/flashplayer.xpt
	rm -f /usr/lib/flashplugin-nonfree/libflashplayer.so
	rm -f /usr/lib/flashplugin-nonfree/flashplayer.xpt
	rm -f "/usr/share/doc/flashplugin-nonfree/Macromedia - End User License Agreement.html"
}

WITHLOCALFILE="false"
ACTION="install"

while [ $# -gt 0 ]
do
	case $1 in
		--uninstall|-u)
			ACTION="uninstall"
			;;
		--local-file|-l)
			WITHLOCALFILE="true"
			LOCALFILE="$2"/install_flash_player_7_linux.tar.gz
			shift
			;;
		*)
			echo "option not supported in this version"
			exit -1
			;;
	esac
	shift
done

case $ACTION in

	"install")

		UNPACKDIR=`mktemp -d -p /tmp flashplugin-nonfree.XXXXXX`
		cd "$UNPACKDIR"
		FAIL="false"

		if [ $WITHLOCALFILE = "true" ]; then

			cp $LOCALFILE "$UNPACKDIR" || FAIL="true"
			if [ $FAIL = "true" ]; then
				echo "cannot copy local file: $LOCALFILE"
				rm -rf "$UNPACKDIR"
				exit -1
			fi

		else # no local file

			# setting wget options
			:> wgetrc
			echo "noclobber = off" >> wgetrc
			echo "dir_prefix = ." >> wgetrc
			echo "dirstruct = off" >> wgetrc
			echo "verbose = off" >> wgetrc

			# checking the click path to the license and to the file to download
			if [ $FAIL = "false" ]; then
				WGETRC=wgetrc wget -q -O homepage.html http://macromedia.mplug.org/ || FAIL="true"
			fi
			if [ $FAIL = "false" ]; then
				MIRROR_UH="ok"
				WGETRC=wgetrc wget -q -O site_uh.html http://macromedia.mplug.org/site_uh.html || MIRROR_UH="nok"
				grep '"http://macromedia.mplug.org/site_uh.html"' homepage.html > /dev/null 2>&1 || MIRROR_UH="nok"
				grep '"http://www.macromedia.com/shockwave/download/license/desktop/"' site_uh.html > /dev/null 2>&1 || MIRROR_UH="nok"
				grep '"http://fpdownload.macromedia.com/get/flashplayer/current/install_flash_player_7_linux.tar.gz"' site_uh.html > /dev/null 2>&1 || MIRROR_UH="nok"
				MIRROR_RI="ok"
				WGETRC=wgetrc wget -q -O site_ri.html http://macromedia.rediris.es/site_ri.html || MIRROR_RI="nok"
				grep '"http://macromedia.rediris.es/site_ri.html"' homepage.html > /dev/null 2>&1 || MIRROR_RI="nok"
				grep '"http://www.macromedia.com/shockwave/download/license/desktop/"' site_ri.html > /dev/null 2>&1 || MIRROR_RI="nok"
				grep '"http://fpdownload.macromedia.com/get/flashplayer/current/install_flash_player_7_linux.tar.gz"' site_ri.html > /dev/null 2>&1 || MIRROR_RI="nok"
				if [ $MIRROR_UH = "nok" ] && [ $MIRROR_RI = "nok" ]; then
					FAIL="true"
				fi
			fi

			# downloading the license
			if [ $FAIL = "false" ]; then
				WGETRC=wgetrc wget -q -O "Macromedia - End User License Agreement.html" http://www.macromedia.com/shockwave/download/license/desktop/ || FAIL="true"
			fi

			# downloading the plugin
			if [ $FAIL = "false" ]; then
				WGETRC=wgetrc wget -q http://fpdownload.macromedia.com/get/flashplayer/current/install_flash_player_7_linux.tar.gz || FAIL="true"
				if [ $FAIL = "true" ]; then
					rm -f install_flash_player_7_linux.tar.gz
					FAIL="false"
					WGETRC=wgetrc wget -q http://fpdownload.macromedia.com.edgekey.net/get/flashplayer/current/install_flash_player_7_linux.tar.gz || FAIL="true"
				fi
				if [ $FAIL = "true" ]; then
					rm -f install_flash_player_7_linux.tar.gz
					FAIL="false"
					WGETRC=wgetrc wget -q http://e526.d.akamaiedge.net/get/flashplayer/current/install_flash_player_7_linux.tar.gz || FAIL="true"
				fi
				if [ $FAIL = "true" ]; then
					rm -f install_flash_player_7_linux.tar.gz
					FAIL="false"
					WGETRC=wgetrc wget -q http://fpdownload-marc.wip3.adobe.com/get/flashplayer/current/install_flash_player_7_linux.tar.gz || FAIL="true"
				fi
				if [ $FAIL = "true" ]; then
					rm -f install_flash_player_7_linux.tar.gz
					FAIL="false"
					WGETRC=wgetrc wget -q http://84.53.150.70/get/flashplayer/current/install_flash_player_7_linux.tar.gz || FAIL="true"
				fi
			fi
			if [ $FAIL = "false" ]; then
				echo "a835bc6613c76f62c74a50406bd5801d  install_flash_player_7_linux.tar.gz"| md5sum -c > /dev/null 2>&1 || FAIL="true"
			fi

			# failed
			if [ $FAIL = "true" ]; then
				echo "automatic installation failed due to network problems or upstream changes"
				rm -rf "$UNPACKDIR"
				exit -1
			fi

		fi # no local file

		# unpacking and checking the plugin
		if [ $FAIL = "false" ]; then
			tar xzf install_flash_player_7_linux.tar.gz || FAIL="true"
			if [ $FAIL = "true" ]; then
				echo "cannot unpack plugin"
				rm -rf "$UNPACKDIR"
				exit -1
			fi
		fi
		if [ $FAIL = "false" ]; then
			echo "a81fd3b03b8c6d6e5a14298110718d3f  install_flash_player_7_linux/flashplayer.xpt"| md5sum -c > /dev/null 2>&1 || FAIL="true"
			echo "37b8b6030388d23eeb8150eb67ad063e  install_flash_player_7_linux/libflashplayer.so"| md5sum -c > /dev/null 2>&1 || FAIL="true"
			if [ $FAIL = "true" ]; then
				echo "plugin changed, not trusted"
				rm -rf "$UNPACKDIR"
				exit -1
			fi
		fi

		# installing
		if [ $FAIL = "false" ]; then
			uninstall_plugin # update = uninstall + install
			install -m 555 install_flash_player_7_linux/libflashplayer.so /usr/lib/flashplugin-nonfree || FAIL="true"
			install -m 444 install_flash_player_7_linux/flashplayer.xpt /usr/lib/flashplugin-nonfree || FAIL="true"
			if [ $WITHLOCALFILE = "false" ]; then
				install -m 444 "Macromedia - End User License Agreement.html" /usr/share/doc/flashplugin-nonfree || FAIL="true"
			fi
			mksymlink /usr/lib/flashplugin-nonfree/libflashplayer.so /usr/lib/mozilla/plugins/libflashplayer.so || FAIL="true"
			mksymlink /usr/lib/flashplugin-nonfree/flashplayer.xpt   /usr/lib/mozilla/plugins/flashplayer.xpt || FAIL="true"
			mksymlink /usr/lib/flashplugin-nonfree/libflashplayer.so /usr/lib/firefox/plugins/libflashplayer.so || FAIL="true"
			mksymlink /usr/lib/flashplugin-nonfree/flashplayer.xpt   /usr/lib/firefox/plugins/flashplayer.xpt || FAIL="true"
			if [ $FAIL = "true" ]; then
				echo "installation failed"
				rm -rf "$UNPACKDIR"
				uninstall_plugin # cleanup failed install
				exit -1
			fi
		fi

		# cleaning up
		cd /
		rm -rf "$UNPACKDIR"

		# Chrome update
		if [ -x /usr/sbin/update-mozilla-chrome ]; then
			/usr/sbin/update-mozilla-chrome > /dev/null 2>&1 || FAIL="true"
		fi
		if [ -x /usr/sbin/update-mozilla-firefox-chrome ]; then
			/usr/sbin/update-mozilla-firefox-chrome > /dev/null 2>&1 || FAIL="true"
		fi
		if [ -x /usr/sbin/update-firefox-chrome ]; then
			/usr/sbin/update-firefox-chrome > /dev/null 2>&1 || FAIL="true"
		fi
		if [ $FAIL = "true" ]; then
			echo "updating chrome failed"
			# not doing uninstall_plugin here
			exit -1
		fi
		;;

	"uninstall")
		uninstall_plugin
		;;

	*)

		echo "unknown action, try $0 -h"
		exit -1
		;;

esac

exit 0

# vim: ts=2 sw=2

