#!/usr/bin/python
import sys
from sys import stdout
#import apt, apt_pkg
import re
import os
import copy
import thread

import Envy
from Envy import abstraction
from Envy import ui
from Envy.abstraction import *

#print >> stdout, '''
#+-----------------------------------------------------------------+
#| Code | Version Candidate | Installed | Compatible | Recommended |
#|-----------------------------------------------------------------|
#|  1   | 177.02            |     -     |     *      |      *      |
#|------|-------------------|-----------|------------|-------------|
#|  2   | 177.02            | 177.01    |     *      |      *      |
#|------|-------------------|-----------|------------|-------------|
#|  3   | 177.02            |     -     |     *      |      *      |
#|------|-------------------|-----------|------------|-------------|
#|  4   | 177.02            |     -     |     -      |      *      |
#+-----------------------------------------------------------------+

#Select the code corresponding to the driver you wish to install or
#type any other number to get back to the previous menu
#'''

class progressBar(object):
    """ Creates a text-based progress bar. Call the object with the `print'
        command to see the progress bar, which looks something like this:
            
        [=======>        22%                  ]
        
        You may specify the progress bar's width, min and max values on init.
    """

    def __init__(self, minValue = 0.0, maxValue = 100.0, totalWidth=80, filename='file'):
        self.progBar = "[]"   # This holds the progress bar string
        self.min = minValue
        self.max = maxValue
        self.span = maxValue - minValue
        self.width = totalWidth
        self.amount = 0       # When amount == max, we are 100% done 
        #self.updateUi(0.0)  # Build progress bar string
        
    
    def setText(self, message):
        print message + '\n'
    
    def updateUi(self, percentDone=0.0):
        """ Update the progress bar with the new amount (with min and max
            values set at initialization; if it is over or under, it takes the
            min or max value as a default. """
        if percentDone < 0.0: percentDone = 0.0
        if percentDone > 100.0: percentDone = 100.0

        # Figure out how many hash bars the percentage should be
        allFull = self.width - 2
        
        numHashes = (percentDone / 100.0) * allFull
        numHashes = int(round(numHashes))

        # Build a progress bar with an arrow of equal signs; special cases for
        # empty and full
        if numHashes == 0:
            self.progBar = "[>%s]" % (' '*(allFull-1))
        elif numHashes == allFull:
            self.progBar = "[%s]" % ('='*allFull)
        else:
            self.progBar = "[%s>%s]" % ('='*(numHashes-1),
                                        ' '*(allFull-numHashes))

        # figure out where to put the percentage, roughly centered
        percentPlace = (len(self.progBar) / 2) - len(str(percentDone)) 
        percentString = str(percentDone) + "%"

        # slice the percentage into the bar
        self.progBar = ''.join([self.progBar[0:percentPlace], percentString,
                                self.progBar[percentPlace+len(percentString):]
                                ])
        self.writeProgress()

    def updateLabel(self, item, total):
    
        message = '\n\n' + self.ui.string_text_download + ' %d/%d...' % (item, total)
        self.setText(message)
        self.updateUi(0.0)

    def writeProgress(self):
        sys.stdout.write('\r%s' % (self.progBar))
        sys.stdout.flush()
    
    def callback(self, transferred, blocksize, totalsize):
        if (totalsize != 0):
            percentDone = float("%.01f"% (transferred * blocksize * 100.0 / totalsize))
        else:
            percentDone = 0.0
        self.updateUi(percentDone)

    def start(self):
        pass
    
    def stop(self):
        pass
    
    def done(self, *args):
        pass
    
    def update(self, *args):
        pass
    
    def updateStatus(self, uri, descr, shortDescr, status):
        pass
    
    def pulse(self):
        pass

class Interface:

    def __init__(self):
        progress = progressBar()
        self.abstract = abstraction.Abstraction(progress, True)
        self.itemsCopy = copy.deepcopy(self.abstract.uiDetails)
        self.linetxt = []
        self.ui = ui.AbstractUI()

    
    def mainPage(self):
        left_margin = 1
        border = ' ' * 4
        lines = []
        lenlinetxt = []
        for i in self.linetxt:#calculate the lenght of each element of linetxt and append them to lenlinetxt
            lenlinetxt.append(len(i))
        
        diffs = []
        diffspc = []
        it = 0#iterator
        it <= len(self.linetxt)#make sure it's not out of range
        for line in self.linetxt:
            maxlen = max(lenlinetxt)
            diffstmp = (maxlen - lenlinetxt[it]) / 2
            diffs.append(diffstmp)
            if it == 0 or it == len(self.linetxt)-1:#treat the 1st and the last line differently
                diffspctmp = '-' * diffs[it]#put -
                #rightmargin = '-' * (maxlen - (diffs[it] + lenlinetxt[it]) )
                rightmargin = '-' * (maxlen - lenlinetxt[it] )
            else:
                diffspctmp = ' ' * diffs[it]#put ' '
                #rightmargin = ' ' * (maxlen - (diffs[it] + lenlinetxt[it]) )
                rightmargin = ' ' * (maxlen - lenlinetxt[it] )
            diffspc.append(diffspctmp)
            genline = self.linetxt[it] + rightmargin #diffspc[it] +
            lines.append(genline)
            it += 1
        
        maxintlen = len(border)*2 + max(diffs)*2
        print '\n'
        print ' ' * left_margin + '+' + ('-' * len(border)) + lines[0] + ('-' * len(border)) + '+'#1st line
        for line in lines[1:-1]:
            print ' ' * left_margin + '|' + border + line + border + '|'# + '\n'
        print ' ' * left_margin + '+' + ('-' * len(border)) + lines[len(self.linetxt)-1] + ('-' * len(border)) + '+'#last line
        linetxt2 = []
        for l in lines:#calculate the lenght of each element of linetxt and append them to lenlinetxt
            linetxt2.append(len(l))
    
    def driverPage(self, driver):
        menuItems = [
                     self.ui.string_menu_header_number,
                     self.ui.string_menu_header_candidate,
                     self.ui.string_menu_header_installed,
                     self.ui.string_menu_header_compatible,
                     self.ui.string_menu_header_recommended,
                     ]
        
        leftMargin = 1
        border = ' ' * 1
        total = []
        codeLen = []
        candidateLen = []
        installedLen = []
        compatibleLen = []
        recommendedLen = []
        
        globallength = [codeLen, candidateLen, installedLen]
        
        
        
        for elem in self.itemsCopy[driver]:
            details = self.itemsCopy[driver][elem]
            
            
            if self.abstract.uiDetails[driver][elem]['compatible']:
                details['compatible'] = '+'
            else:
                details['compatible'] = '-'
            
            if self.abstract.uiDetails[driver][elem]['recommended']:
                details['recommended'] = '+'
            else:
                details['recommended'] = '-'
            
            if not self.abstract.uiDetails[driver][elem]['installed']:
                details['installed'] = '-'
            
            
            
            codeLen.append(len(str(elem)))
            installedLen.append(len(details['installed']))
            
            
            candidateLen.append(len(details['candidate']))
            compatibleLen.append(len(details['compatible']))

            recommendedLen.append(len(details['recommended']))
            
            
        
        for elem in menuItems:
            codeLen.append(len(menuItems[0]))
            candidateLen.append(len(menuItems[1]))
            installedLen.append(len(menuItems[2]))
            compatibleLen.append(len(menuItems[3]))
            recommendedLen.append(len(menuItems[4]))
        
        maxCode = max(codeLen)
        maxCandidate = max(candidateLen)
        maxInstalled = max(installedLen)
        maxCompatible = max(compatibleLen)
        maxRecommended = max(recommendedLen)
        
        
        #maxline = len(menuItems) * border + leftMargin + 1 + maxCode + maxCandidate + maxInstalled + maxCompatible + maxRecommended
        
        rightMargin = len(border + menuItems[0] + ' '*(maxCode - len(menuItems[0])) + border + '|' + \
border + menuItems[1] + ' '*(maxCandidate - len(menuItems[1])) + border + '|' + \
border + menuItems[2] + ' '*(maxInstalled - len(menuItems[2])) + border + '|' + \
border + menuItems[3] + ' '*(maxCompatible - len(menuItems[3])) + border + '|' + \
border + menuItems[4] + ' '*(maxRecommended - len(menuItems[4])) + border)
        #print ' ' * leftMargin + '|' + '-'* (rightMargin - leftMargin) + '|'
        
        print ' ' * leftMargin + '+' + '-' * rightMargin + '+'
        
        print ' ' * leftMargin + '|' + border + menuItems[0] + ' '*(maxCode - len(menuItems[0])) + border + '|' + \
border + menuItems[1] + ' '*(maxCandidate - len(menuItems[1])) + border + '|' + \
border + menuItems[2] + ' '*(maxInstalled - len(menuItems[2])) + border + '|' + \
border + menuItems[3] + ' '*(maxCompatible - len(menuItems[3])) + border + '|' + \
border + menuItems[4] + ' '*(maxRecommended - len(menuItems[4])) + border + '|'
        
        
        
        
        for elem in self.itemsCopy[driver]:
            print ' ' * leftMargin + '|' + '-' * rightMargin + '|'
            
            print ' ' * leftMargin + '|' + border + str(elem) + ' '*(maxCode - len(str(elem))) + border + '|' + \
border + self.itemsCopy[driver][elem]['candidate'] + ' '*(maxCandidate - len(self.itemsCopy[driver][elem]['candidate'])) + border + '|' + \
border + self.itemsCopy[driver][elem]['installed'] + ' '*(maxInstalled - len(self.itemsCopy[driver][elem]['installed'])) + border + '|' + \
border + self.itemsCopy[driver][elem]['compatible'] + ' '*(maxCompatible - len(self.itemsCopy[driver][elem]['compatible'])) + border + '|' + \
border + self.itemsCopy[driver][elem]['recommended'] + ' '*(maxRecommended - len(self.itemsCopy[driver][elem]['recommended'])) + border + '|'
            
            if elem == len(self.itemsCopy[driver])-1:
#                print ' ' * leftMargin + '|' + '-' * rightMargin + '|'
#            else:
                print ' ' * leftMargin + '+' + '-' * rightMargin + '+'

    
    '''Welcome'''
    def welcomeMenu(self):
        self.linetxt = ['-', '', '         Welcome to EnvyNG', 'Developed by Alberto Milone (aka tseliot)', '', '-']
        self.mainPage()

    '''Main Menu'''
    def mainMenu(self):
        self.linetxt = [
                        '', 'EnvyNG Menu', '',
                        '1 - ' + self.ui.string_text_install_nvidia, '',
                        '2 - ' + self.ui.string_text_uninstall_nvidia, '',
                        '3 - ' + self.ui.string_text_install_ati, '',
                        '4 - ' + self.ui.string_text_uninstall_ati, '',
                        '5 - ' + self.ui.string_text_restart_xorg, '',
                        '6 - ' + self.ui.string_text_restart_computer, '',
                        '7 - ' + self.ui.string_text_exit, '',
                        self.ui.string_text_black_screen, ''
                        ]

        while 1:
            self.mainPage()
            reply = raw_input(self.ui.string_select_text_action).strip()
            if reply == '1':
                a.driverMenu('nvidia')
                break
            elif reply == '2':
                self.process(self.abstract.uninstallDriverType, 'nvidia')
                self.abstract.setupX('remove', package=None)
                self.restartMenu('computer')
                break
            elif reply == '3':
                a.driverMenu('fglrx')
                break
            elif reply == '4':
                self.process(self.abstract.uninstallDriverType, 'fglrx')
                self.abstract.setupX('remove', package=None)
                self.restartMenu('computer')
                break
            elif reply == '5':
                self.restartMenu('xserver')
                break
            elif reply == '6':
                self.restartMenu('computer')
                break
            elif reply == '7':
                sys.exit()
                break

    def driverMenu(self, driver):
        while 1:
            self.driverPage(driver)
            mystr = self.ui.string_select_install_operation
            reply = raw_input(self.formatString(mystr)).strip()
            try:
                reply = int(reply)
            except ValueError:
                pass
            if self.itemsCopy[driver].get(reply) != None:#.get('name')
                package = self.itemsCopy[driver][reply]['name']
                
                
                self.process(self.abstract.install, package)
                self.abstract.setupX('install', package=package)
                self.restartMenu('computer')
                break
            else:

                self.mainMenu()
                break
    
    def restartMenu(self, toRestart):
        while 1:
            if toRestart == 'xserver':#
                xsrv = raw_input(self.ui.string_operation_complete_xorg_restart).strip()
                toCall = self.abstract.restartX
                alternate = self.ui.string_remind_xserver_restart
            else:
                xsrv = raw_input(self.ui.string_operation_complete_restart).strip()
                toCall = self.abstract.restartSystem
                alternate = self.ui.string_remind_computer_restart
            
            if xsrv == '0':
                toCall()
                break
                sys.exit()
            elif xsrv == '1':
                print alternate
                break
                sys.exit()


    def formatString(self, myString):
        length = 75
        lines = []
        words = ''
        myString = myString.split(' ')
        for word in myString:
            words += word.strip() + ' '
            if len(words) >= length:
                lines.append(words)
                words = ''
        if len(words) > 0:
            lines.append(words)
        
        line = '\n'.join(lines) + '\n'
        return line
    
    def process(self, myFunction, *myArgs):
        '''
        Calls a function with some optional arguments
        
        and catches exceptions
        '''
        try:
            it = 0
            for arg in myArgs:
                it +=1
            
            if it > 0:
                myFunction(myArgs)
            else:
                myFunction()
        except(LockException, HeadersException, PackageException), e:
            error = str(e).strip()

            self.dialog(self.ui.string_text_error, error)
            print
            sys.exit()
        else:
            self.dialog(self.ui.string_text_success, self.ui.string_operation_complete)
            print
            #sys.exit()
        
    def dialog(self, messageType, message):
        length = 40
        self.linetxt = [
                        '', messageType + ':', '',
                        ]
        words = ''
        message = message.split(' ')
        for word in message:
            words += word.strip() + ' '
            if len(words) >= length:
                self.linetxt.append(words)
                words = ''
        if len(words) > 0:
            self.linetxt.append(words)
        self.linetxt.append('')
        self.linetxt.append('')
        self.mainPage()

    def uninstallAll(self):
        self.abstract.uninstallAll()
        self.restartMenu('computer')

if __name__ == '__main__':
    a = Interface()
    
    if len(sys.argv) < 2:
        a.welcomeMenu()
        a.mainMenu()
    elif sys.argv[1] == 'restore':
        a.uninstallAll()
    print

