/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.Request;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.Signer;
import com.amazonaws.auth.SigningAlgorithm;
import com.amazonaws.util.HttpUtils;
import com.amazonaws.util.StringInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.MessageDigest;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public abstract class AbstractAWSSigner
implements Signer {
    private static final String DEFAULT_ENCODING = "UTF-8";

    protected String signAndBase64Encode(String data, String key, SigningAlgorithm algorithm) throws AmazonClientException {
        try {
            return this.signAndBase64Encode(data.getBytes(DEFAULT_ENCODING), key, algorithm);
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    protected String signAndBase64Encode(byte[] data, String key, SigningAlgorithm algorithm) throws AmazonClientException {
        try {
            byte[] signature = this.sign(data, key.getBytes(DEFAULT_ENCODING), algorithm);
            return new String(Base64.encodeBase64((byte[])signature));
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    protected byte[] sign(String stringData, byte[] key, SigningAlgorithm algorithm) throws AmazonClientException {
        try {
            byte[] data = stringData.getBytes(DEFAULT_ENCODING);
            return this.sign(data, key, algorithm);
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    protected byte[] sign(byte[] data, byte[] key, SigningAlgorithm algorithm) throws AmazonClientException {
        try {
            Mac mac = Mac.getInstance(algorithm.toString());
            mac.init(new SecretKeySpec(key, algorithm.toString()));
            return mac.doFinal(data);
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    protected byte[] hash(String text) throws AmazonClientException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(text.getBytes(DEFAULT_ENCODING));
            return md.digest();
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to compute hash while signing request: " + e.getMessage(), e);
        }
    }

    protected byte[] hash(byte[] data) throws AmazonClientException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(data);
            return md.digest();
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to compute hash while signing request: " + e.getMessage(), e);
        }
    }

    protected String getCanonicalizedQueryString(Map<String, String> parameters) {
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        sorted.putAll(parameters);
        StringBuilder builder = new StringBuilder();
        Iterator pairs = sorted.entrySet().iterator();
        while (pairs.hasNext()) {
            Map.Entry pair = pairs.next();
            String key = (String)pair.getKey();
            String value = (String)pair.getValue();
            builder.append(HttpUtils.urlEncode(key, false));
            builder.append("=");
            builder.append(HttpUtils.urlEncode(value, false));
            if (!pairs.hasNext()) continue;
            builder.append("&");
        }
        return builder.toString();
    }

    protected String getCanonicalizedQueryString(Request<?> request) {
        if (HttpUtils.usePayloadForQueryParameters(request)) {
            return "";
        }
        return this.getCanonicalizedQueryString(request.getParameters());
    }

    protected byte[] getBinaryRequestPayload(Request<?> request) {
        if (HttpUtils.usePayloadForQueryParameters(request)) {
            String encodedParameters = HttpUtils.encodeParameters(request);
            if (encodedParameters == null) {
                return new byte[0];
            }
            try {
                return encodedParameters.getBytes(DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                throw new AmazonClientException("Unable to encode string into bytes");
            }
        }
        return this.getBinaryRequestPayloadWithoutQueryParams(request);
    }

    protected String getRequestPayload(Request<?> request) {
        return this.newString(this.getBinaryRequestPayload(request));
    }

    protected String getRequestPayloadWithoutQueryParams(Request<?> request) {
        return this.newString(this.getBinaryRequestPayloadWithoutQueryParams(request));
    }

    protected byte[] getBinaryRequestPayloadWithoutQueryParams(Request<?> request) {
        try {
            int bytesRead;
            InputStream content = request.getContent();
            if (content == null) {
                return new byte[0];
            }
            if (content instanceof StringInputStream) {
                return ((StringInputStream)content).getString().getBytes(DEFAULT_ENCODING);
            }
            if (!content.markSupported()) {
                throw new AmazonClientException("Unable to read request payload to sign request.");
            }
            content.mark(-1);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[5120];
            while ((bytesRead = content.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, bytesRead);
            }
            byteArrayOutputStream.close();
            content.reset();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to read request payload to sign request: " + e.getMessage(), e);
        }
    }

    protected String getCanonicalizedResourcePath(String resourcePath) {
        if (resourcePath == null || resourcePath.length() == 0) {
            return "/";
        }
        return HttpUtils.urlEncode(resourcePath, true);
    }

    protected String getCanonicalizedEndpoint(URI endpoint) {
        String endpointForStringToSign = endpoint.getHost().toLowerCase();
        if (HttpUtils.isUsingNonDefaultPort(endpoint)) {
            endpointForStringToSign = endpointForStringToSign + ":" + endpoint.getPort();
        }
        return endpointForStringToSign;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AWSCredentials sanitizeCredentials(AWSCredentials credentials) {
        String accessKeyId = null;
        String secretKey = null;
        String token = null;
        AWSCredentials aWSCredentials = credentials;
        synchronized (aWSCredentials) {
            accessKeyId = credentials.getAWSAccessKeyId();
            secretKey = credentials.getAWSSecretKey();
            if (credentials instanceof AWSSessionCredentials) {
                token = ((AWSSessionCredentials)credentials).getSessionToken();
            }
        }
        if (secretKey != null) {
            secretKey = secretKey.trim();
        }
        if (accessKeyId != null) {
            accessKeyId = accessKeyId.trim();
        }
        if (token != null) {
            token = token.trim();
        }
        if (credentials instanceof AWSSessionCredentials) {
            return new BasicSessionCredentials(accessKeyId, secretKey, token);
        }
        return new BasicAWSCredentials(accessKeyId, secretKey);
    }

    protected String newString(byte[] bytes) {
        try {
            return new String(bytes, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Unable to encode bytes to String", e);
        }
    }

    protected abstract void addSessionCredentials(Request<?> var1, AWSSessionCredentials var2);
}

